/*
 * Decompiled with CFR 0.152.
 */
package com.ma.config;

import com.ma.config.GeneralClientConfig;
import com.ma.tools.math.MathUtils;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="mana-and-artifice", bus=Mod.EventBusSubscriber.Bus.MOD)
public class MAClientConfig {
    public static final GeneralClientConfig CLIENT;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static HudMode HUD_MODE;
    public static CodexMode CODEX_BACK_MODE;
    public static HudPos HUD_POS;
    public static PinnedRecipeSize PIN_SIZE;

    @SubscribeEvent
    public static void onModConfigEvent(ModConfig.ModConfigEvent configEvent) {
        if (configEvent.getConfig().getSpec() == CLIENT_SPEC) {
            MAClientConfig.bakeConfig();
        }
    }

    public static void bakeConfig() {
        HUD_MODE = HudMode.values()[MathUtils.clamp((Integer)GeneralClientConfig.HIDE_HUD_MODE.get(), 0, HudMode.values().length - 1)];
        CODEX_BACK_MODE = CodexMode.values()[MathUtils.clamp((Integer)GeneralClientConfig.CODEX_BACK_STYLE.get(), 0, CodexMode.values().length - 1)];
        HUD_POS = HudPos.values()[MathUtils.clamp((Integer)GeneralClientConfig.HUD_POSITION.get(), 0, HudPos.values().length - 1)];
        PIN_SIZE = PinnedRecipeSize.values()[MathUtils.clamp((Integer)GeneralClientConfig.PINNED_RECIPE_SCALE.get(), 0, PinnedRecipeSize.values().length - 1)];
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(GeneralClientConfig::new);
        CLIENT = (GeneralClientConfig)specPair.getLeft();
        CLIENT_SPEC = (ForgeConfigSpec)specPair.getRight();
    }

    public static enum PinnedRecipeSize {
        Small("gui.mana-and-artifice.pin_recipe_size.small"),
        Medium("gui.mana-and-artifice.pin_recipe_size.medium"),
        Large("gui.mana-and-artifice.pin_recipe_size.large");

        private String localizationKey;

        private PinnedRecipeSize(String localizationKey) {
            this.localizationKey = localizationKey;
        }

        public String getLocalizationKey() {
            return this.localizationKey;
        }
    }

    public static enum HudPos {
        TopLeft("gui.mana-and-artifice.hud_pos.top_left"),
        TopCenter("gui.mana-and-artifice.hud_pos.top_center"),
        TopRight("gui.mana-and-artifice.hud_pos.top_right"),
        MiddleRight("gui.mana-and-artifice.hud_pos.middle_right"),
        BottomRight("gui.mana-and-artifice.hud_pos.bottom_right"),
        BottomCenter("gui.mana-and-artifice.hud_pos.bottom_center"),
        BottomLeft("gui.mana-and-artifice.hud_pos.bottom_left"),
        MiddleLeft("gui.mana-and-artifice.hud_pos.middle_left");

        private String localizationKey;

        private HudPos(String localizationKey) {
            this.localizationKey = localizationKey;
        }

        public String getLocalizationKey() {
            return this.localizationKey;
        }
    }

    public static enum CodexMode {
        EscOutUIBack("gui.mana-and-artifice.codex_mode.esc_out_ui_back"),
        EscUIBack("gui.mana-and-artifice.codex_mode.esc_ui_back"),
        RMouseUIBackEscOut("gui.mana-and-artifice.codex_mode.rmouse_ui_back_esc_out"),
        RMouseUIEscBack("gui.mana-and-artifice.codex_mode.rmouse_ui_esc_back");

        private String localizationKey;

        private CodexMode(String localizationKey) {
            this.localizationKey = localizationKey;
        }

        public String getLocalizationKey() {
            return this.localizationKey;
        }
    }

    public static enum HudMode {
        AlwaysShow("gui.mana-and-artifice.hud_mode.always_show"),
        ConditionalShow("gui.mana-and-artifice.hud_mode.conditional_show"),
        AlwaysHide("gui.mana-and-artifice.hud_mode.never_show");

        private String localizationKey;

        private HudMode(String localizationKey) {
            this.localizationKey = localizationKey;
        }

        public String getLocalizationKey() {
            return this.localizationKey;
        }
    }
}

