/*
 * Decompiled with CFR 0.152.
 */
package com.ma.config;

import com.ma.config.MAEntityConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Consumer;
import net.minecraft.entity.EntityType;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.ForgeConfigSpec;

public class EntityConfig {
    private static HashMap<Biome.Category, HashMap<EntityType<?>, Entry>> _entityBiomeBlacklist = new HashMap();
    private static HashMap<EntityType<?>, ForgeConfigSpec.ConfigValue<String>> _blacklistedDimensions;
    private static ArrayList<EntityType<?>> _configurableOverworldTypes;
    private static ArrayList<EntityType<?>> _configurableNetherTypes;
    private static HashMap<EntityType<?>, Integer> _spawnRateOverrides;
    private static final int no_mob_spawn_weight = 0;
    private static final int nether_mob_spawn_weight = 4;
    private static final int mob_spawn_weight = 16;
    private static final int mob_spawn_min = 1;
    private static final int mob_spawn_max = 3;

    public static void registerConfigurableEntityType(EntityType<?>[] overworldtypes, EntityType<?>[] nethertypes) {
        int i;
        for (i = 0; i < overworldtypes.length; ++i) {
            _configurableOverworldTypes.add(overworldtypes[i]);
        }
        for (i = 0; i < nethertypes.length; ++i) {
            _configurableNetherTypes.add(nethertypes[i]);
        }
    }

    public static void addSpawnWeightOverride(EntityType<?> type, int weight) {
        _spawnRateOverrides.put(type, weight);
    }

    public static void initializeConfigs() {
        ForgeConfigSpec.Builder serverBuilder = MAEntityConfig.BUILDER;
        serverBuilder.push("Dimension-Level Blacklists");
        _configurableOverworldTypes.forEach((Consumer<EntityType<?>>)((Consumer<EntityType>)t -> {
            serverBuilder.push(t.getRegistryName().toString());
            _blacklistedDimensions.put((EntityType<?>)t, (ForgeConfigSpec.ConfigValue<String>)serverBuilder.comment("Comma separated list of dimension ids that this mob type shouldn't spawn in").define("blacklist", (Object)""));
            serverBuilder.pop();
        }));
        _configurableNetherTypes.forEach((Consumer<EntityType<?>>)((Consumer<EntityType>)t -> {
            serverBuilder.push(t.getRegistryName().toString());
            _blacklistedDimensions.put((EntityType<?>)t, (ForgeConfigSpec.ConfigValue<String>)serverBuilder.comment("Comma separated list of dimension ids that this mob type shouldn't spawn in").define("blacklist", (Object)""));
            serverBuilder.pop();
        }));
        serverBuilder.pop();
        Biome.Category[] categories = Biome.Category.values();
        for (int i = 0; i < categories.length; ++i) {
            EntityConfig.initializeConfigforBiome(serverBuilder, categories[i]);
        }
        MAEntityConfig.finalizeServerConfig();
    }

    private static void initializeConfigforBiome(ForgeConfigSpec.Builder serverBuilder, Biome.Category category) {
        switch (category) {
            case NETHER: {
                EntityConfig.initialize(serverBuilder, category, 0, 1, 3, _configurableOverworldTypes);
                EntityConfig.initialize(serverBuilder, category, 4, 1, 3, _configurableNetherTypes);
                break;
            }
            case MUSHROOM: 
            case THEEND: 
            case NONE: {
                EntityConfig.initialize(serverBuilder, category, 0, 1, 3, _configurableOverworldTypes);
                EntityConfig.initialize(serverBuilder, category, 0, 1, 3, _configurableNetherTypes);
                break;
            }
            default: {
                EntityConfig.initialize(serverBuilder, category, 0, 1, 3, _configurableNetherTypes);
                EntityConfig.initialize(serverBuilder, category, 16, 1, 3, _configurableOverworldTypes);
            }
        }
    }

    private static void initialize(ForgeConfigSpec.Builder serverBuilder, Biome.Category biomeCategory, int defaultWeight, int defaultMinSize, int defaultMaxSize, ArrayList<EntityType<?>> entityTypeList) {
        serverBuilder.push(biomeCategory.func_222352_a());
        _entityBiomeBlacklist.put(biomeCategory, new HashMap());
        entityTypeList.forEach((Consumer<EntityType<?>>)((Consumer<EntityType>)t -> {
            serverBuilder.push(t.getRegistryName().toString());
            _entityBiomeBlacklist.get(biomeCategory).put((EntityType<?>)t, new Entry(serverBuilder, _spawnRateOverrides.getOrDefault(t, defaultWeight), defaultMinSize, defaultMaxSize));
            serverBuilder.pop();
        }));
        serverBuilder.pop();
    }

    public static HashMap<EntityType<?>, Entry> getSpawnsFor(Biome.Category category) {
        return _entityBiomeBlacklist.getOrDefault(category, new HashMap());
    }

    public static boolean isDimensionBlacklisted(EntityType<?> type, RegistryKey<World> dimension) {
        if (!_blacklistedDimensions.containsKey(type)) {
            return false;
        }
        String dimensionID = dimension.func_240901_a_().toString();
        return ((String)_blacklistedDimensions.get(type).get()).contains(dimensionID);
    }

    static {
        _configurableOverworldTypes = new ArrayList();
        _configurableNetherTypes = new ArrayList();
        _blacklistedDimensions = new HashMap();
        _spawnRateOverrides = new HashMap();
    }

    public static class Entry {
        private final ForgeConfigSpec.IntValue _config_weight;
        private final ForgeConfigSpec.IntValue _config_min_pack_size;
        private final ForgeConfigSpec.IntValue _config_max_pack_size;
        private int weight = -1;
        private int minSize = -1;
        private int maxSize = -1;

        public Entry(ForgeConfigSpec.Builder serverBuilder, int defaultWeight, int defaultMinSize, int defaultMaxSize) {
            this._config_weight = serverBuilder.comment("Spawn Weight (0 disables)").defineInRange("spawnWeight", defaultWeight, 0, 9999);
            this._config_min_pack_size = serverBuilder.comment("Min Pack Size").defineInRange("minPackSize", defaultMinSize, 1, 3);
            this._config_max_pack_size = serverBuilder.comment("Max Pack Size").defineInRange("maxPackSize", defaultMaxSize, 1, 5);
        }

        public int getWeight() {
            if (this.weight == -1) {
                this.weight = (Integer)this._config_weight.get();
            }
            return this.weight;
        }

        public int getMinSize() {
            if (this.minSize == -1) {
                this.minSize = (Integer)this._config_min_pack_size.get();
            }
            return this.minSize;
        }

        public int getMaxSize() {
            if (this.maxSize == -1) {
                this.maxSize = (Integer)this._config_max_pack_size.get();
            }
            return this.maxSize;
        }
    }
}

