/*
 * Decompiled with CFR 0.152.
 */
package com.ma.commands;

import com.ma.Registries;
import com.ma.api.spells.base.ISpellComponent;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;

public class SpellPartArgument
implements ArgumentType<ISpellComponent> {
    private static final Collection<String> EXAMPLES = Arrays.asList("mana-and-artifice:shapes/touch", "mana-and-artifice:components/break", "mana-and-artifice:modifiers/damage");
    public static final DynamicCommandExceptionType PART_BAD_ID = new DynamicCommandExceptionType(p_208696_0_ -> new TranslationTextComponent("argument.item.id.invalid", new Object[]{p_208696_0_}));

    public ISpellComponent parse(StringReader reader) throws CommandSyntaxException {
        int i = reader.getCursor();
        ResourceLocation resourcelocation = ResourceLocation.func_195826_a((StringReader)reader);
        if (Registries.Shape.containsKey(resourcelocation)) {
            return (ISpellComponent)Registries.Shape.getValue(resourcelocation);
        }
        if (Registries.Component.containsKey(resourcelocation)) {
            return (ISpellComponent)Registries.Component.getValue(resourcelocation);
        }
        if (Registries.Modifier.containsKey(resourcelocation)) {
            return (ISpellComponent)Registries.Modifier.getValue(resourcelocation);
        }
        reader.setCursor(i);
        throw PART_BAD_ID.createWithContext((ImmutableStringReader)reader, (Object)resourcelocation.toString());
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        ArrayList all = new ArrayList();
        all.addAll(Registries.Shape.getKeys());
        all.addAll(Registries.Component.getKeys());
        all.addAll(Registries.Modifier.getKeys());
        return ISuggestionProvider.func_197014_a(all, (SuggestionsBuilder)builder);
    }

    public static <S> ISpellComponent getSpell(CommandContext<S> context, String name) {
        return (ISpellComponent)context.getArgument(name, ISpellComponent.class);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

