/*
 * Decompiled with CFR 0.152.
 */
package com.ma.capabilities.worlddata;

import com.ma.ManaAndArtifice;
import com.ma.api.affinity.Affinity;
import com.ma.api.capabilities.Faction;
import com.ma.api.capabilities.IWellspringNodeRegistry;
import com.ma.api.capabilities.WellspringNode;
import com.ma.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.ma.config.GeneralModConfig;
import com.ma.network.ClientMessageDispatcher;
import com.ma.network.ServerMessageDispatcher;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableObject;

public class WellspringNodeRegistry
implements IWellspringNodeRegistry {
    private HashMap<BlockPos, WellspringNode> _registry = new HashMap();
    private static final HashMap<UUID, HashMap<Affinity, Float>> player_strengths_cached = new HashMap();
    private static final HashMap<Faction, HashMap<Affinity, Float>> faction_strengths_cached = new HashMap();
    boolean hasDoneInitialSync = false;
    boolean isOverworld = false;

    @Override
    public HashMap<BlockPos, WellspringNode> getNearbyNodes(BlockPos origin, int minDist, int maxDist) {
        int minDistSq = minDist * minDist;
        int maxDistSq = maxDist * maxDist;
        BlockPos testPos = new BlockPos(origin.func_177958_n(), 0, origin.func_177952_p());
        return this._registry.entrySet().stream().filter(e -> {
            double dist = ((BlockPos)e.getKey()).func_177951_i((Vector3i)testPos);
            return dist >= (double)minDistSq && dist <= (double)maxDistSq;
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (prev, next) -> next, HashMap::new));
    }

    @Override
    public Optional<WellspringNode> getNodeAt(BlockPos blockPos) {
        BlockPos checkPos = new BlockPos(blockPos.func_177958_n(), 0, blockPos.func_177952_p());
        return Optional.ofNullable(this._registry.getOrDefault(checkPos, null));
    }

    @Override
    public HashMap<Affinity, Float> getNodeNetworkStrengthFor(PlayerEntity player) {
        if (player == null) {
            return new HashMap<Affinity, Float>();
        }
        if (player.field_70170_p.field_72995_K && !this.hasDoneInitialSync) {
            this.hasDoneInitialSync = true;
            ClientMessageDispatcher.sendRequestWellspringNetworkSyncMessage(false);
        }
        if (((Boolean)GeneralModConfig.MA_WELLSPRING_POWER_FACTION.get()).booleanValue()) {
            MutableObject playerFaction = new MutableObject((Object)Faction.NONE);
            player.getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(p -> playerFaction.setValue((Object)p.getAlliedFaction()));
            return this._getNodeNetworkStrengthFor((Faction)((Object)playerFaction.getValue()));
        }
        return this._getNodeNetworkStrengthFor(player);
    }

    private HashMap<Affinity, Float> _getNodeNetworkStrengthFor(PlayerEntity player) {
        if (player == null) {
            return new HashMap<Affinity, Float>();
        }
        UUID playerProfileUUID = player.func_110124_au();
        return this._getNodeNetworkStrengthFor(playerProfileUUID);
    }

    private HashMap<Affinity, Float> _getNodeNetworkStrengthFor(UUID playerProfileUUID) {
        if (playerProfileUUID == null) {
            return new HashMap<Affinity, Float>();
        }
        if (!player_strengths_cached.containsKey(playerProfileUUID) || player_strengths_cached.get(playerProfileUUID) == null) {
            HashMap<Affinity, Float> affs = new HashMap<Affinity, Float>();
            for (Affinity aff : Affinity.values()) {
                if (affs.containsKey((Object)aff.getShiftAffinity())) continue;
                affs.put(aff.getShiftAffinity(), Float.valueOf(0.0f));
            }
            player_strengths_cached.put(playerProfileUUID, affs);
        }
        return player_strengths_cached.get(playerProfileUUID);
    }

    private HashMap<Affinity, Float> _getNodeNetworkStrengthFor(Faction faction) {
        if (!faction_strengths_cached.containsKey((Object)faction) || faction_strengths_cached.get((Object)faction) == null) {
            HashMap<Affinity, Float> affs = new HashMap<Affinity, Float>();
            for (Affinity aff : Affinity.values()) {
                if (affs.containsKey((Object)aff.getShiftAffinity())) continue;
                affs.put(aff.getShiftAffinity(), Float.valueOf(0.0f));
            }
            faction_strengths_cached.put(faction, affs);
        }
        return faction_strengths_cached.get((Object)faction);
    }

    private void syncNetworkStrengthFor(ServerWorld world, UUID playerId) {
        if (playerId == null) {
            return;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)world.func_217371_b(playerId);
        if (player != null) {
            ServerMessageDispatcher.sendWellspringPowerNetworkSyncMessage(world, player, true);
            ServerMessageDispatcher.sendWellspringSyncMessage(world, player, 128);
        }
    }

    @Override
    public boolean addRandomNode(World world, BlockPos origin) {
        if (((Boolean)GeneralModConfig.MA_GENERIC_WELLSPRINGS.get()).booleanValue()) {
            return this.addNode(origin, new WellspringNode(Affinity.UNKNOWN, (float)(5.0 + Math.random() * 20.0)), false);
        }
        Biome biome = world.func_226691_t_(origin);
        return this.addNode(origin, new WellspringNode(this.randomAffinityFromBiome(biome), (float)(5.0 + Math.random() * 20.0)), false);
    }

    private Affinity randomAffinityFromBiome(Biome biome) {
        if (Math.random() < 0.15) {
            return this.randomAffinityIn(Affinity.values());
        }
        switch (biome.func_201856_r()) {
            case BEACH: {
                return Affinity.WATER;
            }
            case DESERT: {
                return Affinity.FIRE;
            }
            case EXTREME_HILLS: {
                return this.randomAffinityIn(Affinity.ARCANE, Affinity.WIND);
            }
            case FOREST: {
                return this.randomAffinityIn(Affinity.ARCANE, Affinity.EARTH);
            }
            case ICY: {
                return Affinity.WATER;
            }
            case JUNGLE: {
                return this.randomAffinityIn(Affinity.WATER, Affinity.ARCANE, Affinity.EARTH);
            }
            case MESA: {
                return Affinity.EARTH;
            }
            case MUSHROOM: {
                return Affinity.ENDER;
            }
            case NETHER: {
                return Affinity.FIRE;
            }
            case NONE: {
                return Affinity.ARCANE;
            }
            case OCEAN: {
                return Affinity.WATER;
            }
            case PLAINS: {
                return Affinity.WIND;
            }
            case RIVER: {
                return Affinity.WATER;
            }
            case SAVANNA: {
                return Affinity.WIND;
            }
            case SWAMP: {
                return this.randomAffinityIn(Affinity.EARTH, Affinity.WATER, Affinity.ENDER);
            }
            case TAIGA: {
                return this.randomAffinityIn(Affinity.ARCANE, Affinity.EARTH);
            }
            case THEEND: {
                return Affinity.ENDER;
            }
        }
        return Affinity.UNKNOWN;
    }

    private Affinity randomAffinityIn(Affinity ... values) {
        return values[(int)(Math.random() * (double)values.length)];
    }

    @Override
    public boolean addNode(BlockPos origin, WellspringNode nodeData, boolean force) {
        int distance = (Integer)GeneralModConfig.MA_NODE_DISTANCE.get();
        BlockPos testPos = new BlockPos(origin.func_177958_n(), 0, origin.func_177952_p());
        if (!force && this.getNearbyNodes(testPos, 0, distance).size() > 0) {
            return false;
        }
        this._registry.put(testPos, nodeData);
        return true;
    }

    @Override
    public boolean claimNode(ServerWorld world, UUID playerId, Faction playerFaction, BlockPos origin, Affinity affinity) {
        ServerPlayerEntity player;
        if (playerId == null || playerFaction == null) {
            return false;
        }
        MutableBoolean claimed = new MutableBoolean(false);
        this.getNodeAt(origin).ifPresent(node -> {
            if (!node.isClaimed() && playerId != null) {
                if (playerFaction != Faction.NONE) {
                    node.setClaimedBy(playerId, playerFaction, origin.func_177956_o());
                    if (((Boolean)GeneralModConfig.MA_GENERIC_WELLSPRINGS.get()).booleanValue() && node.getAffinity() == Affinity.UNKNOWN) {
                        node.setAffinity(affinity);
                    }
                    HashMap<Affinity, Float> playerStr = this._getNodeNetworkStrengthFor(playerId);
                    playerStr.put(node.getAffinity().getShiftAffinity(), Float.valueOf(playerStr.getOrDefault((Object)node.getAffinity().getShiftAffinity(), Float.valueOf(0.0f)).floatValue() + node.getStrength()));
                    HashMap<Affinity, Float> factionStr = this._getNodeNetworkStrengthFor(playerFaction);
                    factionStr.put(node.getAffinity().getShiftAffinity(), Float.valueOf(factionStr.getOrDefault((Object)node.getAffinity().getShiftAffinity(), Float.valueOf(0.0f)).floatValue() + node.getStrength()));
                    this.syncNetworkStrengthFor(world, playerId);
                    claimed.setTrue();
                }
            } else if ((node.isClaimedBy(playerId) || node.isClaimedBy(playerFaction)) && node.getYLevel() == origin.func_177956_o()) {
                claimed.setTrue();
            }
        });
        if (!claimed.getValue().booleanValue() && (player = (ServerPlayerEntity)world.func_217371_b(playerId)) != null) {
            ServerMessageDispatcher.sendWellspringSyncMessage(world, player, 128);
        }
        return claimed.getValue();
    }

    @Override
    public boolean unclaimNode(ServerWorld world, BlockPos origin) {
        MutableBoolean unclaimed = new MutableBoolean(false);
        this.getNodeAt(origin).ifPresent(node -> {
            if (!node.isClaimed() || node.hasForcedYLevel() && node.getYLevel() != origin.func_177956_o()) {
                return;
            }
            UUID playerId = node.getClaimedBy();
            Faction f = node.getClaimedByFaction();
            if (playerId != null) {
                HashMap<Affinity, Float> playerStr = this._getNodeNetworkStrengthFor(playerId);
                playerStr.put(node.getAffinity().getShiftAffinity(), Float.valueOf(Math.max(playerStr.getOrDefault((Object)node.getAffinity().getShiftAffinity(), Float.valueOf(0.0f)).floatValue() - node.getStrength(), 0.0f)));
            }
            if (f != null) {
                HashMap<Affinity, Float> factionStr = this._getNodeNetworkStrengthFor(f);
                factionStr.put(node.getAffinity().getShiftAffinity(), Float.valueOf(Math.max(factionStr.getOrDefault((Object)node.getAffinity().getShiftAffinity(), Float.valueOf(0.0f)).floatValue() - node.getStrength(), 0.0f)));
            }
            node.clearClaimedBy();
            if (playerId != null) {
                this.syncNetworkStrengthFor(world, playerId);
            }
            unclaimed.setTrue();
        });
        return unclaimed.getValue();
    }

    @Override
    public void serializeNetworkStrength(PlayerEntity player, CompoundNBT nbt, boolean fullSync) {
        if (player == null) {
            return;
        }
        nbt.func_74757_a("fullSync", fullSync);
        if (fullSync) {
            CompoundNBT playerStrength = new CompoundNBT();
            ListNBT factionStrength = new ListNBT();
            this.serializePlayerNetworkStrength(player, playerStrength);
            for (Faction faction : Faction.values()) {
                CompoundNBT factionNBT = new CompoundNBT();
                this.serializeFactionNetworkStrength(faction, factionNBT);
                factionStrength.add((Object)factionNBT);
            }
            nbt.func_218657_a("player", (INBT)playerStrength);
            nbt.func_218657_a("factions", (INBT)factionStrength);
        } else {
            this.serializePlayerNetworkStrength(player, nbt);
        }
    }

    @Override
    public void deserializeNetworkStrength(PlayerEntity player, CompoundNBT nbt) {
        if (player == null || player.func_110124_au() == null) {
            ManaAndArtifice.LOGGER.error("Received NULL player or player with no UUID to deserializeNetworkStrength");
            return;
        }
        if (nbt.func_74767_n("fullSync")) {
            CompoundNBT playerStrength = nbt.func_74775_l("player");
            ListNBT factionStrength = nbt.func_150295_c("factions", 10);
            this.deserializePlayerNetworkStrength(player, playerStrength);
            factionStrength.forEach(inbt -> this.deserializeFactionNetworkStrength((CompoundNBT)inbt));
        } else {
            this.deserializePlayerNetworkStrength(player, nbt);
        }
    }

    private void serializePlayerNetworkStrength(PlayerEntity player, CompoundNBT nbt) {
        if (player == null) {
            return;
        }
        HashMap<Affinity, Float> strengths = this._getNodeNetworkStrengthFor(player);
        strengths.entrySet().forEach(e -> nbt.func_74776_a(((Affinity)((Object)((Object)e.getKey()))).getShiftAffinity().name(), ((Float)e.getValue()).floatValue()));
    }

    private void deserializePlayerNetworkStrength(PlayerEntity player, CompoundNBT nbt) {
        if (player == null) {
            return;
        }
        HashMap<Affinity, Float> strengths = new HashMap<Affinity, Float>();
        for (Affinity aff : Affinity.values()) {
            strengths.put(aff.getShiftAffinity(), Float.valueOf(nbt.func_74764_b(aff.getShiftAffinity().name()) ? nbt.func_74760_g(aff.getShiftAffinity().name()) : 0.0f));
        }
        player_strengths_cached.put(player.func_110124_au(), strengths);
    }

    private void serializeFactionNetworkStrength(Faction faction, CompoundNBT nbt) {
        HashMap<Affinity, Float> strengths = this._getNodeNetworkStrengthFor(faction);
        strengths.entrySet().forEach(e -> nbt.func_74776_a(((Affinity)((Object)((Object)e.getKey()))).getShiftAffinity().name(), ((Float)e.getValue()).floatValue()));
        nbt.func_74778_a("faction", faction.name());
    }

    private void deserializeFactionNetworkStrength(CompoundNBT nbt) {
        Faction faction = Faction.valueOf(nbt.func_74779_i("faction"));
        HashMap<Affinity, Float> strengths = new HashMap<Affinity, Float>();
        for (Affinity aff : Affinity.values()) {
            strengths.put(aff.getShiftAffinity(), Float.valueOf(nbt.func_74764_b(aff.getShiftAffinity().name()) ? nbt.func_74760_g(aff.getShiftAffinity().name()) : 0.0f));
        }
        faction_strengths_cached.put(faction, strengths);
    }

    @Override
    public void writeToNBT(CompoundNBT nbt) {
        ListNBT wellspringData = new ListNBT();
        this._registry.entrySet().stream().forEach(e -> {
            CompoundNBT node = new CompoundNBT();
            node.func_74772_a("pos", ((BlockPos)e.getKey()).func_218275_a());
            ((WellspringNode)e.getValue()).writeToNBT(node);
            wellspringData.add((Object)node);
        });
        nbt.func_218657_a("wellspringData", (INBT)wellspringData);
        CompoundNBT wellspringGlobal = new CompoundNBT();
        ListNBT player_strengths = new ListNBT();
        ListNBT faction_strengths = new ListNBT();
        if (this.isOverworld()) {
            player_strengths_cached.entrySet().forEach(e -> {
                CompoundNBT playerStrength = new CompoundNBT();
                playerStrength.func_186854_a("uuid", (UUID)e.getKey());
                ListNBT strengths = new ListNBT();
                ((HashMap)e.getValue()).entrySet().forEach(str -> {
                    CompoundNBT str_entry = new CompoundNBT();
                    str_entry.func_74768_a("affinity", ((Affinity)((Object)((Object)((Object)str.getKey())))).getShiftAffinity().ordinal());
                    str_entry.func_74776_a("strength", ((Float)str.getValue()).floatValue());
                    strengths.add((Object)str_entry);
                });
                playerStrength.func_218657_a("strengths", (INBT)strengths);
                player_strengths.add((Object)playerStrength);
            });
            faction_strengths_cached.entrySet().forEach(e -> {
                CompoundNBT factionStrength = new CompoundNBT();
                factionStrength.func_74778_a("faction", ((Faction)((Object)((Object)e.getKey()))).toString());
                ListNBT strengths = new ListNBT();
                ((HashMap)e.getValue()).entrySet().forEach(str -> {
                    CompoundNBT str_entry = new CompoundNBT();
                    str_entry.func_74768_a("affinity", ((Affinity)((Object)((Object)((Object)str.getKey())))).getShiftAffinity().ordinal());
                    str_entry.func_74776_a("strength", ((Float)str.getValue()).floatValue());
                    strengths.add((Object)str_entry);
                });
                factionStrength.func_218657_a("strengths", (INBT)strengths);
                faction_strengths.add((Object)factionStrength);
            });
            wellspringGlobal.func_218657_a("players", (INBT)player_strengths);
            wellspringGlobal.func_218657_a("factions", (INBT)faction_strengths);
            nbt.func_218657_a("wellspringGlobal", (INBT)wellspringGlobal);
        }
    }

    @Override
    public void readFromNBT(CompoundNBT nbt) {
        if (nbt.func_74764_b("wellspringData")) {
            ListNBT wellspringData = nbt.func_150295_c("wellspringData", 10);
            this._registry.clear();
            wellspringData.forEach(inbt -> {
                CompoundNBT node = (CompoundNBT)inbt;
                BlockPos pos = BlockPos.func_218283_e((long)node.func_74763_f("pos"));
                WellspringNode value = WellspringNode.fromNBT(node);
                this._registry.put(pos, value);
            });
        }
        if (this.isOverworld) {
            if (nbt.func_74764_b("wellspringGlobal")) {
                CompoundNBT wellspringGlobal = nbt.func_74775_l("wellspringGlobal");
                ListNBT player_strengths = wellspringGlobal.func_150295_c("players", 10);
                ListNBT faction_strengths = wellspringGlobal.func_150295_c("factions", 10);
                player_strengths.forEach(inbt -> {
                    CompoundNBT playerStrength = (CompoundNBT)inbt;
                    UUID uuid = playerStrength.func_186857_a("uuid");
                    ListNBT strengths = playerStrength.func_150295_c("strengths", 10);
                    strengths.forEach(strNbt -> {
                        CompoundNBT str_entry = (CompoundNBT)strNbt;
                        this._getNodeNetworkStrengthFor(uuid).put(Affinity.values()[str_entry.func_74762_e("affinity")], Float.valueOf(str_entry.func_74760_g("strength")));
                    });
                });
                faction_strengths.forEach(inbt -> {
                    CompoundNBT factionStrength = (CompoundNBT)inbt;
                    Faction faction = Faction.valueOf(factionStrength.func_74779_i("faction"));
                    ListNBT strengths = factionStrength.func_150295_c("strengths", 10);
                    strengths.forEach(strNbt -> {
                        CompoundNBT str_entry = (CompoundNBT)strNbt;
                        this._getNodeNetworkStrengthFor(faction).put(Affinity.values()[str_entry.func_74762_e("affinity")], Float.valueOf(str_entry.func_74760_g("strength")));
                    });
                });
            } else if (!nbt.func_74764_b("sync")) {
                player_strengths_cached.clear();
                faction_strengths_cached.clear();
                this._registry.entrySet().forEach(e -> {
                    if (((WellspringNode)e.getValue()).isClaimed()) {
                        UUID uuid = ((WellspringNode)e.getValue()).getClaimedBy();
                        Faction f = ((WellspringNode)e.getValue()).getClaimedByFaction();
                        HashMap<Affinity, Float> nnStrUUID = this._getNodeNetworkStrengthFor(uuid);
                        HashMap<Affinity, Float> nnStrF = this._getNodeNetworkStrengthFor(f);
                        nnStrUUID.put(((WellspringNode)e.getValue()).getAffinity().getShiftAffinity(), Float.valueOf(nnStrUUID.get((Object)((WellspringNode)e.getValue()).getAffinity().getShiftAffinity()).floatValue() + ((WellspringNode)e.getValue()).getStrength()));
                        nnStrF.put(((WellspringNode)e.getValue()).getAffinity().getShiftAffinity(), Float.valueOf(nnStrF.get((Object)((WellspringNode)e.getValue()).getAffinity().getShiftAffinity()).floatValue() + ((WellspringNode)e.getValue()).getStrength()));
                    }
                });
            }
        }
    }

    @Override
    public boolean writeToNBT(CompoundNBT nbt, BlockPos center, int radius) {
        ListNBT wellspringData = new ListNBT();
        HashMap<BlockPos, WellspringNode> nearbyNodes = this.getNearbyNodes(center, 0, radius);
        if (nearbyNodes.size() == 0) {
            return false;
        }
        nearbyNodes.entrySet().stream().forEach(e -> {
            CompoundNBT node = new CompoundNBT();
            node.func_74772_a("pos", ((BlockPos)e.getKey()).func_218275_a());
            ((WellspringNode)e.getValue()).writeToNBT(node);
            wellspringData.add((Object)node);
        });
        nbt.func_218657_a("wellspringData", (INBT)wellspringData);
        nbt.func_74757_a("sync", true);
        return true;
    }

    @Override
    public void setWellspringPower(ServerPlayerEntity player, Affinity aff, float level) {
        if (!player_strengths_cached.containsKey(player.func_110124_au())) {
            player_strengths_cached.put(player.func_110124_au(), new HashMap());
        }
        player_strengths_cached.get(player.func_110124_au()).put(aff, Float.valueOf(level));
    }

    @Override
    public boolean isOverworld() {
        return this.isOverworld;
    }

    @Override
    public void setOverworld() {
        this.isOverworld = true;
    }
}

