/*
 * Decompiled with CFR 0.152.
 */
package com.ma.capabilities.playerdata.magic;

import com.ma.ManaAndArtifice;
import com.ma.api.affinity.Affinity;
import com.ma.api.capabilities.IPlayerMagic;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;

public class PlayerMagicStorage
implements Capability.IStorage<IPlayerMagic> {
    final String KEY_CASTING_RESOURCE_TYPE = "casting_resource_id";
    final String KEY_TELEPORT_SALT = "teleport_salt";
    final String KEY_PORTAL_COOLDOWN = "portal_cooldown";
    final String KEY_RIFT = "rift";
    final String KEY_GRIMOIRE = "grimoire";
    final String KEY_ROTE = "rote";
    final String KEY_AFFINITY = "affinity";
    final String KEY_MAGIC_LEVEL = "magic_level";
    final String KEY_MAGIC_XP = "magic_xp";
    final String KEY_AIR_CASTS = "air_casts";
    final String KEY_AIR_JUMPS = "air_jumps";
    final String KEY_DID_ALLOW_FLIGHT = "did_allow_flying";
    final String KEY_MAX_MANA_MODIFIERS = "max_mana_modifiers";
    final String KEY_LAST_CODEX_ENTRY = "last_codex_entry";
    final String KEY_CANTRIPS = "cantrips";
    final String KEY_ARMOR_REPAIR = "banked_armor_repair";

    public INBT writeNBT(Capability<IPlayerMagic> capability, IPlayerMagic instance, Direction side) {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a("casting_resource_id", instance.getCastingResource().getRegistryName().toString());
        instance.getCastingResource().writeNBT(nbt);
        nbt.func_74768_a("teleport_salt", instance.getTeleportSalt());
        nbt.func_74768_a("portal_cooldown", instance.getPortalCooldown());
        nbt.func_74768_a("air_casts", instance.getAirCasts());
        nbt.func_74768_a("air_jumps", instance.getAirJumps());
        nbt.func_218657_a("rift", (INBT)this.saveInventory((IInventory)instance.getRiftInventory()));
        nbt.func_218657_a("grimoire", (INBT)this.saveInventory((IInventory)instance.getGrimoireInventory()));
        nbt.func_218657_a("rote", (INBT)this.saveInventory((IInventory)instance.getRoteInventory()));
        nbt.func_74757_a("did_allow_flying", instance.didAllowFlying());
        for (Affinity aff : Affinity.values()) {
            nbt.func_74776_a("affinity_" + aff.toString().toLowerCase(), instance.getAffinityDepth(aff));
        }
        nbt.func_74768_a("magic_level", instance.getMagicLevel());
        nbt.func_74768_a("magic_xp", instance.getMagicXP());
        instance.getChronoAnchorData().writeToNBT(nbt);
        nbt.func_218657_a("cantrips", (INBT)instance.getCantripData().writeToNBT(false));
        ListNBT armor_repair = new ListNBT();
        for (Map.Entry<Integer, Float> bank_slot : instance.getBankedArmorRepair().entrySet()) {
            CompoundNBT bank = new CompoundNBT();
            bank.func_74768_a("key", bank_slot.getKey().intValue());
            bank.func_74776_a("value", bank_slot.getValue().floatValue());
            armor_repair.add((Object)bank);
        }
        nbt.func_218657_a("banked_armor_repair", (INBT)armor_repair);
        return nbt;
    }

    public void readNBT(Capability<IPlayerMagic> capability, IPlayerMagic instance, Direction side, INBT nbt) {
        if (nbt instanceof CompoundNBT) {
            CompoundNBT cnbt = (CompoundNBT)nbt;
            if (cnbt.func_74764_b("magic_level")) {
                instance.setMagicLevel(cnbt.func_74762_e("magic_level"));
            }
            if (cnbt.func_74764_b("casting_resource_id")) {
                instance.setCastingResourceType(new ResourceLocation(cnbt.func_74779_i("casting_resource_id")));
            }
            instance.getCastingResource().readNBT(cnbt);
            instance.getCastingResource().setNeedsSync();
            if (cnbt.func_74764_b("teleport_salt")) {
                instance.setTeleportSalt(cnbt.func_74762_e("teleport_salt"));
            }
            if (cnbt.func_74764_b("portal_cooldown")) {
                instance.setPortalCooldown(cnbt.func_74762_e("portal_cooldown"));
            }
            if (cnbt.func_74764_b("air_casts")) {
                instance.setAirCasts(cnbt.func_74762_e("air_casts"));
            }
            if (cnbt.func_74764_b("air_jumps")) {
                instance.setAirJumps(cnbt.func_74762_e("air_jumps"));
            }
            if (cnbt.func_74764_b("did_allow_flying")) {
                instance.setDidAllowFlying(cnbt.func_74767_n("did_allow_flying"));
            }
            if (cnbt.func_74764_b("rift")) {
                this.readInventory((IInventory)instance.getRiftInventory(), cnbt.func_74775_l("rift"));
            }
            if (cnbt.func_74764_b("grimoire")) {
                this.readInventory((IInventory)instance.getGrimoireInventory(), cnbt.func_74775_l("grimoire"));
            }
            if (cnbt.func_74764_b("rote")) {
                this.readInventory((IInventory)instance.getRoteInventory(), cnbt.func_74775_l("rote"));
            }
            if (cnbt.func_74764_b("magic_xp")) {
                instance.setMagicXP(cnbt.func_74762_e("magic_xp"));
            }
            for (Affinity aff : Affinity.values()) {
                if (!cnbt.func_74764_b("affinity_" + aff.toString().toLowerCase())) continue;
                instance.setAffinityDepth(aff, cnbt.func_74760_g("affinity_" + aff.toString().toLowerCase()));
            }
            instance.getChronoAnchorData().readFromNBT(cnbt);
            if (cnbt.func_74764_b("cantrips")) {
                instance.getCantripData().readFromNBT((CompoundNBT)cnbt.func_74781_a("cantrips"));
            }
            if (cnbt.func_74764_b("banked_armor_repair")) {
                ListNBT banked_armor = cnbt.func_150295_c("banked_armor_repair", 10);
                HashMap<Integer, Float> parsed_banked_armor = new HashMap<Integer, Float>();
                for (int i = 0; i < banked_armor.size(); ++i) {
                    CompoundNBT bank = banked_armor.func_150305_b(i);
                    if (!bank.func_74764_b("key") || !bank.func_74764_b("value")) continue;
                    int key = bank.func_74762_e("key");
                    float value = bank.func_74760_g("value");
                    parsed_banked_armor.put(key, Float.valueOf(value));
                }
                instance.setBankedArmorRepair(parsed_banked_armor);
            }
            instance.validate();
        } else {
            ManaAndArtifice.LOGGER.error("Mana NBT passed back not an instance of CompoundNBT - save data was NOT loaded!");
        }
    }

    private CompoundNBT saveInventory(IInventory inventory) {
        NonNullList inventoryItems = NonNullList.func_191196_a();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            inventoryItems.add((Object)inventory.func_70301_a(i));
        }
        CompoundNBT inv = new CompoundNBT();
        ItemStackHelper.func_191282_a((CompoundNBT)inv, (NonNullList)inventoryItems);
        return inv;
    }

    private void readInventory(IInventory inventory, CompoundNBT nbt) {
        NonNullList inventoryItems = NonNullList.func_191197_a((int)inventory.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((CompoundNBT)nbt, (NonNullList)inventoryItems);
        for (int i = 0; i < inventoryItems.size(); ++i) {
            if (inventory.func_70302_i_() <= i) continue;
            inventory.func_70299_a(i, (ItemStack)inventoryItems.get(i));
        }
    }
}

