/*
 * Decompiled with CFR 0.152.
 */
package com.ma.cantrips;

import com.google.common.collect.Lists;
import com.ma.ManaAndArtifice;
import com.ma.api.cantrips.ICantrip;
import com.ma.api.cantrips.ICantripRegistry;
import com.ma.api.capabilities.Faction;
import com.ma.api.sound.SFX;
import com.ma.api.spells.attributes.Attribute;
import com.ma.api.spells.collections.Components;
import com.ma.api.spells.collections.Shapes;
import com.ma.api.spells.parts.Shape;
import com.ma.api.spells.targeting.SpellSource;
import com.ma.cantrips.Cantrip;
import com.ma.capabilities.playerdata.magic.PlayerMagicProvider;
import com.ma.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.ma.entities.EntityInit;
import com.ma.entities.utility.EntityPresentItem;
import com.ma.entities.utility.EntitySpellFX;
import com.ma.events.delayed.DelayedEventQueue;
import com.ma.events.delayed.TimedDelayedEvent;
import com.ma.items.ItemInit;
import com.ma.items.manaweaving.ItemManaweaverWand;
import com.ma.spells.SpellCaster;
import com.ma.spells.SpellsInit;
import com.ma.spells.components.ComponentGust;
import com.ma.spells.crafting.ModifiedSpellPart;
import com.ma.spells.crafting.SpellRecipe;
import com.ma.tools.BlockUtils;
import com.ma.tools.RLoc;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.logging.log4j.util.TriConsumer;

public class CantripRegistry
implements ICantripRegistry {
    private static ItemStack IGNITE_CANTRIP_SPELL = new ItemStack((IItemProvider)ItemInit.SPELL.get());
    private List<ICantrip> cantrips = new ArrayList<ICantrip>();
    public static final CantripRegistry INSTANCE = new CantripRegistry();

    public CantripRegistry() {
        SpellRecipe recipe = new SpellRecipe();
        recipe.setShape(SpellsInit.TOUCH);
        recipe.addComponent(SpellsInit.FIRE_DAMAGE);
        recipe.changeComponentAttributeValue(0, Attribute.DAMAGE, 0.0f);
        recipe.changeShapeAttributeValue(Attribute.RANGE, 8.0f);
        recipe.writeToNBT(IGNITE_CANTRIP_SPELL.func_196082_o());
        this.registerCantrip(RLoc.create("ignite"), RLoc.create("textures/gui/cantrips/ignite.png"), 1, (TriConsumer<PlayerEntity, ICantrip, Hand>)((TriConsumer)CantripRegistry::applySpellAtTargetOnDelay), IGNITE_CANTRIP_SPELL, RLoc.create("manaweave_patterns/square"), RLoc.create("manaweave_patterns/triangle"));
        this.registerCantrip(RLoc.create("gust"), RLoc.create("textures/gui/cantrips/gust.png"), 1, (TriConsumer<PlayerEntity, ICantrip, Hand>)((TriConsumer)CantripRegistry::gust), ItemStack.field_190927_a, RLoc.create("manaweave_patterns/slash"), RLoc.create("manaweave_patterns/backslash"));
        this.registerCantrip(RLoc.create("dispel"), RLoc.create("textures/gui/cantrips/dispel.png"), 2, (TriConsumer<PlayerEntity, ICantrip, Hand>)((TriConsumer)CantripRegistry::dispel), ItemStack.field_190927_a, RLoc.create("manaweave_patterns/circle"), RLoc.create("manaweave_patterns/triangle"));
        this.registerCantrip(RLoc.create("drought"), RLoc.create("textures/gui/cantrips/drought.png"), 2, (TriConsumer<PlayerEntity, ICantrip, Hand>)((TriConsumer)CantripRegistry::drought), ItemStack.field_190927_a, RLoc.create("manaweave_patterns/circle"), RLoc.create("manaweave_patterns/circle"), RLoc.create("manaweave_patterns/circle"));
        this.registerCantrip(RLoc.create("grimoire"), RLoc.create("textures/gui/cantrips/grimoire.png"), 3, (TriConsumer<PlayerEntity, ICantrip, Hand>)((TriConsumer)CantripRegistry::summonGrimoire), ItemStack.field_190927_a, RLoc.create("manaweave_patterns/triangle"), RLoc.create("manaweave_patterns/inverted_triangle"));
        this.registerCantrip(RLoc.create("faction_grimoire"), RLoc.create("textures/gui/cantrips/grimoire2.png"), 4, (TriConsumer<PlayerEntity, ICantrip, Hand>)((TriConsumer)CantripRegistry::summonFactionGrimoire), ItemStack.field_190927_a, RLoc.create("manaweave_patterns/hourglass"), RLoc.create("manaweave_patterns/triangle"), RLoc.create("manaweave_patterns/inverted_triangle"));
        this.registerCantrip(RLoc.create("freeform_spell_a"), RLoc.create("textures/gui/cantrips/chevron_1.png"), 3, (TriConsumer<PlayerEntity, ICantrip, Hand>)((TriConsumer)CantripRegistry::applySpellAtTargetOnDelay), ItemStack.field_190927_a, RLoc.create("manaweave_patterns/triangle"), RLoc.create("manaweave_patterns/circle")).dynamicItem();
        this.registerCantrip(RLoc.create("freeform_spell_b"), RLoc.create("textures/gui/cantrips/chevron_2.png"), 4, (TriConsumer<PlayerEntity, ICantrip, Hand>)((TriConsumer)CantripRegistry::applySpellAtTargetOnDelay), ItemStack.field_190927_a, RLoc.create("manaweave_patterns/diamond"), RLoc.create("manaweave_patterns/square")).dynamicItem();
        this.registerCantrip(RLoc.create("freeform_spell_c"), RLoc.create("textures/gui/cantrips/chevron_3.png"), 5, (TriConsumer<PlayerEntity, ICantrip, Hand>)((TriConsumer)CantripRegistry::applySpellAtTargetOnDelay), ItemStack.field_190927_a, RLoc.create("manaweave_patterns/knot2"), RLoc.create("manaweave_patterns/split_triangle")).dynamicItem();
    }

    @Override
    public ICantrip registerCantrip(ResourceLocation id, ResourceLocation icon, int tier, TriConsumer<PlayerEntity, ICantrip, Hand> effector, ItemStack spell, ResourceLocation ... defaultCombination) {
        if (this.cantrips.stream().anyMatch(c -> c.getId().equals((Object)id))) {
            ManaAndArtifice.LOGGER.error("Attempted to register duplicate cantrips with id " + id);
            return null;
        }
        ICantrip c2 = new Cantrip(id, effector, spell, defaultCombination).setTier(tier).setDelay(60).setSound(SFX.Event.Player.MANAWEAVE_PATTERN_MATCH).setIcon(icon);
        this.cantrips.add(c2);
        return c2;
    }

    public static void applySpellAtTargetOnDelay(PlayerEntity player, ICantrip cantrip, Hand hand) {
        player.getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> m.getCantripData().getCantrip(cantrip.getId()).ifPresent(c -> {
            SpellRecipe spell = SpellRecipe.fromNBT(c.getStack().func_77978_p());
            if (spell.isValid()) {
                DelayedEventQueue.pushEvent(player.field_70170_p, new TimedDelayedEvent<Triple>(player.func_110124_au().toString() + "cantrip", 60, Triple.of((Object)player, (Object)cantrip, (Object)hand), CantripRegistry::applySpellAtTarget));
            }
        }));
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void applySpellAtTarget(String id, Triple<PlayerEntity, ICantrip, Hand> data) {
        Hand useHand;
        block5: {
            if (data.getLeft() == null || data.getMiddle() == null) {
                return;
            }
            if (!(((PlayerEntity)data.getLeft()).func_184586_b((Hand)data.getRight()).func_77973_b() instanceof ItemManaweaverWand)) {
                Hand opposite;
                Hand hand = opposite = data.getRight() == Hand.MAIN_HAND ? Hand.OFF_HAND : Hand.MAIN_HAND;
                if (((PlayerEntity)data.getLeft()).func_184586_b(opposite).func_77973_b() instanceof ItemManaweaverWand) {
                    useHand = opposite;
                    break block5;
                } else {
                    if (!((PlayerEntity)data.getLeft()).field_70170_p.field_72995_K) {
                        ((PlayerEntity)data.getLeft()).func_145747_a((ITextComponent)new TranslationTextComponent("item.mana-and-artifice.manaweaver_wand.cantrip_wand_removed").func_240699_a_(TextFormatting.GOLD), Util.field_240973_b_);
                    }
                    return;
                }
            }
            useHand = (Hand)data.getRight();
        }
        ((PlayerEntity)data.getLeft()).getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> m.getCantripData().getCantrip(((ICantrip)data.getMiddle()).getId()).ifPresent(c -> {
            SpellRecipe recipe = SpellRecipe.fromNBT(c.getStack().func_77978_p());
            for (int i = 0; i < 3; ++i) {
                recipe.setModifier(null, i);
            }
            if (recipe.isValid() && !((Shape)((ModifiedSpellPart)recipe.getShape()).getPart()).isChanneled() && recipe.getReagents((PlayerEntity)data.getLeft(), null).size() == 0) {
                SpellCaster.Affect(c.getStack(), recipe, ((PlayerEntity)data.getLeft()).field_70170_p, new SpellSource((LivingEntity)data.getLeft(), useHand));
            }
        }));
    }

    public static void summonGrimoire(PlayerEntity player, ICantrip cantrip, Hand hand) {
        Vector3d vec = player.func_174824_e(0.0f).func_178787_e(player.func_70040_Z().func_186678_a(2.0));
        EntityPresentItem entity = new EntityPresentItem(player.field_70170_p, vec.field_72450_a, vec.field_72448_b - 0.5, vec.field_72449_c, new ItemStack((IItemProvider)ItemInit.GRIMOIRE.get()));
        entity.func_174869_p();
        player.field_70170_p.func_217376_c((Entity)entity);
    }

    public static void summonFactionGrimoire(PlayerEntity player, ICantrip cantrip, Hand hand) {
        player.getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(p -> {
            Faction f = p.getAlliedFaction();
            ItemStack stack = ItemStack.field_190927_a;
            switch (f) {
                case ANCIENT_WIZARDS: {
                    stack = new ItemStack((IItemProvider)ItemInit.GRIMOIRE_COUNCIL.get());
                    break;
                }
                case DEMONS: {
                    stack = new ItemStack((IItemProvider)ItemInit.GRIMOIRE_DEMON.get());
                    break;
                }
                case FEY_COURT: {
                    stack = new ItemStack((IItemProvider)ItemInit.GRIMOIRE_FEY.get());
                    break;
                }
                case UNDEAD: {
                    stack = new ItemStack((IItemProvider)ItemInit.GRIMOIRE_UNDEAD.get());
                    break;
                }
                default: {
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("cantrip.mana-and-artifice.faction_grimoire_nofaction"), Util.field_240973_b_);
                    return;
                }
            }
            Vector3d vec = player.func_174824_e(0.0f).func_178787_e(player.func_70040_Z().func_186678_a(2.0));
            EntityPresentItem entity = new EntityPresentItem(player.field_70170_p, vec.field_72450_a, vec.field_72448_b - 0.5, vec.field_72449_c, stack);
            entity.func_174869_p();
            player.field_70170_p.func_217376_c((Entity)entity);
        });
    }

    public static void dispel(PlayerEntity player, ICantrip cantrip, Hand hand) {
        player.curePotionEffects(new ItemStack((IItemProvider)Items.field_151117_aB));
        SpellRecipe recipe = new SpellRecipe();
        recipe.setShape(Shapes.SELF);
        recipe.addComponent(Components.TRUE_INVISIBILITY);
        EntitySpellFX fx = new EntitySpellFX((EntityType)EntityInit.SPELL_FX.get(), player.field_70170_p);
        fx.setCasterUUID(player);
        fx.setRecipe(recipe);
        fx.func_226286_f_(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_());
        player.field_70170_p.func_217376_c((Entity)fx);
    }

    public static void drought(PlayerEntity player, ICantrip cantrip, Hand hand) {
        World world = player.field_70170_p;
        BlockPos pos = player.func_233580_cy_();
        LinkedList queue = Lists.newLinkedList();
        queue.add(new Tuple((Object)pos, (Object)0));
        int i = 0;
        while (!queue.isEmpty()) {
            Tuple tuple = (Tuple)queue.poll();
            BlockPos blockpos = (BlockPos)tuple.func_76341_a();
            int j = (Integer)tuple.func_76340_b();
            for (Direction direction : Direction.values()) {
                BlockPos blockpos1 = blockpos.func_177972_a(direction);
                BlockState blockstate = world.func_180495_p(blockpos1);
                FluidState fluidstate = world.func_204610_c(blockpos1);
                Material material = blockstate.func_185904_a();
                if (!fluidstate.func_206884_a((ITag)FluidTags.field_206959_a)) continue;
                if (blockstate.func_177230_c() instanceof IBucketPickupHandler && ((IBucketPickupHandler)blockstate.func_177230_c()).func_204508_a((IWorld)world, blockpos1, blockstate) != Fluids.field_204541_a) {
                    ++i;
                    if (j >= 6) continue;
                    queue.add(new Tuple((Object)blockpos1, (Object)(j + 1)));
                    continue;
                }
                if (blockstate.func_177230_c() instanceof FlowingFluidBlock) {
                    world.func_180501_a(blockpos1, Blocks.field_150350_a.func_176223_P(), 3);
                    ++i;
                    if (j >= 6) continue;
                    queue.add(new Tuple((Object)blockpos1, (Object)(j + 1)));
                    continue;
                }
                if (material != Material.field_203243_f && material != Material.field_204868_h) continue;
                TileEntity tileentity = blockstate.hasTileEntity() ? world.func_175625_s(blockpos1) : null;
                Block.func_220059_a((BlockState)blockstate, (IWorld)world, (BlockPos)blockpos1, (TileEntity)tileentity);
                world.func_180501_a(blockpos1, Blocks.field_150350_a.func_176223_P(), 3);
                ++i;
                if (j >= 6) continue;
                queue.add(new Tuple((Object)blockpos1, (Object)(j + 1)));
            }
            if (i <= 64) continue;
            break;
        }
    }

    public static void gust(PlayerEntity player, ICantrip cantrip, Hand hand) {
        if (!player.field_70170_p.field_72995_K) {
            int radius = 4;
            int height = 2;
            for (int i = -radius; i <= radius; ++i) {
                for (int k = -radius; k <= radius; ++k) {
                    for (int j = 0; j < height; ++j) {
                        BlockPos pos = player.func_233580_cy_().func_177982_a(i, j, k);
                        BlockState state = player.field_70170_p.func_180495_p(pos);
                        Material m = state.func_185904_a();
                        if (!ComponentGust.validMaterials.containsKey(m) || ComponentGust.validMaterials.get(m) > 2 || !BlockUtils.destroyBlock((LivingEntity)player, player.field_70170_p, pos, true, 3, ToolType.HOE)) continue;
                        BlockUtils.updateBlockState(player.field_70170_p, pos);
                    }
                }
            }
        }
    }

    @Override
    public int countRegisteredCantrips() {
        return this.cantrips.size();
    }

    @Override
    @Nullable
    public Optional<ICantrip> getCantrip(ResourceLocation cantripID) {
        return this.cantrips.stream().filter(c -> c.getId().equals((Object)cantripID)).findFirst();
    }

    @Override
    public List<ICantrip> getCantrips() {
        return this.cantrips;
    }

    @Override
    public List<ICantrip> getCantrips(int tier) {
        return this.getCantrips().stream().filter(c -> c.getTier() <= tier).collect(Collectors.toList());
    }
}

