/*
 * Decompiled with CFR 0.152.
 */
package com.ma.cantrips;

import com.ma.api.cantrips.ICantrip;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import org.apache.logging.log4j.util.TriConsumer;

public class Cantrip
implements ICantrip {
    public static final int NUM_PATTERNS = 3;
    private ArrayList<ResourceLocation> default_combination;
    private TriConsumer<PlayerEntity, ICantrip, Hand> effector;
    private ResourceLocation id;
    private ResourceLocation icon;
    private ItemStack default_stack = ItemStack.field_190927_a;
    private boolean stackLocked = true;
    private int delay = 0;
    private SoundEvent matchSound;
    private int tier = 1;

    public Cantrip(ResourceLocation id, TriConsumer<PlayerEntity, ICantrip, Hand> effector, ItemStack defaultStack, ResourceLocation ... defaultCombination) {
        this(id, effector, defaultStack, Arrays.asList(defaultCombination));
    }

    public Cantrip(ResourceLocation id, TriConsumer<PlayerEntity, ICantrip, Hand> effector, ItemStack defaultStack, List<ResourceLocation> defaultCombination) {
        this.default_combination = new ArrayList();
        this.default_combination.addAll(defaultCombination);
        this.effector = effector;
        this.id = id;
        this.default_stack = defaultStack;
    }

    public void callEffector(PlayerEntity player, Hand hand) {
        if (this.effector != null) {
            this.effector.accept((Object)player, (Object)this, (Object)hand);
        }
    }

    @Override
    public Cantrip dynamicItem() {
        this.stackLocked = false;
        return this;
    }

    @Override
    public Cantrip setDelay(int ticks) {
        this.delay = ticks;
        return this;
    }

    @Override
    public Cantrip setSound(SoundEvent sound) {
        this.matchSound = sound;
        return this;
    }

    public Cantrip setTier(int tier) {
        this.tier = tier;
        return this;
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public int getDelay() {
        return this.delay;
    }

    @Override
    public SoundEvent getSound() {
        return this.matchSound;
    }

    @Override
    public int getTier() {
        return this.tier;
    }

    @Override
    public ResourceLocation getIcon() {
        return this.icon;
    }

    @Override
    public ICantrip setIcon(ResourceLocation icon) {
        this.icon = icon;
        return this;
    }

    @Override
    public boolean isStackLocked() {
        return this.stackLocked;
    }

    @Override
    public List<ResourceLocation> getDefaultCombination() {
        return this.default_combination;
    }

    @Override
    public ItemStack getDefaultStack() {
        return this.default_stack;
    }
}

