/*
 * Decompiled with CFR 0.152.
 */
package com.ma.blocks.tileentities.renderers;

import com.ma.blocks.runeforging.PedestalBlock;
import com.ma.blocks.tileentities.PedestalTile;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.TranslationTextComponent;

public class PedestalRenderer
extends TileEntityRenderer<PedestalTile> {
    private final ItemRenderer itemRenderer;
    private final EntityRendererManager renderDispatcher;
    private final FontRenderer font;

    public PedestalRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
        Minecraft mc = Minecraft.func_71410_x();
        this.itemRenderer = Minecraft.func_71410_x().func_175599_af();
        this.renderDispatcher = mc.func_175598_ae();
        this.font = mc.field_71466_p;
    }

    public void render(PedestalTile tileEntityIn, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        ItemStack itemstack = tileEntityIn.getDisplayedItem();
        if (!itemstack.func_190926_b()) {
            matrixStackIn.func_227860_a_();
            if (itemstack.func_77973_b() instanceof BlockItem) {
                matrixStackIn.func_227861_a_(0.5, 1.2, 0.5);
            } else {
                matrixStackIn.func_227861_a_(0.5, 1.0, 0.5);
                matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
            }
            matrixStackIn.func_227862_a_(0.5f, 0.5f, 0.5f);
            this.itemRenderer.func_229110_a_(itemstack, ItemCameraTransforms.TransformType.FIXED, combinedLightIn, OverlayTexture.field_229196_a_, matrixStackIn, bufferIn);
            matrixStackIn.func_227865_b_();
            this.renderHoverText(tileEntityIn, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
        }
    }

    private void renderHoverText(PedestalTile tileEntityIn, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (!((Boolean)tileEntityIn.func_195044_w().func_177229_b((Property)PedestalBlock.SHOW_SIGN)).booleanValue()) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71476_x == null || mc.field_71476_x.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return;
        }
        BlockRayTraceResult brtr = (BlockRayTraceResult)mc.field_71476_x;
        if (!brtr.func_216350_a().equals((Object)tileEntityIn.func_174877_v())) {
            return;
        }
        if (!brtr.func_216354_b().equals((Object)tileEntityIn.func_195044_w().func_177229_b((Property)HorizontalBlock.field_185512_D))) {
            return;
        }
        Vector3d dist = mc.field_71439_g.func_213303_ch().func_178788_d(Vector3d.func_237489_a_((Vector3i)tileEntityIn.func_174877_v())).func_72432_b().func_186678_a(0.5);
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_(0.5, 1.1, 0.5);
        matrixStackIn.func_227861_a_(dist.field_72450_a, dist.field_72448_b, dist.field_72449_c);
        matrixStackIn.func_227862_a_(0.5f, 0.5f, 0.5f);
        this.renderString(new TranslationTextComponent(tileEntityIn.getDisplayedItem().func_77977_a()).getString(), matrixStackIn, bufferIn, combinedLightIn);
        matrixStackIn.func_227865_b_();
    }

    protected void renderString(String text, MatrixStack stack, IRenderTypeBuffer buffer, int packedLight) {
        stack.func_227860_a_();
        stack.func_227863_a_(this.renderDispatcher.func_229098_b_());
        stack.func_227862_a_(-0.025f, -0.025f, 0.025f);
        Matrix4f matrix4f = stack.func_227866_c_().func_227870_a_();
        float opacity = 0.25f;
        int textColor = (int)(opacity * 255.0f) << 24;
        float hOffset = -this.font.func_78256_a(text) / 2;
        this.font.func_228079_a_(text, hOffset, 0.0f, 0x20FFFFFF, false, matrix4f, buffer, true, textColor, packedLight);
        this.font.func_228079_a_(text, hOffset, 0.0f, -1, false, matrix4f, buffer, false, 0, packedLight);
        stack.func_227865_b_();
    }
}

