/*
 * Decompiled with CFR 0.152.
 */
package com.ma.blocks.tileentities;

import com.ma.api.particles.MAParticleType;
import com.ma.api.particles.ParticleInit;
import com.ma.blocks.BlockInit;
import com.ma.blocks.artifice.SlipstreamGeneratorBlock;
import com.ma.blocks.tileentities.init.TileEntityInit;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.stream.Collectors;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;

public class SlipstreamGeneratorTile
extends TileEntity
implements ITickableTileEntity {
    private ArrayList<Entity> levitatingEntities = new ArrayList();
    private int updateTicks = 1;
    private Direction levitateDir = null;
    private boolean playersOnly = true;
    private AxisAlignedBB bb = null;
    private static final int EFFECT_HEIGHT = 50;
    private static final int MAX_STACK = 5;
    private static final float VELOCITY_SCALE = 0.5999999f;
    private static final float STOP_THRESHOLD = 0.2f;
    private static final float VELOCITY_ADD = 0.2f;
    private static final float PLAYER_VELOCITY_ADD = 0.75f;

    public SlipstreamGeneratorTile() {
        super((TileEntityType)TileEntityInit.SLIPSTREAM_GENERATOR.get());
    }

    private Direction getLevitateDir() {
        if (this.levitateDir == null) {
            BlockState state = this.func_195044_w();
            this.levitateDir = state.func_235901_b_((Property)SlipstreamGeneratorBlock.FACING) ? (Direction)state.func_177229_b((Property)SlipstreamGeneratorBlock.FACING) : Direction.UP;
        }
        return this.levitateDir;
    }

    public void func_73660_a() {
        if (this.updateTicks++ > 10) {
            this.refreshPushAxis();
            this.refreshEntityList();
            this.updateTicks = 0;
        }
        if (this.bb == null) {
            return;
        }
        Iterator<Entity> it = this.levitatingEntities.iterator();
        while (it.hasNext()) {
            Entity entity = it.next();
            if (entity instanceof PlayerEntity) {
                if (this.levitatePlayer((PlayerEntity)entity, this.getLevitateDir().func_176740_k())) continue;
                it.remove();
                continue;
            }
            if (this.pushEntity(entity)) continue;
            it.remove();
        }
    }

    private boolean pushEntity(Entity entity) {
        if (!this.entityIsValid(entity)) {
            return false;
        }
        entity.func_213317_d(Vector3d.field_186680_a);
        entity.func_213293_j((double)((float)this.getLevitateDir().func_82601_c() * 0.2f), (double)((float)this.getLevitateDir().func_96559_d() * 0.2f), (double)((float)this.getLevitateDir().func_82599_e() * 0.2f));
        return true;
    }

    private boolean levitatePlayer(PlayerEntity player, Direction.Axis axis) {
        if (!this.entityIsValid((Entity)player)) {
            return false;
        }
        this.slowPlayerDown(player, false);
        if (!player.func_225608_bj_()) {
            if (axis == Direction.Axis.Y) {
                this.levitatePlayerYAxis(player);
            } else {
                this.levitatePlayerHorizontally(player, axis);
            }
        }
        if (this.field_145850_b.field_72995_K) {
            this.spawnParticles(player);
        }
        return true;
    }

    private void slowPlayerDown(PlayerEntity player, boolean xz) {
        double x = player.func_213322_ci().field_72450_a;
        double y = player.func_213322_ci().field_72448_b * 0.5999999046325684;
        double z = player.func_213322_ci().field_72449_c;
        if (this.getLevitateDir().func_176740_k() == Direction.Axis.X) {
            x *= 0.5999999046325684;
        } else if (this.getLevitateDir().func_176740_k() == Direction.Axis.Z) {
            z *= 0.5999999046325684;
        }
        player.func_213293_j(x, y, z);
        if (Math.abs(player.func_213322_ci().field_72448_b) < (double)0.2f) {
            player.func_70024_g(0.0, -player.func_213322_ci().field_72448_b, 0.0);
            player.field_70143_R = 0.0f;
        } else {
            player.field_70143_R -= 1.0f;
        }
        if (this.getLevitateDir().func_176740_k() == Direction.Axis.X && Math.abs(player.func_213322_ci().field_72450_a) < (double)0.2f) {
            player.func_70024_g(-player.func_213322_ci().field_72450_a, 0.0, 0.0);
        }
        if (this.getLevitateDir().func_176740_k() == Direction.Axis.Z && Math.abs(player.func_213322_ci().field_72449_c) < (double)0.2f) {
            player.func_70024_g(0.0, 0.0, -player.func_213322_ci().field_72449_c);
        }
    }

    private void levitatePlayerYAxis(PlayerEntity player) {
        float pitch = player.field_70125_A;
        float factor = (pitch > 0.0f ? pitch - 10.0f : pitch + 10.0f) / -180.0f;
        if (Math.abs(pitch) > 10.0f) {
            player.func_213315_a(MoverType.PLAYER, new Vector3d(0.0, (double)factor, 0.0));
        }
    }

    private void levitatePlayerHorizontally(PlayerEntity player, Direction.Axis axis) {
        float factorX = 0.0f;
        float factorZ = 0.0f;
        Vector3d posX = new Vector3d(1.0, 0.0, 0.0);
        Vector3d negX = new Vector3d(-1.0, 0.0, 0.0);
        Vector3d posZ = new Vector3d(0.0, 0.0, 1.0);
        Vector3d negZ = new Vector3d(0.0, 0.0, -1.0);
        Vector3d playerH = new Vector3d(player.func_70040_Z().field_72450_a, 0.0, player.func_70040_Z().field_72449_c);
        if (axis == Direction.Axis.X) {
            double dotPosX = posX.func_72430_b(playerH);
            double dotNegX = negX.func_72430_b(playerH);
            if (dotPosX > 0.2) {
                factorX = (float)dotPosX;
            } else if (dotNegX > 0.2) {
                factorX = (float)dotNegX * -1.0f;
            }
            factorX *= 0.75f;
        } else if (axis == Direction.Axis.Z) {
            double dotPosZ = posZ.func_72430_b(playerH);
            double dotNegZ = negZ.func_72430_b(playerH);
            if (dotPosZ > 0.2) {
                factorZ = (float)dotPosZ;
            } else if (dotNegZ > 0.2) {
                factorZ = (float)dotNegZ * -1.0f;
            }
            factorZ *= 0.75f;
        }
        double deltaY = (double)this.func_174877_v().func_177956_o() - player.func_226278_cu_() + 0.5;
        float yThreshold = 0.1f;
        if (Math.abs(deltaY) < (double)yThreshold) {
            deltaY = 0.0;
        } else if (deltaY != 0.0) {
            deltaY = (double)yThreshold * Math.signum(deltaY);
        }
        if (Math.abs(factorX) > 0.0f || Math.abs(factorZ) > 0.0f || deltaY > 0.0) {
            player.func_213315_a(MoverType.PLAYER, new Vector3d((double)factorX, deltaY, (double)factorZ));
        }
    }

    private void spawnParticles(PlayerEntity player) {
        float pitch = player.field_70125_A;
        float factor = (pitch > 0.0f ? pitch - 10.0f : pitch + 10.0f) / -180.0f;
        if (player.func_225608_bj_()) {
            factor = 0.01f;
        }
        for (int i = 0; i < 5; ++i) {
            this.field_145850_b.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.AIR_ORBIT.get())), player.func_226277_ct_(), player.func_225608_bj_() ? player.func_226278_cu_() : player.func_226278_cu_() + (double)factor + Math.random() * (double)player.func_213302_cg(), player.func_226281_cx_(), (double)0.1f, (double)factor, 1.0);
        }
    }

    private boolean entityIsValid(Entity player) {
        if (player == null || !player.func_70089_S()) {
            return false;
        }
        Vector3d myPos = new Vector3d((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5);
        if (player.func_174813_aQ().func_72326_a(this.bb)) {
            BlockRayTraceResult result = this.field_145850_b.func_217299_a(new RayTraceContext(player.func_174824_e(0.0f), myPos, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, player));
            if (result.func_216346_c() == RayTraceResult.Type.MISS) {
                return true;
            }
            if (result.func_216346_c() == RayTraceResult.Type.BLOCK) {
                return result.func_216350_a().equals((Object)this.func_174877_v());
            }
        }
        return false;
    }

    private void refreshEntityList() {
        this.levitatingEntities.clear();
        if (this.bb == null) {
            return;
        }
        if (this.playersOnly) {
            this.levitatingEntities.addAll(this.field_145850_b.func_217369_A().stream().filter(p -> this.entityIsValid((Entity)p) && !this.levitatingEntities.contains(p)).collect(Collectors.toList()));
        } else {
            this.levitatingEntities.addAll(this.field_145850_b.func_217357_a(Entity.class, this.bb));
        }
    }

    private void refreshPushAxis() {
        this.bb = null;
        int axisStacks = this.countStacksAlongAxis(this.getLevitateDir().func_176734_d());
        BlockPos bbOffset = this.func_174877_v().func_177967_a(this.getLevitateDir(), (axisStacks + 1) * 50);
        this.bb = new AxisAlignedBB(this.func_174877_v(), bbOffset.func_177982_a(this.getLevitateDir().func_82601_c() == 0 ? 1 : 0, this.getLevitateDir().func_96559_d() == 0 ? 1 : 0, this.getLevitateDir().func_82599_e() == 0 ? 1 : 0));
    }

    private int countStacksAlongAxis(Direction axis) {
        int count = 0;
        BlockPos checkPos = this.func_174877_v().func_177971_a(axis.func_176730_m());
        while (this.field_145850_b.func_180495_p(checkPos).func_177230_c() == BlockInit.SLIPSTREAM_GENERATOR.get() && count < 5) {
            ++count;
            checkPos = checkPos.func_177971_a(axis.func_176730_m());
        }
        return count;
    }
}

