/*
 * Decompiled with CFR 0.152.
 */
package com.ma.blocks.tileentities;

import com.ma.ManaAndArtifice;
import com.ma.api.blocks.tile.IMultiblockDefinition;
import com.ma.api.blocks.tile.MultiblockTile;
import com.ma.api.capabilities.Faction;
import com.ma.blocks.tileentities.init.TileEntityInit;
import com.ma.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.ma.effects.EffectInit;
import com.ma.recipes.multiblock.MultiblockDefinition;
import com.ma.tools.RLoc;
import com.ma.tools.render.MultiblockRenderer;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SanctumTile
extends MultiblockTile
implements ITickableTileEntity {
    private static final HashMap<Faction, ResourceLocation> faction_structures = new HashMap();
    private Faction alignedFaction;

    public SanctumTile() {
        super((TileEntityType)TileEntityInit.CIRCLE_OF_POWER.get(), null);
    }

    public void setFaction(Faction faction) {
        this.alignedFaction = faction;
    }

    public boolean hasFaction() {
        return this.alignedFaction != null && this.alignedFaction != Faction.NONE;
    }

    @Override
    protected Optional<IMultiblockDefinition> getDefinition() {
        if (this._cachedMultiblockRecipe == null) {
            if (!faction_structures.containsKey((Object)this.alignedFaction)) {
                return Optional.empty();
            }
            ResourceLocation recipeId = faction_structures.get((Object)this.alignedFaction);
            this.field_145850_b.func_199532_z().func_215367_a(recipeId).ifPresent(r -> {
                if (r instanceof MultiblockDefinition) {
                    this._cachedMultiblockRecipe = (MultiblockDefinition)r;
                }
            });
        }
        return Optional.ofNullable(this._cachedMultiblockRecipe);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K && this.structureMatched && this.field_145850_b.func_82737_E() % 300L == 0L) {
            this.getDefinition().ifPresent(r -> {
                float sanctumScale = 6.0f;
                int hX = (int)((Math.ceil((float)r.getSize().func_177958_n() / 2.0f) + 1.0) * (double)sanctumScale);
                int hZ = (int)((Math.ceil((float)r.getSize().func_177952_p() / 2.0f) + 1.0) * (double)sanctumScale);
                AxisAlignedBB bb = new AxisAlignedBB(this.func_174877_v()).func_72321_a((double)hZ, (double)((float)(r.getSize().func_177956_o() + 1) * sanctumScale), (double)hZ).func_72321_a((double)(-hX), 0.0, (double)(-hZ));
                List entities = this.field_145850_b.func_217357_a(LivingEntity.class, bb);
                if (entities.size() > 0) {
                    entities.forEach(entity -> {
                        if (entity instanceof PlayerEntity) {
                            entity.getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(pr -> {
                                if (pr.getAlliedFaction() == this.alignedFaction) {
                                    entity.func_195064_c(new EffectInstance((Effect)EffectInit.CIRCLE_OF_POWER.get(), 600));
                                } else {
                                    this.setSacrifice((LivingEntity)entity);
                                }
                            });
                        } else {
                            this.setSacrifice((LivingEntity)entity);
                        }
                    });
                }
            });
        }
    }

    private void setSacrifice(LivingEntity entity) {
        float sacrificeDistance = 9.0f;
        if (this.alignedFaction == Faction.UNDEAD && entity.func_233580_cy_().func_177951_i((Vector3i)this.func_174877_v()) <= (double)sacrificeDistance) {
            entity.func_195064_c(new EffectInstance((Effect)EffectInit.SOUL_VULNERABILITY.get(), 100, 0, true, true));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setGhostMultiblock() {
        this.getDefinition().ifPresent(r -> {
            BlockPos anchorPos = this.field_174879_c.func_177984_a();
            MultiblockRenderer.setMultiblock(r, (ITextComponent)new TranslationTextComponent(r.func_199560_c().toString()), false);
            MultiblockRenderer.anchorTo(anchorPos, Rotation.NONE);
        });
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbt = new CompoundNBT();
        this.writeFactionToNBT(nbt);
        return new SUpdateTileEntityPacket(this.func_174877_v(), 0, nbt);
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT data = super.func_189517_E_();
        this.writeFactionToNBT(data);
        return data;
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        CompoundNBT nbt = pkt.func_148857_g();
        this.readFactionFromNBT(nbt);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        CompoundNBT data = super.func_189515_b(compound);
        this.writeFactionToNBT(data);
        return data;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.readFactionFromNBT(nbt);
    }

    private void writeFactionToNBT(CompoundNBT nbt) {
        if (this.alignedFaction != null) {
            nbt.func_74778_a("faction", this.alignedFaction.toString());
        }
    }

    private void readFactionFromNBT(CompoundNBT nbt) {
        if (nbt.func_74764_b("faction")) {
            try {
                this.alignedFaction = Faction.valueOf(nbt.func_74779_i("faction"));
            }
            catch (Exception ex) {
                ManaAndArtifice.LOGGER.error("Error parsing aligned faction on Circle of Power, setting to NONE.");
                ManaAndArtifice.LOGGER.error((Object)ex);
                this.alignedFaction = Faction.NONE;
            }
        }
    }

    @Override
    protected BlockPos getMatchOrigin() {
        return this.func_174877_v().func_177984_a();
    }

    static {
        faction_structures.put(Faction.ANCIENT_WIZARDS, RLoc.create("multiblock/council_circle"));
        faction_structures.put(Faction.FEY_COURT, RLoc.create("multiblock/fey_circle"));
        faction_structures.put(Faction.DEMONS, RLoc.create("multiblock/demon_circle"));
        faction_structures.put(Faction.UNDEAD, RLoc.create("multiblock/undead_circle"));
    }
}

