/*
 * Decompiled with CFR 0.152.
 */
package com.ma.blocks.tileentities;

import com.ma.api.blocks.tile.TileEntityWithInventory;
import com.ma.api.particles.MAParticleType;
import com.ma.api.particles.ParticleInit;
import com.ma.blocks.BlockInit;
import com.ma.blocks.runeforging.PedestalBlock;
import com.ma.blocks.runeforging.RuneforgeBlock;
import com.ma.blocks.tileentities.PedestalTile;
import com.ma.blocks.tileentities.init.TileEntityInit;
import com.ma.recipes.RecipeInit;
import com.ma.recipes.arcanefurnace.ArcaneFurnaceRecipe;
import com.ma.tools.MATags;
import com.ma.tools.RLoc;
import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.BlastingRecipe;
import net.minecraft.item.crafting.CampfireCookingRecipe;
import net.minecraft.item.crafting.FurnaceRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.common.extensions.IForgeTileEntity;

public class RuneForgeTile
extends TileEntityWithInventory
implements IForgeTileEntity,
ITickableTileEntity {
    private static final ResourceLocation tag_blacklist = RLoc.create("arcane_furnace_doubling_blacklist");
    private static final int MAX_ITEMS = 64;
    public static final int INVENTORY_SLOT_INDEX = 0;
    int smeltTicks = 0;
    int burnTime = 0;
    private boolean ignoreRecipeCheck = false;
    private boolean isRepairing = false;
    private ItemStack __cachedRecipeOutput;

    public RuneForgeTile(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn, 64);
    }

    public RuneForgeTile() {
        this((TileEntityType)TileEntityInit.RUNEFORGE.get());
    }

    @Override
    public void func_70299_a(int index, ItemStack stack) {
        super.func_70299_a(index, stack);
        if (!this.field_145850_b.field_72995_K) {
            boolean active = false;
            if (!this.ignoreRecipeCheck) {
                active = this.cacheRecipe();
            }
            if (active) {
                this.field_145850_b.func_180501_a(this.func_174877_v(), (BlockState)((BlockState)this.func_195044_w().func_206870_a((Property)RuneforgeBlock.ACTIVE, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)RuneforgeBlock.ORE_DOUBLING, (Comparable)Boolean.valueOf(this.hasMultiUpgrade())), 3);
                this.field_145850_b.func_180501_a(this.func_174877_v(), (BlockState)((BlockState)this.func_195044_w().func_206870_a((Property)RuneforgeBlock.ACTIVE, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)RuneforgeBlock.REPAIR, (Comparable)Boolean.valueOf(this.hasRepairUpgrade())), 3);
                this.smeltTicks = 0;
            } else {
                this.field_145850_b.func_180501_a(this.func_174877_v(), (BlockState)((BlockState)this.func_195044_w().func_206870_a((Property)RuneforgeBlock.ACTIVE, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)RuneforgeBlock.ORE_DOUBLING, (Comparable)Boolean.valueOf(false)), 3);
            }
            this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 3);
        }
    }

    @Override
    public ItemStack func_70298_a(int index, int count) {
        ItemStack output = super.func_70298_a(index, count);
        if (!output.func_190926_b()) {
            this.field_145850_b.func_180501_a(this.func_174877_v(), (BlockState)this.func_195044_w().func_206870_a((Property)RuneforgeBlock.ACTIVE, (Comparable)Boolean.valueOf(false)), 3);
        } else {
            this.field_145850_b.func_180501_a(this.func_174877_v(), this.func_195044_w(), 3);
        }
        return output;
    }

    public void func_70296_d() {
        if (this.field_145850_b != null) {
            this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 3);
        }
        super.func_70296_d();
    }

    private boolean cacheRecipe() {
        CraftingInventory inv = this.createDummyCraftingInventory();
        ArcaneFurnaceRecipe smeltRecipe = this.field_145850_b.func_199532_z().func_215371_a(RecipeInit.ARCANE_FURNACE_TYPE, (IInventory)inv, this.field_145850_b).orElse(null);
        this.__cachedRecipeOutput = null;
        ItemStack ingredient = this.func_70301_a(0);
        if (this.hasRepairUpgrade()) {
            if (!MATags.isItemEqual(ingredient, tag_blacklist)) {
                this.isRepairing = true;
                return true;
            }
            return false;
        }
        boolean ret = false;
        if (smeltRecipe != null) {
            this.__cachedRecipeOutput = smeltRecipe.func_77571_b();
            this.__cachedRecipeOutput.func_190920_e(this.__cachedRecipeOutput.func_190916_E() * this.func_70301_a(0).func_190916_E());
            this.burnTime = smeltRecipe.getBurnTime() * this.func_70301_a(0).func_190916_E();
            ret = true;
        } else {
            Optional cook_recipe = this.field_145850_b.func_199532_z().func_215371_a(IRecipeType.field_222153_e, (IInventory)inv, this.field_145850_b);
            if (cook_recipe.isPresent()) {
                this.__cachedRecipeOutput = ((CampfireCookingRecipe)cook_recipe.get()).func_77572_b((IInventory)inv);
                this.__cachedRecipeOutput.func_190920_e(this.__cachedRecipeOutput.func_190916_E() * this.func_70301_a(0).func_190916_E());
                this.burnTime = ((CampfireCookingRecipe)cook_recipe.get()).func_222137_e() / 2 * this.func_70301_a(0).func_190916_E();
                ret = true;
            } else {
                Optional furnace_recipe = this.field_145850_b.func_199532_z().func_215371_a(IRecipeType.field_222150_b, (IInventory)inv, this.field_145850_b);
                if (furnace_recipe.isPresent()) {
                    this.__cachedRecipeOutput = ((FurnaceRecipe)furnace_recipe.get()).func_77572_b((IInventory)inv);
                    this.__cachedRecipeOutput.func_190920_e(this.__cachedRecipeOutput.func_190916_E() * this.func_70301_a(0).func_190916_E());
                    this.burnTime = ((FurnaceRecipe)furnace_recipe.get()).func_222137_e() * 2 * this.func_70301_a(0).func_190916_E();
                    ret = true;
                } else {
                    Optional blasting_recipe = this.field_145850_b.func_199532_z().func_215371_a(IRecipeType.field_222151_c, (IInventory)inv, this.field_145850_b);
                    if (blasting_recipe.isPresent()) {
                        this.__cachedRecipeOutput = ((BlastingRecipe)blasting_recipe.get()).func_77572_b((IInventory)inv);
                        this.__cachedRecipeOutput.func_190920_e(this.__cachedRecipeOutput.func_190916_E() * this.func_70301_a(0).func_190916_E());
                        this.burnTime = ((BlastingRecipe)blasting_recipe.get()).func_222137_e() * 2 * this.func_70301_a(0).func_190916_E();
                        ret = true;
                    }
                }
            }
        }
        if ((Integer)this.func_195044_w().func_177229_b((Property)RuneforgeBlock.MATERIAL) == 1) {
            this.burnTime /= 4;
        }
        if (!MATags.isItemEqual(ingredient, tag_blacklist) && ret && this.hasMultiUpgrade()) {
            this.__cachedRecipeOutput.func_190920_e(Math.min(this.__cachedRecipeOutput.func_190916_E() * 2, 64));
        }
        return ret;
    }

    private boolean hasMultiUpgrade() {
        switch ((Direction)this.func_195044_w().func_177229_b((Property)RuneforgeBlock.FACING)) {
            case EAST: 
            case WEST: {
                return this.getPedestalUpgradeType(new BlockPos(Direction.NORTH.func_82601_c(), Direction.NORTH.func_96559_d(), Direction.NORTH.func_82599_e())) == CrystalUpgrade.DOUBLE && this.getPedestalUpgradeType(new BlockPos(Direction.SOUTH.func_82601_c(), Direction.SOUTH.func_96559_d(), Direction.SOUTH.func_82599_e())) == CrystalUpgrade.DOUBLE;
            }
        }
        return this.getPedestalUpgradeType(new BlockPos(Direction.EAST.func_82601_c(), Direction.EAST.func_96559_d(), Direction.EAST.func_82599_e())) == CrystalUpgrade.DOUBLE && this.getPedestalUpgradeType(new BlockPos(Direction.WEST.func_82601_c(), Direction.WEST.func_96559_d(), Direction.WEST.func_82599_e())) == CrystalUpgrade.DOUBLE;
    }

    private boolean hasRepairUpgrade() {
        switch ((Direction)this.func_195044_w().func_177229_b((Property)RuneforgeBlock.FACING)) {
            case EAST: 
            case WEST: {
                return this.getPedestalUpgradeType(new BlockPos(Direction.NORTH.func_82601_c(), Direction.NORTH.func_96559_d(), Direction.NORTH.func_82599_e())) == CrystalUpgrade.REPAIR && this.getPedestalUpgradeType(new BlockPos(Direction.SOUTH.func_82601_c(), Direction.SOUTH.func_96559_d(), Direction.SOUTH.func_82599_e())) == CrystalUpgrade.REPAIR;
            }
        }
        return this.getPedestalUpgradeType(new BlockPos(Direction.EAST.func_82601_c(), Direction.EAST.func_96559_d(), Direction.EAST.func_82599_e())) == CrystalUpgrade.REPAIR && this.getPedestalUpgradeType(new BlockPos(Direction.WEST.func_82601_c(), Direction.WEST.func_96559_d(), Direction.WEST.func_82599_e())) == CrystalUpgrade.REPAIR;
    }

    private CrystalUpgrade getPedestalUpgradeType(BlockPos offset) {
        PedestalTile pedestal;
        ItemStack stack;
        if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177971_a((Vector3i)offset)).func_177230_c() instanceof PedestalBlock && !(stack = (pedestal = (PedestalTile)this.field_145850_b.func_175625_s(this.field_174879_c.func_177971_a((Vector3i)offset))).func_70301_a(0)).func_190926_b() && stack.func_77973_b() instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)stack.func_77973_b();
            if (blockItem.func_179223_d() == BlockInit.CHIMERITE_CRYSTAL_ORANGE.get() || blockItem.func_179223_d() == BlockInit.CHIMERITE_CRYSTAL_RED.get() || blockItem.func_179223_d() == BlockInit.CHIMERITE_CRYSTAL_YELLOW.get()) {
                return CrystalUpgrade.DOUBLE;
            }
            if (blockItem.func_179223_d() == BlockInit.CHIMERITE_CRYSTAL_BLUE.get() || blockItem.func_179223_d() == BlockInit.CHIMERITE_CRYSTAL_CYAN.get() || blockItem.func_179223_d() == BlockInit.CHIMERITE_CRYSTAL_LIGHT_BLUE.get() || blockItem.func_179223_d() == BlockInit.CHIMERITE_CRYSTAL_WHITE.get()) {
                return CrystalUpgrade.REPAIR;
            }
        }
        return CrystalUpgrade.NONE;
    }

    @Override
    public ItemStack func_70304_b(int index) {
        ItemStack ret = super.func_70304_b(index);
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_180501_a(this.func_174877_v(), (BlockState)this.func_195044_w().func_206870_a((Property)RuneforgeBlock.ACTIVE, (Comparable)Boolean.valueOf(false)), 3);
            this.smeltTicks = 0;
        }
        return ret;
    }

    @Override
    public int func_70302_i_() {
        return 64;
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT base = super.func_189517_E_();
        CompoundNBT sub = new CompoundNBT();
        this.func_70301_a(0).func_77955_b(sub);
        base.func_218657_a("invSync", (INBT)sub);
        base.func_74757_a("repairing", this.isRepairing);
        return base;
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        super.handleUpdateTag(state, tag);
        CompoundNBT sub = tag.func_74775_l("invSync");
        this.func_70299_a(0, ItemStack.func_199557_a((CompoundNBT)sub));
        this.isRepairing = sub.func_74767_n("repairing");
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT data = new CompoundNBT();
        this.func_70301_a(0).func_77955_b(data);
        data.func_74757_a("repairing", this.isRepairing);
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, data);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        CompoundNBT data = pkt.func_148857_g();
        this.func_70299_a(0, ItemStack.func_199557_a((CompoundNBT)data));
        this.isRepairing = data.func_74767_n("repairing");
    }

    public int func_70297_j_() {
        return 64;
    }

    public ItemStack getDisplayedItem() {
        return this.func_70301_a(0);
    }

    public boolean MatchesReagent(ResourceLocation rLoc) {
        if (this.func_70301_a(0).func_190926_b()) {
            return false;
        }
        return MATags.isItemEqual(this.func_70301_a(0), rLoc);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74768_a("smelt_ticks", this.smeltTicks);
        return super.func_189515_b(compound);
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        if (compound.func_74764_b("smelt_ticks")) {
            this.smeltTicks = compound.func_74762_e("smelt_ticks");
        }
        super.func_230337_a_(state, compound);
    }

    public void func_73660_a() {
        if (((Boolean)this.func_195044_w().func_177229_b((Property)RuneforgeBlock.ACTIVE)).booleanValue()) {
            if (!this.field_145850_b.field_72995_K) {
                if (this.hasRepairUpgrade()) {
                    this.tickLogic_repair();
                } else {
                    this.tickLogic_smelt();
                }
            } else {
                this.spawnParticles();
            }
        }
    }

    private void tickLogic_repair() {
        int repair_rate;
        ItemStack stack = this.func_70301_a(0);
        if (stack.func_190926_b() || !stack.isRepairable() || !stack.func_77951_h()) {
            this.resetSelf();
        }
        ++this.smeltTicks;
        int n = repair_rate = (Integer)this.func_195044_w().func_177229_b((Property)RuneforgeBlock.MATERIAL) == 1 ? 1 : 5;
        if (this.smeltTicks % repair_rate == 0) {
            stack.func_196085_b(stack.func_77952_i() - 1);
        }
    }

    private void tickLogic_smelt() {
        if (this.__cachedRecipeOutput == null && !this.cacheRecipe()) {
            this.resetSelf();
            return;
        }
        ++this.smeltTicks;
        if (this.smeltTicks >= this.burnTime) {
            this.ignoreRecipeCheck = true;
            this.func_70299_a(0, this.__cachedRecipeOutput.func_77946_l());
            this.ignoreRecipeCheck = false;
            this.resetSelf();
            this.field_145850_b.func_180501_a(this.func_174877_v(), (BlockState)this.func_195044_w().func_206870_a((Property)RuneforgeBlock.ACTIVE, (Comparable)Boolean.valueOf(false)), 2);
        }
    }

    private void resetSelf() {
        this.smeltTicks = 0;
        this.burnTime = 0;
        this.isRepairing = false;
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_180501_a(this.func_174877_v(), (BlockState)this.func_195044_w().func_206870_a((Property)RuneforgeBlock.ACTIVE, (Comparable)Boolean.valueOf(false)), 2);
        }
    }

    private void spawnParticles() {
        BlockState state = this.func_195044_w();
        if (((Boolean)state.func_177229_b((Property)RuneforgeBlock.ACTIVE)).booleanValue()) {
            this.spawnActiveParticles(state);
            if (((Boolean)state.func_177229_b((Property)RuneforgeBlock.ORE_DOUBLING)).booleanValue()) {
                this.spawnDoublingParticles(state);
            }
            if (((Boolean)state.func_177229_b((Property)RuneforgeBlock.REPAIR)).booleanValue()) {
                this.spawnRepairParticles(state);
            }
        }
    }

    private void spawnActiveParticles(BlockState state) {
        Direction dir = (Direction)state.func_177229_b((Property)RuneforgeBlock.FACING);
        float xOffset = 0.5f;
        float zOffset = 0.5f;
        switch (dir) {
            default: {
                xOffset = 0.5f;
                zOffset = 0.35f;
                break;
            }
            case SOUTH: {
                xOffset = 0.5f;
                zOffset = 0.65f;
                break;
            }
            case EAST: {
                xOffset = 0.65f;
                zOffset = 0.5f;
                break;
            }
            case WEST: {
                xOffset = 0.35f;
                zOffset = 0.5f;
            }
        }
        for (int i = 0; i < 4; ++i) {
            this.field_145850_b.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)(this.isRepairing ? (ParticleType)ParticleInit.ARCANE.get() : ((Integer)state.func_177229_b((Property)RuneforgeBlock.MATERIAL) == 0 ? (ParticleType)ParticleInit.BLUE_FLAME.get() : (ParticleType)ParticleInit.FLAME.get()))), (double)((float)this.field_174879_c.func_177958_n() + xOffset + (-0.1f + this.field_145850_b.func_201674_k().nextFloat() * 0.2f)), (double)((float)this.field_174879_c.func_177956_o() + 0.4f + (-0.3f + this.field_145850_b.func_201674_k().nextFloat() * 0.6f)), (double)((float)this.field_174879_c.func_177952_p() + zOffset + (-0.1f + this.field_145850_b.func_201674_k().nextFloat() * 0.2f)), 0.0, this.isRepairing ? (double)0.03f : (double)0.01f, 0.0);
        }
    }

    private void spawnDoublingParticles(BlockState state) {
        BlockPos offset_1 = null;
        BlockPos offset_2 = null;
        switch ((Direction)this.func_195044_w().func_177229_b((Property)RuneforgeBlock.FACING)) {
            case EAST: 
            case WEST: {
                offset_1 = new BlockPos(Direction.NORTH.func_82601_c(), Direction.NORTH.func_96559_d(), Direction.NORTH.func_82599_e());
                offset_2 = new BlockPos(Direction.SOUTH.func_82601_c(), Direction.SOUTH.func_96559_d(), Direction.SOUTH.func_82599_e());
                break;
            }
            default: {
                offset_1 = new BlockPos(Direction.EAST.func_82601_c(), Direction.EAST.func_96559_d(), Direction.EAST.func_82599_e());
                offset_2 = new BlockPos(Direction.WEST.func_82601_c(), Direction.WEST.func_96559_d(), Direction.WEST.func_82599_e());
            }
        }
        if (offset_1 != null && offset_2 != null) {
            for (int i = 0; i < 5; ++i) {
                this.field_145850_b.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.FLAME_ORBIT.get())), (double)((float)(this.field_174879_c.func_177958_n() + offset_1.func_177958_n()) + 0.5f), (double)((float)(this.field_174879_c.func_177956_o() + offset_1.func_177956_o()) + 0.75f), (double)((float)(this.field_174879_c.func_177952_p() + offset_1.func_177952_p()) + 0.5f), (double)0.1f, (double)0.02f, (double)0.1f);
                this.field_145850_b.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.FLAME_ORBIT.get())), (double)((float)(this.field_174879_c.func_177958_n() + offset_2.func_177958_n()) + 0.5f), (double)((float)(this.field_174879_c.func_177956_o() + offset_2.func_177956_o()) + 0.75f), (double)((float)(this.field_174879_c.func_177952_p() + offset_2.func_177952_p()) + 0.5f), (double)0.1f, (double)0.02f, (double)0.1f);
            }
        }
    }

    private void spawnRepairParticles(BlockState state) {
        BlockPos offset_1 = null;
        BlockPos offset_2 = null;
        switch ((Direction)this.func_195044_w().func_177229_b((Property)RuneforgeBlock.FACING)) {
            case EAST: 
            case WEST: {
                offset_1 = new BlockPos(Direction.NORTH.func_82601_c(), Direction.NORTH.func_96559_d(), Direction.NORTH.func_82599_e());
                offset_2 = new BlockPos(Direction.SOUTH.func_82601_c(), Direction.SOUTH.func_96559_d(), Direction.SOUTH.func_82599_e());
                break;
            }
            default: {
                offset_1 = new BlockPos(Direction.EAST.func_82601_c(), Direction.EAST.func_96559_d(), Direction.EAST.func_82599_e());
                offset_2 = new BlockPos(Direction.WEST.func_82601_c(), Direction.WEST.func_96559_d(), Direction.WEST.func_82599_e());
            }
        }
        if (offset_1 != null && offset_2 != null) {
            for (int i = 0; i < 5; ++i) {
                this.field_145850_b.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.BLUE_SPARKLE_ORBIT.get())), (double)((float)(this.field_174879_c.func_177958_n() + offset_1.func_177958_n()) + 0.5f), (double)((float)(this.field_174879_c.func_177956_o() + offset_1.func_177956_o()) + 0.75f), (double)((float)(this.field_174879_c.func_177952_p() + offset_1.func_177952_p()) + 0.5f), (double)0.1f, (double)0.02f, (double)0.1f);
                this.field_145850_b.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.BLUE_SPARKLE_ORBIT.get())), (double)((float)(this.field_174879_c.func_177958_n() + offset_2.func_177958_n()) + 0.5f), (double)((float)(this.field_174879_c.func_177956_o() + offset_2.func_177956_o()) + 0.75f), (double)((float)(this.field_174879_c.func_177952_p() + offset_2.func_177952_p()) + 0.5f), (double)0.1f, (double)0.02f, (double)0.1f);
            }
        }
    }

    private CraftingInventory createDummyCraftingInventory() {
        CraftingInventory craftinginventory = new CraftingInventory(new Container(null, -1){

            public boolean func_75145_c(PlayerEntity playerIn) {
                return false;
            }
        }, 1, 1);
        craftinginventory.func_70299_a(0, this.func_70301_a(0));
        return craftinginventory;
    }

    @Override
    public boolean func_180462_a(int index, ItemStack itemStackIn, Direction direction) {
        if (index == 0) {
            return this.func_70301_a(0).func_190926_b();
        }
        return false;
    }

    @Override
    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        if (!ItemStack.func_179545_c((ItemStack)this.func_70301_a(index), (ItemStack)stack) || this.burnTime > 0) {
            return false;
        }
        if (index == 0) {
            return !this.func_70301_a(0).func_190926_b();
        }
        return false;
    }

    @Override
    public int[] func_180463_a(Direction side) {
        return new int[]{0};
    }

    private static enum CrystalUpgrade {
        NONE,
        DOUBLE,
        REPAIR;

    }
}

