/*
 * Decompiled with CFR 0.152.
 */
package com.ma.blocks.tileentities;

import com.ma.api.items.ChargeableItem;
import com.ma.api.particles.MAParticleType;
import com.ma.api.particles.ParticleInit;
import com.ma.blocks.runeforging.PedestalBlock;
import com.ma.blocks.tileentities.PedestalTile;
import com.ma.blocks.tileentities.init.TileEntityInit;
import com.ma.effects.EffectInit;
import com.ma.entities.constructs.animated.EntityAnimatedConstruct;
import com.ma.network.ServerMessageDispatcher;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class ManaCrystalTile
extends TileEntity
implements ITickableTileEntity {
    private ArrayList<Long> knownPedestalLocations = new ArrayList();
    private static final int SCAN_RADIUS = 8;

    public ManaCrystalTile() {
        super((TileEntityType)TileEntityInit.MANA_CRYSTAL.get());
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.field_145850_b.func_82737_E() % 80L == 0L) {
                this.addEffectsToPlayers();
                this.rechargeConstructs();
                this.scanForPedestals();
            }
            if (this.field_145850_b.func_82737_E() % 5L == 0L) {
                this.chargeItems();
            }
        }
    }

    private void addEffectsToPlayers() {
        double radius = 16.0;
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(this.field_174879_c).func_186662_g(radius);
        List list = this.field_145850_b.func_217357_a(PlayerEntity.class, axisalignedbb);
        Vector3d myPos = new Vector3d((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5);
        for (PlayerEntity playerentity : list) {
            double dist = myPos.func_72438_d(playerentity.func_213303_ch());
            int magnitudeByDist = 4 - (int)Math.floor(dist / 4.0);
            playerentity.func_195064_c(new EffectInstance((Effect)EffectInit.MANA_REGEN.get(), 100, magnitudeByDist, true, false, true));
        }
    }

    private void rechargeConstructs() {
        double radius = 16.0;
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(this.field_174879_c).func_186662_g(radius);
        List list = this.field_145850_b.func_217357_a(EntityAnimatedConstruct.class, axisalignedbb);
        Vector3d myPos = new Vector3d((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5);
        for (EntityAnimatedConstruct construct : list) {
            if (construct.getManaPct() == 1.0f) continue;
            double dist = myPos.func_72438_d(construct.func_213303_ch());
            int magnitudeByDist = 4 - (int)Math.floor(dist / 4.0);
            float manaRestored = magnitudeByDist * 10;
            construct.adjustMana(manaRestored);
            ServerMessageDispatcher.sendParticleSpawn((double)this.field_174879_c.func_177958_n() + 0.5, this.field_174879_c.func_177956_o() + 1, (double)this.field_174879_c.func_177952_p() + 0.5, construct.func_226277_ct_(), construct.func_226278_cu_() + 0.8, construct.func_226281_cx_(), 32.0f, (RegistryKey<World>)this.field_145850_b.func_234923_W_(), (MAParticleType)ParticleInit.LIGHTNING_BOLT.get());
        }
    }

    private void chargeItems() {
        if (this.knownPedestalLocations.size() == 0) {
            return;
        }
        int i = (int)Math.floor(Math.random() * (double)this.knownPedestalLocations.size());
        BlockPos curPos = BlockPos.func_218283_e((long)this.knownPedestalLocations.get(i));
        if (!this.field_145850_b.func_195588_v(curPos)) {
            return;
        }
        BlockState state = this.field_145850_b.func_180495_p(curPos);
        if (state.func_177230_c() instanceof PedestalBlock) {
            ChargeableItem item;
            PedestalTile pedestal;
            ItemStack stack;
            TileEntity te = this.field_145850_b.func_175625_s(curPos);
            if (te instanceof PedestalTile && (stack = (pedestal = (PedestalTile)te).func_70301_a(0)).func_77973_b() instanceof ChargeableItem && (item = (ChargeableItem)stack.func_77973_b()).getMana(stack) < item.getMaxMana()) {
                item.refundMana(pedestal.func_70301_a(0), 50.0f, null);
                ServerMessageDispatcher.sendParticleSpawn((double)this.field_174879_c.func_177958_n() + 0.5, this.field_174879_c.func_177956_o() + 1, (double)this.field_174879_c.func_177952_p() + 0.5, (double)curPos.func_177958_n() + 0.5, (double)curPos.func_177956_o() + 0.9, (double)curPos.func_177952_p() + 0.5, 32.0f, (RegistryKey<World>)this.field_145850_b.func_234923_W_(), (MAParticleType)ParticleInit.LIGHTNING_BOLT.get());
            }
        } else {
            this.knownPedestalLocations.remove(i--);
        }
    }

    private void scanForPedestals() {
        for (int i = -8; i <= 8; ++i) {
            for (int j = -8; j <= 8; ++j) {
                for (int k = -8; k <= 8; ++k) {
                    long posLong;
                    BlockState state;
                    BlockPos curPos = this.field_174879_c.func_177982_a(i, j, k);
                    if (!this.field_145850_b.func_195588_v(curPos) || !((state = this.field_145850_b.func_180495_p(curPos)).func_177230_c() instanceof PedestalBlock) || this.knownPedestalLocations.contains(posLong = curPos.func_218275_a())) continue;
                    this.knownPedestalLocations.add(posLong);
                }
            }
        }
    }
}

