/*
 * Decompiled with CFR 0.152.
 */
package com.ma.blocks.sorcery;

import com.ma.api.particles.MAParticleType;
import com.ma.api.particles.ParticleInit;
import com.ma.blocks.tileentities.InscriptionTableTile;
import com.ma.blocks.tileentities.init.TileEntityInit;
import com.ma.blocks.utility.WaterloggableBlockWithOffset;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class InscriptionTableBlock
extends WaterloggableBlockWithOffset {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final IntegerProperty CONTAINED_RESOURCES = IntegerProperty.func_177719_a((String)"contained_resources", (int)0, (int)7);

    public InscriptionTableBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200943_b(2.0f).func_200944_c().func_226896_b_(), false, new BlockPos(0, 1, 0));
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)CONTAINED_RESOURCES, (Comparable)Integer.valueOf(0)));
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{FACING, CONTAINED_RESOURCES});
    }

    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        Direction d1 = (Direction)stateIn.func_177229_b((Property)FACING);
        float h1 = 0.875f;
        float h2 = 0.75f;
        float v1 = 1.3125f;
        if (d1 == Direction.NORTH) {
            h2 = 1.0f - h2;
            h1 = 1.0f - h1;
        } else if (d1 == Direction.EAST) {
            h2 = 0.125f;
            h1 = 0.75f;
        } else if (d1 == Direction.WEST) {
            h2 = 0.875f;
            h1 = 0.25f;
        }
        worldIn.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.BLUE_FLAME.get())), (double)((float)pos.func_177958_n() + h1), (double)((float)pos.func_177956_o() + v1), (double)((float)pos.func_177952_p() + h2), 0.0, 0.0, 0.0);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)TileEntityInit.INSCRIPTION_TABLE.get()).func_200968_a();
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state = super.func_196258_a(context);
        if (state == null) {
            return null;
        }
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult p_225533_6_) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof InscriptionTableTile) {
            if (player.func_184812_l_()) {
                ((InscriptionTableTile)te).setCreative(true);
            } else {
                ((InscriptionTableTile)te).setCreative(false);
            }
            if (!worldIn.field_72995_K) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((InscriptionTableTile)te), (Consumer)((InscriptionTableTile)te));
            }
        }
        return ActionResultType.SUCCESS;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    @Override
    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            this.dropInventory(worldIn, pos);
        }
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    private void dropInventory(World world, BlockPos pos) {
        if (world.field_72995_K) {
            return;
        }
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof InscriptionTableTile) {
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((IInventory)tileEntity));
        }
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof InscriptionTableTile && ((InscriptionTableTile)te).isBuilding()) {
            return 15;
        }
        return 0;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean addDestroyEffects(BlockState state, World world, BlockPos pos, ParticleManager manager) {
        for (int i = 0; i < 20; ++i) {
            world.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, Blocks.field_196639_V.func_176223_P()), (double)pos.func_177958_n() + Math.random(), (double)pos.func_177956_o() + Math.random(), (double)pos.func_177952_p() + Math.random(), 0.0, 0.05 * Math.random(), 0.0);
        }
        return true;
    }
}

