/*
 * Decompiled with CFR 0.152.
 */
package com.ma.blocks.ritual;

import com.ma.api.rituals.IRitualReagent;
import com.ma.blocks.WaterloggableBlock;
import com.ma.blocks.interfaces.IDontCreateBlockItem;
import com.ma.blocks.interfaces.ITranslucentBlock;
import com.ma.blocks.tileentities.ChalkRuneTile;
import com.ma.blocks.tileentities.init.TileEntityInit;
import com.ma.config.GeneralClientConfig;
import com.ma.entities.EntityInit;
import com.ma.entities.rituals.EntityRitual;
import com.ma.items.filters.ItemFilterGroup;
import com.ma.tools.InventoryUtilities;
import com.ma.tools.MATags;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class ChalkRuneBlock
extends WaterloggableBlock
implements ITranslucentBlock,
IDontCreateBlockItem {
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.05, (double)16.0);
    public static final BooleanProperty ACTIVATED = BooleanProperty.func_177716_a((String)"activated");
    public static final BooleanProperty METAL = BooleanProperty.func_177716_a((String)"metal");
    public static final IntegerProperty RUNEINDEX = IntegerProperty.func_177719_a((String)"rune", (int)0, (int)9);
    private int heldItemActivateCount = 0;
    private long lastActivateTime = 0L;

    public ChalkRuneBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151593_r).harvestLevel(0).func_200943_b(0.1f).func_200942_a().func_226896_b_().func_200947_a(SoundType.field_185854_g), false);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)ACTIVATED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)METAL, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)RUNEINDEX, (Comparable)Integer.valueOf((int)Math.random() * 15)));
    }

    public BlockRenderType func_149645_b(BlockState blockState) {
        return BlockRenderType.MODEL;
    }

    public boolean canBeReplacedByLeaves(BlockState state, IWorldReader world, BlockPos pos) {
        return false;
    }

    public boolean canBeReplacedByLogs(BlockState state, IWorldReader world, BlockPos pos) {
        return false;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{ACTIVATED, RUNEINDEX, METAL});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)TileEntityInit.CHALK_RUNE.get()).func_200968_a();
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult p_225533_6_) {
        List rituals;
        ItemStack activeStack = player.func_184586_b(handIn);
        if (ItemFilterGroup.GROUND_RUNE_NON_PLACEABLE.anyMatchesFilter(activeStack)) {
            return ActionResultType.PASS;
        }
        if (((Boolean)state.func_177229_b((Property)ACTIVATED)).booleanValue() && (rituals = worldIn.func_217394_a((EntityType)EntityInit.RITUAL_ENTITY.get(), new AxisAlignedBB(pos).func_186662_g(16.0), e -> true)).size() > 0 && rituals.stream().anyMatch(r -> r.getState() != EntityRitual.RitualState.GUIDING_REAGENT_PLACEMENT)) {
            return ActionResultType.PASS;
        }
        if (worldIn.field_72995_K) {
            if (!activeStack.func_190926_b() && !((Boolean)GeneralClientConfig.RITUAL_TIP_SHOWN.get()).booleanValue() && ((Boolean)state.func_177229_b((Property)ACTIVATED)).booleanValue()) {
                if (worldIn.func_82737_E() - this.lastActivateTime < 200L) {
                    ++this.heldItemActivateCount;
                    if (this.heldItemActivateCount >= 4) {
                        GeneralClientConfig.RITUAL_TIP_SHOWN.set((Object)true);
                        player.func_145747_a((ITextComponent)new TranslationTextComponent("helptip.mana-and-artifice.ritual_empty_hand").func_240699_a_(TextFormatting.GOLD), Util.field_240973_b_);
                    }
                } else {
                    this.heldItemActivateCount = 0;
                }
                this.lastActivateTime = worldIn.func_82737_E();
            }
            return ActionResultType.SUCCESS;
        }
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity != null && tileEntity instanceof ChalkRuneTile) {
            ChalkRuneTile tecr = (ChalkRuneTile)tileEntity;
            if (!tecr.func_191420_l()) {
                ItemStack stack = tecr.func_70304_b(0);
                if (!player.func_191521_c(stack)) {
                    player.func_71019_a(stack, true);
                }
                worldIn.func_184138_a(pos, state, state, 2);
                worldIn.func_175666_e(pos, state.func_177230_c());
            } else {
                IRitualReagent reagent;
                if (activeStack.func_190926_b() && (reagent = this.getReagentFromNearbyRitual(worldIn, pos)) != null) {
                    if (!player.func_184812_l_()) {
                        activeStack = InventoryUtilities.removeSingleItemFromInventory(reagent.getResourceLocation(), (IInventory)player.field_71071_by);
                    } else {
                        List<Item> possibilities = MATags.smartLookupItem(reagent.getResourceLocation());
                        if (possibilities != null && possibilities.size() > 0) {
                            activeStack = new ItemStack((IItemProvider)possibilities.get((int)(Math.random() * (double)possibilities.size())));
                        }
                    }
                }
                if (!activeStack.func_190926_b() && tecr.func_191420_l()) {
                    ItemStack single = activeStack.func_77946_l();
                    single.func_190920_e(1);
                    tecr.func_70299_a(0, single);
                    worldIn.func_184138_a(pos, state, state, 2);
                    worldIn.func_175666_e(pos, state.func_177230_c());
                    if (!player.func_184812_l_()) {
                        activeStack.func_190918_g(1);
                    }
                }
            }
        }
        return ActionResultType.SUCCESS;
    }

    @Nullable
    private IRitualReagent getReagentFromNearbyRitual(World world, BlockPos pos) {
        AxisAlignedBB bb = new AxisAlignedBB(pos).func_186662_g(5.0);
        List rituals = world.func_217357_a(EntityRitual.class, bb);
        if (rituals == null || rituals.size() != 1) {
            return null;
        }
        return ((EntityRitual)((Object)rituals.get(0))).getReagentForPosition(pos);
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.IGNORE;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            this.notifyNearbyRitualsOfRuneDestruction(state, worldIn, pos);
            this.dropInventory(worldIn, pos);
        }
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    private void dropInventory(World world, BlockPos pos) {
        if (world.field_72995_K) {
            return;
        }
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity != null && tileEntity instanceof ChalkRuneTile && !((ChalkRuneTile)tileEntity).isGhostItem()) {
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((IInventory)tileEntity));
        }
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        if (((Boolean)state.func_177229_b((Property)ACTIVATED)).booleanValue()) {
            return 6;
        }
        return 0;
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!worldIn.field_72995_K && fromPos.equals((Object)pos.func_177977_b()) && !worldIn.func_180495_p(fromPos).func_200015_d((IBlockReader)worldIn, fromPos)) {
            worldIn.func_175655_b(pos, true);
        }
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te != null && te instanceof ChalkRuneTile && !((ChalkRuneTile)te).getDisplayedItem().func_190926_b()) {
            return 15;
        }
        return 0;
    }

    public void notifyNearbyRitualsOfRuneDestruction(BlockState blockState, World world, BlockPos pos) {
        if (world.field_72995_K) {
            return;
        }
        List rituals = world.func_217394_a((EntityType)EntityInit.RITUAL_ENTITY.get(), new AxisAlignedBB(pos).func_186662_g(16.0), e -> true);
        for (EntityRitual ritual : rituals) {
            ritual.checkForExplosion(false);
        }
    }

    @Override
    public boolean func_204510_a(IBlockReader worldIn, BlockPos pos, BlockState state, Fluid fluidIn) {
        if (state.func_235901_b_((Property)METAL) && ((Boolean)state.func_177229_b((Property)METAL)).booleanValue()) {
            return super.func_204510_a(worldIn, pos, state, fluidIn);
        }
        return true;
    }

    @Override
    public boolean func_204509_a(IWorld worldIn, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        if (state.func_235901_b_((Property)METAL) && !((Boolean)state.func_177229_b((Property)METAL)).booleanValue()) {
            worldIn.func_180501_a(pos, fluidStateIn.func_206883_i(), 3);
            return false;
        }
        return super.func_204509_a(worldIn, pos, state, fluidStateIn);
    }
}

