/*
 * Decompiled with CFR 0.152.
 */
package com.ma.blocks.artifice;

import com.ma.api.particles.MAParticleType;
import com.ma.api.particles.ParticleInit;
import com.ma.blocks.BlockInit;
import com.ma.blocks.interfaces.IDontCreateBlockItem;
import com.ma.blocks.interfaces.ITranslucentBlock;
import com.ma.blocks.tileentities.TransitoryTunnelTile;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TransitoryTunnelBlock
extends Block
implements IDontCreateBlockItem,
ITranslucentBlock {
    public static final IntegerProperty FACE_VISIBILITY_MASK = IntegerProperty.func_177719_a((String)"face_visibility", (int)0, (int)63);

    public TransitoryTunnelBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151579_a).func_200942_a().func_200943_b(0.0f).func_226896_b_().func_222380_e());
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TransitoryTunnelTile();
    }

    public boolean func_200122_a(BlockState state, BlockState adjacentBlockState, Direction side) {
        int check_mask = TransitoryTunnelBlock.getMaskForDirection(side);
        int state_mask = (Integer)state.func_177229_b((Property)FACE_VISIBILITY_MASK);
        return (state_mask & check_mask) != 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_220080_a(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return 1.0f;
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return true;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACE_VISIBILITY_MASK});
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        int mask = TransitoryTunnelBlock.getStateBasedOnSurroundings(worldIn, pos);
        if ((Integer)state.func_177229_b((Property)FACE_VISIBILITY_MASK) == mask) {
            return;
        }
        worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)FACE_VISIBILITY_MASK, (Comparable)Integer.valueOf(mask)), 3);
    }

    public static int getStateBasedOnSurroundings(World world, BlockPos pos) {
        int mask = 0;
        for (Direction d : Direction.values()) {
            mask |= TransitoryTunnelBlock.calculateDirectionalMask(world, pos, d);
        }
        return mask;
    }

    private static int calculateDirectionalMask(World world, BlockPos pos, Direction direction) {
        BlockState offsetState = world.func_180495_p(pos.func_177971_a(direction.func_176730_m()));
        if (offsetState.func_177230_c() != BlockInit.TRANSITORY_TUNNEL.get()) {
            return 0;
        }
        return TransitoryTunnelBlock.getMaskForDirection(direction);
    }

    private static int getMaskForDirection(Direction direction) {
        switch (direction) {
            default: {
                return 1;
            }
            case SOUTH: {
                return 2;
            }
            case EAST: {
                return 4;
            }
            case WEST: {
                return 8;
            }
            case UP: {
                return 16;
            }
            case DOWN: 
        }
        return 32;
    }

    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (worldIn.field_72995_K && rand.nextFloat() < 0.2f) {
            worldIn.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.ARCANE.get())), (double)((float)pos.func_177958_n() + rand.nextFloat()), (double)((float)pos.func_177956_o() + rand.nextFloat()), (double)((float)pos.func_177952_p() + rand.nextFloat()), 0.0, (double)0.1f, 0.0);
        }
    }
}

