/*
 * Decompiled with CFR 0.152.
 */
package com.ma.blocks;

import com.ma.ManaAndArtifice;
import com.ma.api.items.MAItemGroups;
import com.ma.api.items.TieredBlockItem;
import com.ma.blocks.BlockInit;
import com.ma.blocks.ICustomCategory;
import com.ma.blocks.interfaces.IDontCreateBlockItem;
import com.ma.items.worldgen.ItemWakebloom;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowerPotBlock;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="mana-and-artifice", bus=Mod.EventBusSubscriber.Bus.MOD)
public class BlockItemRegistration {
    @SubscribeEvent
    public static void onRegisterItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        BlockInit.BLOCKS.getEntries().stream().filter(b -> !(b.get() instanceof IDontCreateBlockItem) && !(b.get() instanceof FlowerPotBlock)).map(RegistryObject::get).forEach(block -> {
            Item.Properties properties = new Item.Properties().func_200916_a(block instanceof ICustomCategory ? ((ICustomCategory)block).getItemGroup() : MAItemGroups.items);
            TieredBlockItem blockItem = new TieredBlockItem((Block)block, properties);
            blockItem.setRegistryName(block.getRegistryName());
            registry.register((IForgeRegistryEntry)blockItem);
        });
        registry.register(new BlockItem((Block)BlockInit.AUM.get(), new Item.Properties().func_200916_a(MAItemGroups.items)).setRegistryName("mana-and-artifice", "aum"));
        registry.register(new BlockItem((Block)BlockInit.CERUBLOSSOM.get(), new Item.Properties().func_200916_a(MAItemGroups.items)).setRegistryName("mana-and-artifice", "cerublossom"));
        registry.register(new BlockItem((Block)BlockInit.TARMA_ROOT.get(), new Item.Properties().func_200916_a(MAItemGroups.items)).setRegistryName("mana-and-artifice", "tarma_root"));
        registry.register(new ItemWakebloom((Block)BlockInit.WAKEBLOOM.get(), new Item.Properties().func_200916_a(MAItemGroups.items)).setRegistryName("mana-and-artifice", "wakebloom"));
        registry.register(new BlockItem((Block)BlockInit.DESERT_NOVA.get(), new Item.Properties().func_200916_a(MAItemGroups.items)).setRegistryName("mana-and-artifice", "desert_nova"));
        ManaAndArtifice.LOGGER.info("M&A -> Block Items Registered");
    }

    @SubscribeEvent
    public static void setup(FMLCommonSetupEvent event) {
        ((FlowerPotBlock)Blocks.field_150457_bL).addPlant(BlockInit.AUM.getId(), BlockInit.POTTED_AUM);
        ((FlowerPotBlock)Blocks.field_150457_bL).addPlant(BlockInit.CERUBLOSSOM.getId(), BlockInit.POTTED_CERUBLOSSOM);
        ((FlowerPotBlock)Blocks.field_150457_bL).addPlant(BlockInit.WAKEBLOOM.getId(), BlockInit.POTTED_WAKEBLOOM);
        ((FlowerPotBlock)Blocks.field_150457_bL).addPlant(BlockInit.TARMA_ROOT.getId(), BlockInit.POTTED_TARMA_ROOT);
        ((FlowerPotBlock)Blocks.field_150457_bL).addPlant(BlockInit.DESERT_NOVA.getId(), BlockInit.POTTED_DESERT_NOVA);
        ManaAndArtifice.LOGGER.info("M&A -> Flower Pots Registered");
    }
}

