/*
 * Decompiled with CFR 0.152.
 */
package com.ma.api.faction;

import com.ma.api.entities.IFactionEnemy;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;

public class FactionDifficultyStats {
    private int haste_buff = -1;
    private int factionMobDespawnCount = 0;
    private HashMap<String, Integer> factionMobKilledByStats = new HashMap();
    private HashMap<String, Integer> factionMobResistanceBuffs = new HashMap();

    public void onFactionMobKilled(DamageSource source) {
        if (source.func_76363_c()) {
            return;
        }
        this.factionMobKilledByStats.put(source.field_76373_n, this.factionMobKilledByStats.getOrDefault(source.field_76373_n, 0) + 1);
        if (this.factionMobKilledByStats.get(source.field_76373_n) > 15) {
            this.factionMobKilledByStats.put(source.field_76373_n, this.factionMobKilledByStats.getOrDefault(source.field_76373_n, 0) - 15);
            this.factionMobResistanceBuffs.put(source.field_76373_n, Math.min(this.factionMobResistanceBuffs.getOrDefault(source.field_76373_n, -1) + 1, 4));
        }
    }

    public void onFactionMobDespawnDueToDistance() {
        ++this.factionMobDespawnCount;
        if (this.factionMobDespawnCount > 15) {
            this.factionMobDespawnCount -= 15;
            this.haste_buff = Math.min(this.haste_buff + 1, 5);
        }
    }

    public void onFactionKilledPlayer() {
        for (String key : this.factionMobKilledByStats.keySet()) {
            this.factionMobKilledByStats.put(key, Math.max(this.factionMobKilledByStats.get(key) - 1, 0));
        }
        --this.factionMobDespawnCount;
    }

    public void adjustFactionEnemy(IFactionEnemy<?> factionMob) {
        if (this.haste_buff > -1) {
            ((LivingEntity)factionMob).func_195064_c(new EffectInstance(Effects.field_76422_e, 9999, this.haste_buff));
        }
        for (Map.Entry<String, Integer> source : this.factionMobResistanceBuffs.entrySet()) {
            factionMob.setDamageResists(source.getKey(), source.getValue());
        }
    }

    public CompoundNBT writeToNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a("haste_buff", this.haste_buff);
        nbt.func_74768_a("factionMobDespawnCount", this.factionMobDespawnCount);
        ListNBT list_kills = new ListNBT();
        for (Map.Entry<String, Integer> e : this.factionMobKilledByStats.entrySet()) {
            CompoundNBT list_item = new CompoundNBT();
            list_item.func_74778_a("key", e.getKey());
            list_item.func_74768_a("value", e.getValue().intValue());
            list_kills.add((Object)list_item);
        }
        nbt.func_218657_a("kill_counts", (INBT)list_kills);
        ListNBT list_resist_buffs = new ListNBT();
        for (Map.Entry<String, Integer> e : this.factionMobResistanceBuffs.entrySet()) {
            CompoundNBT list_item = new CompoundNBT();
            list_item.func_74778_a("key", e.getKey());
            list_item.func_74768_a("value", e.getValue().intValue());
            list_resist_buffs.add((Object)list_item);
        }
        nbt.func_218657_a("resist_buffs", (INBT)list_resist_buffs);
        return nbt;
    }

    public void readFromNBT(CompoundNBT nbt) {
        this.haste_buff = nbt.func_74762_e("haste_buff");
        this.factionMobDespawnCount = nbt.func_74762_e("factionMobDespawnCount");
        nbt.func_150295_c("kill_counts", 10).forEach(l -> this.factionMobKilledByStats.put(((CompoundNBT)l).func_74779_i("key"), ((CompoundNBT)l).func_74762_e("value")));
        nbt.func_150295_c("resist_buffs", 10).forEach(l -> this.factionMobResistanceBuffs.put(((CompoundNBT)l).func_74779_i("key"), ((CompoundNBT)l).func_74762_e("value")));
    }
}

