/*
 * Decompiled with CFR 0.152.
 */
package com.ma.api.entities;

import com.ma.api.capabilities.Faction;
import com.ma.api.entities.IFactionEnemy;
import com.mojang.datafixers.util.Pair;
import java.security.InvalidParameterException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;

public class FactionRaidRegistry {
    private static final HashMap<EntityType<? extends IFactionEnemy<? extends MobEntity>>, HashMap<Integer, Integer>> councilSoldiers = new HashMap();
    private static final HashMap<EntityType<? extends IFactionEnemy<? extends MobEntity>>, HashMap<Integer, Integer>> feySoldiers = new HashMap();
    private static final HashMap<EntityType<? extends IFactionEnemy<? extends MobEntity>>, HashMap<Integer, Integer>> demonSoldiers = new HashMap();
    private static final HashMap<EntityType<? extends IFactionEnemy<? extends MobEntity>>, HashMap<Integer, Integer>> undeadSoldiers = new HashMap();

    public static int getStrengthRating(Faction faction, EntityType<? extends IFactionEnemy<? extends MobEntity>> entityType, int tier) {
        switch (faction) {
            case ANCIENT_WIZARDS: {
                return councilSoldiers.containsKey(entityType) ? FactionRaidRegistry.keyFromValue(councilSoldiers.get(entityType), tier) : -1;
            }
            case DEMONS: {
                return demonSoldiers.containsKey(entityType) ? FactionRaidRegistry.keyFromValue(demonSoldiers.get(entityType), tier) : -1;
            }
            case FEY_COURT: {
                return feySoldiers.containsKey(entityType) ? FactionRaidRegistry.keyFromValue(feySoldiers.get(entityType), tier) : -1;
            }
            case UNDEAD: {
                return undeadSoldiers.containsKey(entityType) ? FactionRaidRegistry.keyFromValue(undeadSoldiers.get(entityType), tier) : -1;
            }
        }
        return 0;
    }

    private static int keyFromValue(HashMap<Integer, Integer> values, int target) {
        return values.entrySet().stream().filter(e -> (Integer)e.getValue() == target).map(e -> (Integer)e.getKey()).findFirst().orElse(-1);
    }

    public static void registerSoldier(Faction faction, EntityType<? extends IFactionEnemy<? extends MobEntity>> entityType, HashMap<Integer, Integer> tierStrengthRatings) {
        for (Integer strength : tierStrengthRatings.keySet()) {
            if (tierStrengthRatings.get(strength) < 0) {
                throw new InvalidParameterException("Tier minimum is 0!");
            }
            if (strength > 0) continue;
            throw new InvalidParameterException("Strength rating must be greater than zero or you risk infinite loops!");
        }
        switch (faction) {
            case ANCIENT_WIZARDS: {
                councilSoldiers.put(entityType, tierStrengthRatings);
                break;
            }
            case DEMONS: {
                demonSoldiers.put(entityType, tierStrengthRatings);
                break;
            }
            case FEY_COURT: {
                feySoldiers.put(entityType, tierStrengthRatings);
                break;
            }
            case UNDEAD: {
                undeadSoldiers.put(entityType, tierStrengthRatings);
                break;
            }
            default: {
                throw new InvalidParameterException("Cannot register faction enemies for faction " + faction.toString());
            }
        }
    }

    @Nullable
    public static Pair<EntityType<? extends IFactionEnemy<? extends MobEntity>>, Integer> getSoldier(Faction faction, int raidStrength) {
        switch (faction) {
            case ANCIENT_WIZARDS: {
                return FactionRaidRegistry.pickSoldier(councilSoldiers, raidStrength);
            }
            case DEMONS: {
                return FactionRaidRegistry.pickSoldier(demonSoldiers, raidStrength);
            }
            case FEY_COURT: {
                return FactionRaidRegistry.pickSoldier(feySoldiers, raidStrength);
            }
            case UNDEAD: {
                return FactionRaidRegistry.pickSoldier(undeadSoldiers, raidStrength);
            }
        }
        return null;
    }

    @Nullable
    private static Pair<EntityType<? extends IFactionEnemy<? extends MobEntity>>, Integer> pickSoldier(HashMap<EntityType<? extends IFactionEnemy<? extends MobEntity>>, HashMap<Integer, Integer>> list, int raidStrength) {
        if (list.size() == 0) {
            return null;
        }
        List possibles = list.entrySet().stream().filter(e -> ((HashMap)e.getValue()).keySet().stream().anyMatch(i -> i <= raidStrength)).collect(Collectors.toList());
        if (possibles.size() == 0) {
            return null;
        }
        Map.Entry entry = (Map.Entry)possibles.get(new Random().nextInt(possibles.size()));
        int maxStr = (Integer)Collections.max(((HashMap)entry.getValue()).keySet().stream().filter(i -> i <= raidStrength).collect(Collectors.toList()));
        int tier = (Integer)((HashMap)entry.getValue()).get(maxStr);
        return new Pair(entry.getKey(), (Object)tier);
    }
}

