// Quick test to verify all complex types are available from the generated package
import type {
  // Polymorphic notification types
  Notification,
  EmailNotification,
  SmsNotification,
  PushNotification,
  InAppNotification,
  NotificationPriority,
  EmailAttachment,

  // Payment method discriminated unions
  PaymentMethod,
  CreditCardPayment,
  PayPalPayment,
  BankAccountPayment,
  CryptoPayment,
  CardType,
  BankAccountType,
  CryptoCurrency,

  // Generic wrapper types
  PaginatedResponse,
  ApiResponse,
  PaginationMetadata,
  ApiError,

  // Complex organization hierarchy
  Organization,
  Department,
  Employee,
  OrganizationSettings,
  SecuritySettings,
  DepartmentBudget,
  Address,
  ContactInfo,
  OrganizationType,
  EmployeeRole,

  // Existing types
  Product,
  Order
} from '@mycompany/api-types';

// Test polymorphic notification
const emailNotif: EmailNotification = {
  id: 1,
  title: 'Test Email',
  message: 'Test message',
  createdAt: new Date(),
  isRead: false,
  priority: NotificationPriority._1,
  type: 'email',
  from: 'test@example.com',
  to: 'user@example.com',
  cc: ['admin@example.com'],
  attachments: []
};

// Test payment method discriminated union
const creditCard: CreditCardPayment = {
  id: 1,
  isDefault: true,
  createdAt: new Date(),
  methodType: 'credit_card',
  cardholderName: 'John Doe',
  last4Digits: '4242',
  brand: 'Visa',
  expirationMonth: 12,
  expirationYear: 2025,
  cardType: CardType._0
};

// Test generic paginated response
const paginatedNotifications: PaginatedResponse<Notification> = {
  items: [emailNotif],
  pagination: {
    currentPage: 1,
    pageSize: 10,
    totalItems: 1,
    totalPages: 1,
    hasNextPage: false,
    hasPreviousPage: false
  }
};

// Test complex organization hierarchy
const organization: Organization = {
  id: 1,
  name: 'Acme Corp',
  type: OrganizationType._0,
  foundedDate: new Date('2010-01-01'),
  settings: {
    allowPublicProfile: true,
    maxEmployees: 500,
    currency: 'USD',
    security: {
      requireTwoFactor: true,
      requireStrongPasswords: true,
      passwordExpirationDays: 90,
      maxLoginAttempts: 5
    }
  },
  departments: [],
  customFields: {},
  contactInfo: {}
};

console.log('✅ All complex types imported and validated successfully!');
console.log('✅ Polymorphic types:', emailNotif.type);
console.log('✅ Discriminated unions:', creditCard.methodType);
console.log('✅ Generic types:', paginatedNotifications.items?.length);
console.log('✅ Complex nested types:', organization.settings.security.requireTwoFactor);
