namespace ProductApi.Models;

/// <summary>
/// Represents a product in the catalog
/// </summary>
public class Product
{
    public int Id { get; set; }
    public string Name { get; set; } = string.Empty;
    public string Description { get; set; } = string.Empty;
    public decimal Price { get; set; }
    public int StockQuantity { get; set; }
    public string Category { get; set; } = string.Empty;
    public string SKU { get; set; } = string.Empty;
    public DateTime CreatedAt { get; set; }
    public DateTime? UpdatedAt { get; set; }
    public bool IsActive { get; set; }
    public List<string> Tags { get; set; } = new();
    public ProductDimensions? Dimensions { get; set; }
}

public class ProductDimensions
{
    public double Width { get; set; }
    public double Height { get; set; }
    public double Depth { get; set; }
    public double Weight { get; set; }
    public string Unit { get; set; } = "cm";
    public string WeightUnit { get; set; } = "kg";
}