namespace ProductApi.Models;

/// <summary>
/// Organization with complex nested hierarchy
/// </summary>
public class Organization
{
    public int Id { get; set; }
    public string Name { get; set; } = string.Empty;
    public string? Description { get; set; }
    public OrganizationType Type { get; set; }
    public DateTime FoundedDate { get; set; }
    public OrganizationSettings Settings { get; set; } = new();
    public List<Department> Departments { get; set; } = new();
    public Dictionary<string, string> CustomFields { get; set; } = new();
    public Address? HeadquartersAddress { get; set; }
    public ContactInfo ContactInfo { get; set; } = new();
}

/// <summary>
/// Department within an organization
/// </summary>
public class Department
{
    public int Id { get; set; }
    public string Name { get; set; } = string.Empty;
    public string? Code { get; set; }
    public int? ParentDepartmentId { get; set; }
    public Employee? Manager { get; set; }
    public List<Employee> Employees { get; set; } = new();
    public DepartmentBudget? Budget { get; set; }
    public List<string> Responsibilities { get; set; } = new();
}

/// <summary>
/// Employee information
/// </summary>
public class Employee
{
    public int Id { get; set; }
    public string FirstName { get; set; } = string.Empty;
    public string LastName { get; set; } = string.Empty;
    public string Email { get; set; } = string.Empty;
    public string? PhoneNumber { get; set; }
    public EmployeeRole Role { get; set; }
    public DateTime HireDate { get; set; }
    public DateTime? TerminationDate { get; set; }
    public decimal Salary { get; set; }
    public Address? HomeAddress { get; set; }
    public List<string> Skills { get; set; } = new();
    public Dictionary<string, string> Certifications { get; set; } = new();
}

public class OrganizationSettings
{
    public bool AllowPublicProfile { get; set; }
    public int MaxEmployees { get; set; }
    public TimeZoneInfo TimeZone { get; set; } = TimeZoneInfo.Local;
    public string Currency { get; set; } = "USD";
    public List<string> AllowedDomains { get; set; } = new();
    public SecuritySettings Security { get; set; } = new();
}

public class SecuritySettings
{
    public bool RequireTwoFactor { get; set; }
    public bool RequireStrongPasswords { get; set; }
    public int PasswordExpirationDays { get; set; }
    public int MaxLoginAttempts { get; set; }
    public List<string> AllowedIpRanges { get; set; } = new();
}

public class DepartmentBudget
{
    public decimal AnnualBudget { get; set; }
    public decimal SpentToDate { get; set; }
    public decimal RemainingBudget { get; set; }
    public int FiscalYear { get; set; }
    public Dictionary<string, decimal> CategoryBreakdown { get; set; } = new();
}

public class Address
{
    public string Street { get; set; } = string.Empty;
    public string? Street2 { get; set; }
    public string City { get; set; } = string.Empty;
    public string State { get; set; } = string.Empty;
    public string PostalCode { get; set; } = string.Empty;
    public string Country { get; set; } = string.Empty;
    public double? Latitude { get; set; }
    public double? Longitude { get; set; }
}

public class ContactInfo
{
    public string? PrimaryPhone { get; set; }
    public string? SecondaryPhone { get; set; }
    public string? Email { get; set; }
    public string? Website { get; set; }
    public Dictionary<string, string> SocialMedia { get; set; } = new();
}

public enum OrganizationType
{
    Corporation,
    LLC,
    Partnership,
    SoleProprietorship,
    NonProfit,
    Government
}

public enum EmployeeRole
{
    Employee,
    Manager,
    Director,
    VP,
    CLevel,
    Contractor
}
