/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl.ui;

import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import snownee.jade.api.JadeIds;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.ui.Element;
import snownee.jade.api.ui.IDisplayHelper;
import snownee.jade.overlay.DisplayHelper;

public class ArmorElement
extends Element {
    public static final class_2960 ARMOR = class_2960.method_60656((String)"hud/armor_full");
    public static final class_2960 HALF_ARMOR = class_2960.method_60656((String)"hud/armor_half");
    public static final class_2960 EMPTY_ARMOR = class_2960.method_60656((String)"hud/armor_empty");
    private final float armor;
    private String text;
    private int iconsPerLine = 1;
    private int lineCount = 1;
    private int iconCount = 1;

    public ArmorElement(float armor) {
        this.armor = armor;
        IPluginConfig config = IWailaConfig.get().plugin();
        if (armor > (float)config.getInt(JadeIds.MC_ENTITY_ARMOR_MAX_FOR_RENDER)) {
            if (!config.get(JadeIds.MC_ENTITY_HEALTH_SHOW_FRACTIONS)) {
                armor = class_3532.method_15386((float)armor);
            }
            this.text = DisplayHelper.dfCommas.format(armor);
        } else {
            int maxHeartsPerLine = config.getInt(JadeIds.MC_ENTITY_HEALTH_ICONS_PER_LINE);
            this.iconCount = class_3532.method_15386((float)(armor *= 0.5f));
            this.iconsPerLine = Math.min(maxHeartsPerLine, this.iconCount);
            this.lineCount = class_3532.method_15386((float)(armor / (float)maxHeartsPerLine));
        }
        if (this.showText()) {
            this.width = DisplayHelper.font().method_1727(this.text) + 10;
            this.height = 9;
        } else {
            this.width = 8 * this.iconsPerLine + 1;
            this.height = 5 + 4 * this.lineCount;
        }
    }

    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        IDisplayHelper helper = IDisplayHelper.get();
        int x = this.method_46426();
        int y = this.method_46427();
        int xOffset = (this.iconCount - 1) % this.iconsPerLine * 8;
        int yOffset = this.lineCount * 4 - 4;
        for (int i = this.iconCount; i > 0; --i) {
            helper.blitSprite(graphics, class_10799.field_56883, EMPTY_ARMOR, x + xOffset, y + yOffset, 9, 9);
            if (i <= class_3532.method_15375((float)this.armor)) {
                helper.blitSprite(graphics, class_10799.field_56883, ARMOR, x + xOffset, y + yOffset, 9, 9);
            }
            if ((float)i > this.armor && (float)i < this.armor + 1.0f) {
                helper.blitSprite(graphics, class_10799.field_56883, HALF_ARMOR, x + xOffset, y + yOffset, 9, 9);
            }
            if ((xOffset -= 8) >= 0) continue;
            xOffset = this.iconsPerLine * 8 - 8;
            yOffset -= 4;
        }
        if (this.showText()) {
            helper.drawText(graphics, this.text, (float)(x + 10), (float)(y + 1), IThemeHelper.get().getNormalColor());
        }
    }

    @Override
    public class_2561 getNarration() {
        return class_2561.method_43469((String)"narration.jade.armor", (Object[])new Object[]{class_3532.method_15386((float)this.armor)});
    }

    public boolean showText() {
        return this.text != null;
    }
}

