/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdabettergrass.metadata;

import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.lambdaurora.lambdabettergrass.metadata.grass.LBGGrassLayer;
import dev.lambdaurora.lambdabettergrass.metadata.grass.LBGLoadingGrassLayer;
import dev.lambdaurora.lambdabettergrass.model.LBGBakedModel;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_1087;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_4730;
import net.minecraft.class_9826;
import org.jetbrains.annotations.Nullable;

public class LBGMetadata {
    public final class_2960 id;
    protected final class_3300 resourceManager;
    protected final List<class_4730> textures = new ArrayList<class_4730>();
    private final List<LBGGrassLayer> layers;
    protected Consumer<class_1087> snowyModelVariantProvider = null;
    protected class_1087 snowyModelVariant = null;

    public LBGMetadata(class_3300 resourceManager, class_2960 id, JsonObject json) {
        this.id = id;
        this.resourceManager = resourceManager;
        ArrayList loadingLayers = new ArrayList();
        if (json.has("layers")) {
            json.getAsJsonArray("layers").forEach(layer -> loadingLayers.add((LBGLoadingGrassLayer)LBGLoadingGrassLayer.CODEC.parse((DynamicOps)JsonOps.INSTANCE, layer).result().orElseThrow()));
        }
        Int2ObjectArrayMap layers = new Int2ObjectArrayMap();
        for (LBGLoadingGrassLayer loadingLayer : loadingLayers) {
            List list = (List)layers.computeIfAbsent(loadingLayer.colorIndex(), ignored -> new ArrayList());
            list.add(loadingLayer);
        }
        this.layers = layers.values().stream().map(layer -> new LBGGrassLayer(resourceManager, this, (List<LBGLoadingGrassLayer>)layer)).toList();
    }

    public void bakeTextures(class_9826 textureGetter) {
        for (LBGGrassLayer layer : this.layers) {
            layer.bakeTextures(textureGetter);
        }
    }

    public Optional<LBGGrassLayer> getLayer(int colorIndex) {
        for (LBGGrassLayer layer : this.layers) {
            if (layer.colorIndex != colorIndex) continue;
            return Optional.of(layer);
        }
        return Optional.empty();
    }

    public Collection<class_4730> getTextures() {
        return this.textures;
    }

    @Nullable
    public class_1087 getSnowyModelVariant() {
        return this.snowyModelVariant;
    }

    public void propagate(LBGBakedModel model) {
        if (this.snowyModelVariantProvider != null) {
            this.snowyModelVariantProvider.accept((class_1087)model);
        }
    }

    public String toString() {
        return "LBGMetadata{id=" + String.valueOf(this.id) + ", layers=" + String.valueOf(this.layers) + "}";
    }
}

