/*
 * Decompiled with CFR 0.152.
 */
package org.anti_ad.mc.ipnext.item.rule;

import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.anti_ad.mc.ipnext.Log;
import org.anti_ad.mc.ipnext.item.ItemType;
import org.anti_ad.mc.ipnext.item.rule.ArgumentMap;
import org.anti_ad.mc.ipnext.item.rule.EmptyRule;
import org.anti_ad.mc.ipnext.item.rule.Rule;
import org.anti_ad.mc.ipnext.item.rule.parameter.NativeParametersKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseRule
implements Rule {
    @NotNull
    private final ArgumentMap arguments = new ArgumentMap();
    @NotNull
    private final Function2 defaultComparator;
    @Nullable
    private Exception createdHere;
    @NotNull
    private Function2 comparator = this.defaultComparator = BaseRule::defaultComparator$lambda$0;
    @NotNull
    private final Lazy lazyCompare$delegate;

    public BaseRule() {
        ArgumentMap argumentMap = this.arguments;
        argumentMap.defineParameter(NativeParametersKt.getReverse(), Boolean.FALSE);
        argumentMap.defineParameter(NativeParametersKt.getSub_rule(), EmptyRule.INSTANCE);
        this.lazyCompare$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> BaseRule.lazyCompare_delegate$lambda$4(this));
    }

    @Override
    @NotNull
    public final ArgumentMap getArguments() {
        return this.arguments;
    }

    @NotNull
    public final Function2 getComparator() {
        Exception exception = this.createdHere;
        if (this.comparator == this.defaultComparator) {
            Log.INSTANCE.trace("Using default comparator");
        } else {
            String string = "Using comparator set by user: " + this.comparator + ", created at:";
            Exception exception2 = exception;
            Intrinsics.checkNotNull((Object)exception2);
            Log.INSTANCE.trace(string, exception2);
        }
        return this.comparator;
    }

    public final void setComparator(@NotNull Function2 function2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"");
        if (this.comparator != this.defaultComparator) {
            Log.INSTANCE.trace("Overwriting comparator form  " + this.comparator + " to " + function2, new Exception());
        }
        this.comparator = function2;
        if (function2 != this.defaultComparator) {
            this.createdHere = new Exception();
        }
    }

    private final Function2 getLazyCompare() {
        return (Function2)this.lazyCompare$delegate.getValue();
    }

    @Override
    public final int compare(@NotNull ItemType itemType, @NotNull ItemType itemType2) {
        Intrinsics.checkNotNullParameter((Object)itemType, (String)"");
        Intrinsics.checkNotNullParameter((Object)itemType2, (String)"");
        return ((Number)this.getLazyCompare().invoke((Object)itemType, (Object)itemType2)).intValue();
    }

    private static final int defaultComparator$lambda$0(ItemType itemType, ItemType itemType2) {
        Intrinsics.checkNotNullParameter((Object)itemType, (String)"");
        Intrinsics.checkNotNullParameter((Object)itemType2, (String)"");
        return 0;
    }

    private static final int lazyCompare_delegate$lambda$4$lambda$2(BaseRule baseRule, int n2, ItemType itemType, ItemType itemType2) {
        return ((Number)baseRule.getComparator().invoke((Object)itemType, (Object)itemType2)).intValue() * n2;
    }

    private static final int lazyCompare_delegate$lambda$4$lambda$3(BaseRule baseRule, int n2, Rule rule, ItemType itemType, ItemType itemType2) {
        int n3 = ((Number)baseRule.getComparator().invoke((Object)itemType, (Object)itemType2)).intValue();
        if (n3 != 0) {
            return n3 * n2;
        }
        return rule.compare(itemType, itemType2);
    }

    private static final Function2 lazyCompare_delegate$lambda$4(BaseRule baseRule) {
        int n2;
        int n3 = n2 = (Boolean)baseRule.arguments.get(NativeParametersKt.getReverse()) != false ? -1 : 1;
        if (baseRule.arguments.isDefaultValue(NativeParametersKt.getSub_rule())) {
            return (arg_0, arg_1) -> BaseRule.lazyCompare_delegate$lambda$4$lambda$2(baseRule, n2, arg_0, arg_1);
        }
        Rule rule = (Rule)baseRule.arguments.get(NativeParametersKt.getSub_rule());
        return (arg_0, arg_1) -> BaseRule.lazyCompare_delegate$lambda$4$lambda$3(baseRule, n2, rule, arg_0, arg_1);
    }
}

