/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.mod.vanilla;

import journeymap.client.cartography.color.RGB;
import journeymap.client.mod.IBlockColorProxy;
import journeymap.client.mod.ModBlockDelegate;
import journeymap.client.mod.vanilla.VanillaBlockColorProxy;
import journeymap.client.model.block.BlockFlag;
import journeymap.client.model.block.BlockMD;
import journeymap.client.model.chunk.ChunkMD;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.class_2338;
import org.jetbrains.annotations.Nullable;

public class SpruceLeavesBlockProxy
implements IBlockColorProxy {
    private static SpruceLeavesBlockProxy INSTANCE;

    public static SpruceLeavesBlockProxy getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SpruceLeavesBlockProxy();
        }
        return INSTANCE;
    }

    @Override
    public int deriveBlockColor(BlockMD blockMD, @Nullable ChunkMD chunkMD, @Nullable class_2338 blockPos) {
        if (blockMD.getBlockId().toLowerCase().contains("spruce_leaves")) {
            try {
                Integer color = VanillaBlockColorProxy.getSpriteColor(blockMD, null, chunkMD, blockPos);
                if (color == null) {
                    return VanillaBlockColorProxy.setBlockColorToMaterial(blockMD);
                }
                return RGB.tint(color, -10380959);
            }
            catch (Throwable e) {
                Journeymap.getLogger().error("Error deriving color for {}: {}", (Object)blockMD, (Object)LogFormatter.toPartialString(e));
                blockMD.addFlags(BlockFlag.Error);
                return VanillaBlockColorProxy.setBlockColorToMaterial(blockMD);
            }
        }
        return ModBlockDelegate.INSTANCE.getDefaultBlockColorProxy().deriveBlockColor(blockMD, chunkMD, blockPos);
    }

    @Override
    public int getBlockColor(ChunkMD chunkMD, BlockMD blockMD, class_2338 blockPos) {
        return ModBlockDelegate.INSTANCE.getDefaultBlockColorProxy().getBlockColor(chunkMD, blockMD, blockPos);
    }
}

