/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.config.v3;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.JsonOps;
import dev.isxander.yacl3.config.v3.CodecConfig;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public abstract class JsonFileCodecConfig<T extends JsonFileCodecConfig<T>>
extends CodecConfig<T> {
    private final Path configPath;
    private final Gson gson;

    public JsonFileCodecConfig(Path configPath) {
        this.configPath = configPath;
        this.gson = this.createGson();
    }

    public void saveToFile() {
        DataResult jsonTreeResult = this.encodeStart(JsonOps.INSTANCE);
        if (jsonTreeResult.error().isPresent()) {
            this.onSaveError(SaveError.ENCODING, new IllegalStateException("Failed to encode: " + ((DataResult.Error)jsonTreeResult.error().get()).message()));
            return;
        }
        JsonElement jsonTree = (JsonElement)jsonTreeResult.result().orElseThrow();
        String json = this.gson.toJson(jsonTree);
        try {
            Files.writeString(this.configPath, (CharSequence)json, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
        }
        catch (IOException e) {
            this.onSaveError(SaveError.WRITING, e);
        }
    }

    public boolean loadFromFile() {
        JsonElement jsonTree;
        String json;
        if (Files.notExists(this.configPath, new LinkOption[0])) {
            return false;
        }
        try {
            json = Files.readString(this.configPath);
        }
        catch (IOException e) {
            this.onLoadError(LoadError.READING, e);
            return false;
        }
        try {
            jsonTree = JsonParser.parseString((String)json);
        }
        catch (JsonParseException e) {
            this.onLoadError(LoadError.JSON_PARSING, e);
            return false;
        }
        return this.decode(jsonTree, JsonOps.INSTANCE);
    }

    protected Gson createGson() {
        return new GsonBuilder().setPrettyPrinting().create();
    }

    protected void onSaveError(SaveError error, @Nullable Throwable e) {
        throw new IllegalStateException("Error whilst " + error.name().toLowerCase(), e);
    }

    protected void onLoadError(LoadError error, @Nullable Throwable e) {
        throw new IllegalStateException("Error whilst " + error.name().toLowerCase(), e);
    }

    protected static enum SaveError {
        WRITING,
        ENCODING;

    }

    protected static enum LoadError {
        READING,
        JSON_PARSING,
        DECODING;

    }
}

