/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.waypointmanager.group;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import journeymap.api.common.waypoint.WaypointFactoryImpl;
import journeymap.api.services.EventBus;
import journeymap.api.v2.client.util.tuple.Tuple2;
import journeymap.api.v2.common.event.common.WaypointGroupEvent;
import journeymap.api.v2.common.waypoint.WaypointGroup;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.texture.TextureCache;
import journeymap.client.ui.component.TextBox;
import journeymap.client.ui.component.buttons.CheckBox;
import journeymap.client.ui.component.dropdown.DropDownButton;
import journeymap.client.ui.component.dropdown.DropDownItem;
import journeymap.client.ui.component.dropdown.ImageDropDownItem;
import journeymap.client.ui.component.dropdown.SelectableParent;
import journeymap.client.ui.component.popupscreenbutton.PopupButton;
import journeymap.client.ui.component.popupscreenbutton.PopupButtonScreen;
import journeymap.client.ui.component.popupscreenbutton.colorpicker.ColorPickerButton;
import journeymap.client.ui.component.popupscreenbutton.colorpicker.ColorPickerScreen;
import journeymap.client.ui.component.popupscreenbutton.imageselect.ImageSelectButton;
import journeymap.client.ui.component.popupscreenbutton.imageselect.ImageSelectionScreen;
import journeymap.client.ui.waypointmanager.group.DeleteConfirmGroupPopup;
import journeymap.common.waypoint.WaypointGroupStore;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_5244;
import net.minecraft.class_5348;
import net.minecraft.class_7842;
import net.minecraft.class_7845;
import net.minecraft.class_7847;
import net.minecraft.class_7919;
import net.minecraft.class_7940;
import net.minecraft.class_8021;
import net.minecraft.class_8667;

public class EditGroupPopup
extends PopupButtonScreen<WaypointGroupEvent>
implements SelectableParent {
    private TextBox nameTextBox;
    private TextBox tagTextBox;
    protected static Integer defaultGroupColor = new Color(20, 20, 20).getRGB();
    private final WaypointGroup group;
    private boolean closeOnDelete = false;
    private Integer color;
    private Boolean colorOverride;
    private Boolean iconOverride;
    private boolean showOnLocatorBar = false;
    private boolean isNew = false;
    private boolean enabled = true;
    private List<DropDownItem> iconDropDownItems;
    private DropDownButton iconDropDown;
    private ImageSelectButton<ImageSelectionScreen.Response> imageSelectButton;
    private class_2960 iconLocation;

    public EditGroupPopup(class_2561 title, WaypointGroup group) {
        super(title);
        this.group = group;
        this.colorOverride = group.colorOverride();
        this.iconOverride = group.iconOverride();
        this.setOnClosed(g -> {});
    }

    public EditGroupPopup(class_2561 title) {
        this(title, WaypointFactoryImpl.instance.createWaypointGroup(""));
        this.isNew = true;
    }

    protected void method_25426() {
        boolean locked;
        this.nameTextBox = new TextBox(this.group.getName(), this.field_22793, 120, 20);
        this.tagTextBox = new TextBox(this.group.getTag(), this.field_22793, 50, 20);
        this.tagTextBox.method_1880(6);
        CheckBox colorOverride = new CheckBox(Constants.getString("jm.waypoint.edit_group.color_override"), this.group.colorOverride(), this::setColorOverride);
        colorOverride.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"jm.waypoint.edit_group.color_override.tooltip")));
        CheckBox iconOverride = new CheckBox(Constants.getString("jm.waypoint.edit_group.icon_override"), this.group.iconOverride(), this::setIconOverride);
        iconOverride.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"jm.waypoint.edit_group.icon_override.tooltip")));
        CheckBox showOnLocatorBar = new CheckBox(Constants.getString("jm.waypoint.edit_group.locator_bar"), this.group.isShowOnLocatorBar(), this::showOnLocatorBar);
        showOnLocatorBar.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"jm.waypoint.edit_group.locator_bar.tooltip")));
        this.iconDropDownItems = this.buildIconDropdownItems();
        this.layout.method_52735(12).method_52740().method_46467();
        this.layout.method_52736((class_8021)new class_7940((class_2561)this.field_22785.method_27661().method_27692(class_124.field_1067), this.field_22793).method_48984(150).method_48981(true));
        boolean bl = locked = this.group.isLocked() || WaypointGroupStore.DEFAULT.getGuid().equals(this.group.getGuid());
        if (locked) {
            this.tagTextBox.method_1888(false);
            this.nameTextBox.method_1888(false);
            class_7842 lockedText = (class_7842)this.layout.method_52736((class_8021)new class_7842((class_2561)class_2561.method_43471((String)"jm.waypoint.edit_group.locked").method_27661().method_27692(class_124.field_1061), this.field_22793));
            lockedText.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"jm.waypoint.edit_group.locked.tooltip")));
        } else {
            this.method_48265((class_364)this.nameTextBox);
        }
        this.layout.method_52736((class_8021)this.enabledCheckbox());
        class_8667 colors = class_8667.method_52742();
        colors.method_52735(6);
        Integer initGroupColor = this.group.getColor() == null ? defaultGroupColor : this.group.getColor();
        colors.method_52736((class_8021)new ColorPickerButton(20, 20, () -> initGroupColor, this::setColor));
        colors.method_52738((class_8021)colorOverride, class_7847::method_46474);
        if (JourneymapClient.getInstance().getWaypointProperties().displayOnLocatorBar.get().booleanValue()) {
            colors.method_52738((class_8021)showOnLocatorBar, class_7847::method_46474);
        }
        class_8667 iconLayout = class_8667.method_52742();
        iconLayout.method_52735(6);
        this.imageSelectButton = new ImageSelectButton<ImageSelectionScreen.Response>(20, 20, 16, 16, this.iconLocation != null ? this.iconLocation : this.group.getIconResourceLocation(), initGroupColor, (class_2561)class_2561.method_43471((String)"jm.waypoint.icon.select"), () -> new ImageSelectionScreen((class_2561)class_2561.method_43471((String)"jm.waypoint.icon.select"), this.iconLocation != null ? this.iconLocation : this.group.getIconResourceLocation(), TextureCache.waypointIconMap.keySet().stream().toList(), initGroupColor), this::onIconUpdate);
        this.imageSelectButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"jm.waypoint.icon.select.tooltip")));
        this.iconDropDown = new DropDownButton("", this::onIconUpdate);
        this.iconDropDown.setItems(this.iconDropDownItems);
        this.iconDropDown.setDefaultStyle(false);
        this.iconDropDown.setDrawBackground(false);
        this.iconDropDown.setSelectedId(this.group.getIconResourceLocation().toString().replace("ui/img", "textures/waypoint/icon"));
        this.iconDropDown.setRenderSolidBackground(true);
        if (TextureCache.waypointIconMap.size() > 4) {
            iconLayout.method_52738(this.imageSelectButton, class_7847::method_46474);
        } else {
            iconLayout.method_52738((class_8021)this.iconDropDown, class_7847::method_46474);
        }
        iconLayout.method_52738((class_8021)iconOverride, class_7847::method_46474);
        class_8667 bottomButtons = class_8667.method_52742();
        class_7845 locGridLayout = new class_7845();
        locGridLayout.method_48635(6);
        locGridLayout.method_48636(4);
        bottomButtons.method_52735(6);
        PopupButton deleteButton = (PopupButton)bottomButtons.method_52736(new PopupButton<Tuple2>(this.field_22793.method_1727(Constants.getString("jm.common.delete")) + 10, 0, (class_2561)class_2561.method_43471((String)"jm.common.delete"), () -> new DeleteConfirmGroupPopup(this.group), this::deleteGroup));
        deleteButton.field_22764 = !this.group.getGuid().equals(WaypointGroupStore.DEFAULT.getGuid()) && !this.group.isLocked() && !this.isNew;
        bottomButtons.method_52736((class_8021)class_4185.method_46430((class_2561)class_2561.method_43471((String)"jm.waypoint.save"), b -> this.save()).method_46432(this.field_22793.method_27525((class_5348)class_5244.field_41873) + 10).method_46431());
        bottomButtons.method_52736((class_8021)class_4185.method_46430((class_2561)class_5244.field_24335, b -> super.method_25419()).method_46432(this.field_22793.method_27525((class_5348)class_5244.field_24335) + 10).method_46431());
        locGridLayout.method_46452((class_8021)new class_7842((class_2561)class_2561.method_43471((String)"jm.waypoint.name").method_27661().method_27692(class_124.field_1075).method_27692(class_124.field_1073), this.field_22793), 0, 0);
        class_7842 tagLabel = (class_7842)locGridLayout.method_46452((class_8021)new class_7842((class_2561)class_2561.method_43471((String)"jm.waypoint.edit_group.tag").method_27661().method_27692(class_124.field_1075).method_27692(class_124.field_1073), this.field_22793), 0, 1);
        tagLabel.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"jm.waypoint.edit_group.tag.tooltip")));
        locGridLayout.method_46452((class_8021)this.nameTextBox, 1, 0);
        locGridLayout.method_46452((class_8021)this.tagTextBox, 1, 1);
        this.layout.method_52736((class_8021)locGridLayout);
        this.layout.method_52736((class_8021)colors);
        if (!locked) {
            this.layout.method_52736((class_8021)iconLayout);
        }
        this.layout.method_52736((class_8021)bottomButtons);
        this.layout.method_48206(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
        this.method_48640();
    }

    private void onIconUpdate(class_4185 button) {
        this.iconLocation = class_2960.method_60654((String)this.iconDropDown.getSelected().getId().toString());
    }

    private void onIconUpdate(ImageSelectionScreen.Response response) {
        if (!response.cancelled()) {
            this.setColor(response.color());
            this.imageSelectButton.setLocation(response.resourceLocation());
            this.imageSelectButton.setColor(response.color());
            this.iconLocation = response.resourceLocation();
        }
    }

    private void deleteGroup(Tuple2<Boolean, Boolean> tuple) {
        EventBus.post(new WaypointGroupEvent(this.group, WaypointGroupEvent.Context.DELETED, ((Boolean)tuple.a()).booleanValue()));
        this.closeOnDelete = true;
        super.method_25419();
    }

    private void setColorOverride(class_4185 button) {
        this.colorOverride = ((CheckBox)button).getToggled();
    }

    private void setIconOverride(class_4185 button) {
        this.iconOverride = ((CheckBox)button).getToggled();
    }

    private void showOnLocatorBar(class_4185 button) {
        this.showOnLocatorBar = ((CheckBox)button).getToggled();
    }

    private void setColor(ColorPickerScreen.ColorPickerResponse colorPickerResponse) {
        if (!colorPickerResponse.canceled()) {
            this.setColor(colorPickerResponse.color());
        }
    }

    private void setColor(int color) {
        this.color = color;
        this.iconDropDownItems.forEach(item -> ((ImageDropDownItem)((Object)item)).setColor(color));
    }

    protected void renderPopupScreen(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderPopupScreen(graphics, mouseX, mouseY, partialTicks);
        if (this.minecraft.field_1755 == this && this.closeOnDelete) {
            this.method_25419();
        }
    }

    private CheckBox enabledCheckbox() {
        boolean enabled = this.group == null || this.group.isEnabled();
        return new CheckBox(Constants.getString("jm.common.enabled"), enabled, button -> this.setEnabled(((CheckBox)button).getToggled()));
    }

    private void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 257) {
            this.save();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    private void save() {
        String name = this.nameTextBox.method_1882();
        if (!name.isEmpty()) {
            this.group.setName(name);
            this.group.setEnabled(this.enabled);
            this.group.setTag(this.tagTextBox.method_1882());
            this.group.setShowOnLocatorBar(this.showOnLocatorBar);
            if (this.iconOverride != null) {
                this.group.setIconOverride(this.iconOverride.booleanValue());
                if (this.iconLocation != null && this.iconOverride.booleanValue()) {
                    this.group.setIconResourceLoctaion(this.iconLocation);
                }
            }
            if (this.colorOverride != null) {
                this.group.setColorOverride(this.colorOverride.booleanValue());
                if (this.color != null && this.colorOverride.booleanValue()) {
                    this.group.setColor(this.color);
                }
            }
            this.setResponseAndClose(EventBus.post(new WaypointGroupEvent(this.group, this.isNew ? WaypointGroupEvent.Context.CREATE : WaypointGroupEvent.Context.UPDATE)));
        }
    }

    private List<DropDownItem> buildIconDropdownItems() {
        class_2960 loc2;
        ArrayList<DropDownItem> list = new ArrayList<DropDownItem>();
        if (!TextureCache.waypointIconMap.containsKey(this.group.getIconResourceLocation()) && (loc2 = this.group.getIconResourceLocation()) != null) {
            ImageDropDownItem icon = new ImageDropDownItem((SelectableParent)this, loc2, 16, 16, b -> {}, loc2.toString());
            icon.setColor(this.group.getIconColor());
            list.add(icon);
        }
        TextureCache.waypointIconMap.forEach((loc, tex) -> {
            ImageDropDownItem icon = new ImageDropDownItem((SelectableParent)this, (class_2960)loc, 16, 16, b -> {}, loc.toString());
            icon.setColor(this.group.getColor() == null || !this.group.colorOverride() ? -1 : this.group.getColor());
            list.add(icon);
        });
        return list;
    }

    @Override
    public void setSelected(DropDownItem button) {
        if (button instanceof ImageDropDownItem) {
            ImageDropDownItem imgButton = (ImageDropDownItem)button;
            this.iconDropDown.setSelected(imgButton);
        }
    }
}

