/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.item;

import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.IPortable;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockStandardDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.UpgradeData;
import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import java.util.function.Consumer;
import net.minecraft.class_10712;
import net.minecraft.class_11352;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_4538;
import net.minecraft.class_5250;
import net.minecraft.class_7225;
import net.minecraft.class_8942;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;

public class ItemDrawers
extends class_1747
implements IPortable {
    public ItemDrawers(class_2248 block, class_1792.class_1793 properties) {
        super(block, properties);
    }

    public void method_67187(class_1799 stack, class_1792.class_9635 context, class_10712 display, Consumer<class_2561> tooltip, class_1836 flag) {
        super.method_67187(stack, context, display, tooltip, flag);
        class_5250 textCapacity = class_2561.method_43469((String)"tooltip.storagedrawers.drawers.capacity", (Object[])new Object[]{this.getCapacityForBlock(stack)});
        tooltip.accept((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)textCapacity).method_27692(class_124.field_1080));
        class_9279 blockData = (class_9279)stack.method_58694(class_9334.field_49611);
        class_9279 customData = (class_9279)stack.method_58694(class_9334.field_49628);
        if (blockData != null || customData != null) {
            class_5250 textSealed = class_2561.method_43471((String)"tooltip.storagedrawers.drawers.sealed");
            tooltip.accept((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)textSealed).method_27692(class_124.field_1054));
        }
        if (((Boolean)ModCommonConfig.INSTANCE.DRAWERS.filled.heavyDrawers.get()).booleanValue() && this.isHeavy(context.method_59527(), stack)) {
            tooltip.accept((class_2561)class_2561.method_43471((String)"tooltip.storagedrawers.drawers.too_heavy").method_27692(class_124.field_1061));
        }
    }

    public class_2561 method_7864(class_1799 stack) {
        class_5250 fallback = class_2561.method_43473();
        class_2248 block = class_2248.method_9503((class_1792)stack.method_7909());
        if (block instanceof BlockStandardDrawers) {
            BlockStandardDrawers drawers = (BlockStandardDrawers)block;
            String matKey = drawers.getMatKey();
            if (matKey != null) {
                String mat = class_2561.method_43471((String)drawers.getNameMatKey()).getString();
                fallback = class_2561.method_43469((String)drawers.getNameTypeKey(), (Object[])new Object[]{mat});
            }
        } else {
            fallback = super.method_7864(stack);
        }
        return fallback;
    }

    @NotNull
    public class_2561 getDescription() {
        return class_2561.method_43471((String)(this.method_7876() + ".desc"));
    }

    @Override
    public boolean isHeavy(class_7225.class_7874 provider, @NotNull class_1799 stack) {
        if (stack.method_7909() != this) {
            return false;
        }
        class_9279 data = (class_9279)stack.method_58695(class_9334.field_49611, (Object)class_9279.field_49302);
        if (data.method_57458()) {
            return false;
        }
        UpgradeData x = new UpgradeData(7);
        try {
            x.read(class_11352.method_71417((class_8942)class_8942.field_60348, (class_7225.class_7874)provider, (class_2487)data.method_57461()));
        }
        catch (ClassCastException e) {
            return false;
        }
        return !x.hasPortabilityUpgrade();
    }

    private int getCapacityForBlock(@NotNull class_1799 itemStack) {
        class_2248 block = class_2248.method_9503((class_1792)itemStack.method_7909());
        if (block instanceof BlockDrawers) {
            BlockDrawers blockDrawers = (BlockDrawers)block;
            return blockDrawers.getStorageUnits() * ModCommonConfig.INSTANCE.DRAWERS.getBaseStackStorage();
        }
        return 0;
    }

    public boolean method_31568() {
        return (Boolean)ModCommonConfig.INSTANCE.DRAWERS.filled.canStoreInContainers.get();
    }

    public boolean doesSneakBypassUse(class_1799 stack, class_4538 level, class_2338 pos, class_1657 player) {
        BlockDrawers bd;
        class_2680 state = level.method_8320(pos);
        class_2248 block = state.method_26204();
        return block instanceof BlockDrawers && (bd = (BlockDrawers)block).retrimType() != null;
    }
}

