/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.config;

import com.jaquadro.minecraft.storagedrawers.api.config.IDrawerConfig;
import com.texelsaurus.minecraft.chameleon.ChameleonServices;
import com.texelsaurus.minecraft.chameleon.config.ConfigSpec;
import com.texelsaurus.minecraft.chameleon.service.ChameleonConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class ModCommonConfig
extends ConfigSpec {
    public static ModCommonConfig INSTANCE = new ModCommonConfig();
    private final ChameleonConfig commonConfig = ChameleonServices.CONFIG.create(this);
    public General GENERAL;
    public Drawers DRAWERS;
    public Controller CONTROLLER;
    public Upgrades UPGRADES;
    public Tools TOOLS;
    public Integration INTEGRATION;

    private ModCommonConfig() {
    }

    public ChameleonConfig context() {
        return this.commonConfig;
    }

    @Override
    public void init() {
        this.GENERAL = new General(this);
        this.DRAWERS = new Drawers();
        this.CONTROLLER = new Controller(this);
        this.UPGRADES = new Upgrades();
        this.TOOLS = new Tools();
        this.INTEGRATION = new Integration();
    }

    public class General {
        public ChameleonConfig.ConfigEntry<Boolean> debugTrace;
        public ChameleonConfig.ConfigEntry<Boolean> enableUI;
        public ChameleonConfig.ConfigEntry<Boolean> logStartupActivity;
        public ChameleonConfig.ConfigEntry<Integer> configVersion;

        public General(ModCommonConfig this$0) {
            this$0.commonConfig.comment("General mod configuration");
            this$0.commonConfig.pushGroup("General");
            this.debugTrace = this$0.commonConfig.define("debugTrace", false).comment("Enables excessive logging around certain parts of the mod.", "Can be ignored unless asked by the developer to enable.").build();
            this.enableUI = this$0.commonConfig.define("enableUI", true).comment("", "Whether blocks with UI components are allowed to open them.", "Disabling UI will restrict some mod functionality.").build();
            this.logStartupActivity = this$0.commonConfig.define("logStartupActivity", true).comment("", "Whether to log actions such as adding rules or deny list entries.", "You may wish to disable this if you've added many such entries.").build();
            this.configVersion = this$0.commonConfig.define("configVersion", 2).comment("", "Internal use to record what version the config file was first written with.").build();
            this$0.commonConfig.popGroup();
        }
    }

    public class Drawers {
        public DrawerConfig fullDrawers1x1;
        public DrawerConfig fullDrawers1x2;
        public DrawerConfig fullDrawers2x2;
        public DrawerConfig halfDrawers1x1;
        public DrawerConfig halfDrawers1x2;
        public DrawerConfig halfDrawers2x2;
        public DrawerConfig fullCompacting;
        public DrawerConfig halfCompacting;
        public ChameleonConfig.ConfigEntry<Integer> baseStackStorage;
        public Compacting compacting;
        public Filled filled;
        public Detached detached;
        public Framed framed;
        public Storage storage;

        public Drawers() {
            ModCommonConfig.this.commonConfig.comment("Configuration around drawer storage blocks");
            ModCommonConfig.this.commonConfig.pushGroup("Drawers");
            this.baseStackStorage = ModCommonConfig.this.commonConfig.define("baseStackStorage", 1).comment("A base value multiplied against the storage size of all drawer slots.", "Change this to uniformly increase all storage amounts").build();
            ModCommonConfig.this.commonConfig.comment("Configuration for individual drawer configurations.", "Units are the number of stacks a slot holds before the base stack storage value is multiplied.");
            ModCommonConfig.this.commonConfig.pushGroup("Blocks");
            this.fullDrawers1x1 = new DrawerConfig("FullStorage1x1", 32, new String[0]).build();
            this.fullDrawers1x2 = new DrawerConfig("FullStorage1x2", 16, new String[0]).build();
            this.fullDrawers2x2 = new DrawerConfig("FullStorage2x2", 8, new String[0]).build();
            this.fullCompacting = new DrawerConfig("FullCompacting", 32, new String[0]).build();
            this.halfDrawers1x1 = new DrawerConfig("HalfStorage1x1", 16, new String[0]).build();
            this.halfDrawers1x2 = new DrawerConfig("HalfStorage1x2", 8, new String[0]).build();
            this.halfDrawers2x2 = new DrawerConfig("HalfStorage2x2", 4, new String[0]).build();
            this.halfCompacting = new DrawerConfig("HalfCompacting", 16, new String[0]).build();
            ModCommonConfig.this.commonConfig.popGroup();
            this.compacting = new Compacting(this, "Compacting", "Configuration around the auto compacting feature").build();
            this.detached = new Detached(this, "Detached", "Configuration around detached drawers, which are individual drawer slots pulled from a drawer block.").build();
            this.filled = new Filled(this, "Filled", "Configuration around dropped drawer blocks that still have items inside them.").build();
            this.framed = new Framed(this, "Framed", "Configuration around framed drawers, which take their appearance from other blocks used as materials.").build();
            this.storage = new Storage(this, "Storage", "Configuration around storage of items.").build();
            ModCommonConfig.this.commonConfig.popGroup();
        }

        public boolean anyHeavyDrawers() {
            return (Boolean)this.filled.heavyDrawers.get() != false || (Boolean)this.detached.heavyDrawers.get() != false;
        }

        public int getBaseStackStorage() {
            return ModCommonConfig.this.isLoaded() ? (Integer)this.baseStackStorage.get() : 1;
        }

        public class DrawerConfig
        extends ConfigSection
        implements IDrawerConfig {
            public ChameleonConfig.ConfigEntry<Integer> unitsPerSlot;

            public DrawerConfig(String name, int unitsPerSlot, String ... comment) {
                super(name, comment);
                this.unitsPerSlot = ModCommonConfig.this.commonConfig.define("unitsPerSlot", unitsPerSlot);
            }

            @Override
            protected void buildEntries() {
                this.unitsPerSlot.build();
            }

            @Override
            public DrawerConfig build() {
                super.build();
                return this;
            }

            @Override
            public int getUnitsPerSlot() {
                if (!ModCommonConfig.this.isLoaded()) {
                    return 1;
                }
                return (Integer)this.unitsPerSlot.get();
            }
        }

        public class Compacting
        extends ConfigSection {
            public ChameleonConfig.ConfigEntry<Boolean> enabled;
            public ChameleonConfig.ConfigEntry<Boolean> enableExtraCompactingRules;
            public ChameleonConfig.ConfigEntry<List<? extends String>> compRules;

            public Compacting(Drawers this$1, String name, String ... comment) {
                super(name, comment);
                this.enabled = this$1.ModCommonConfig.this.commonConfig.define("enabled", true).comment("Whether compacting function is supported.  Disabling does not remove the block.");
                this.enableExtraCompactingRules = this$1.ModCommonConfig.this.commonConfig.define("enableExtraCompactingRules", true).comment("", "Enables additional rules for some Minecraft items, like quartz, brick, and clay.", "See logs for full set of rules that get added.");
                this.compRules = this$1.ModCommonConfig.this.commonConfig.defineList("compactingRules", Arrays.asList("minecraft:clay, minecraft:clay_ball, 4"), null).comment("", "Compacting drawers require 2-way 2x2 or 3x3 recipes to associate items.", "Add additional rules here in the form: <big_item>, <small_item>, <amount>");
            }

            @Override
            protected void buildEntries() {
                this.enabled.build();
                this.enableExtraCompactingRules.build();
                this.compRules.build();
            }

            @Override
            public Compacting build() {
                super.build();
                return this;
            }
        }

        public class Detached
        extends ConfigSection {
            public ChameleonConfig.ConfigEntry<Boolean> enable;
            public ChameleonConfig.ConfigEntry<Boolean> heavyDrawers;
            public ChameleonConfig.ConfigEntry<Boolean> forceMaxCapacityCheck;
            public ChameleonConfig.ConfigEntry<Boolean> canStoreInContainers;

            public Detached(Drawers this$1, String name, String ... comment) {
                super(name, comment);
                this.enable = this$1.ModCommonConfig.this.commonConfig.define("enable", true).comment("Allows individual drawer slots to be pulled out from a drawer block.");
                this.heavyDrawers = this$1.ModCommonConfig.this.commonConfig.define("heavyDrawers", false).comment("", "If enabled, carrying filled drawers in your inventory gives slowness debuff.", "Debuff can be mitigated with portability upgrade, if it's enabled.");
                this.forceMaxCapacityCheck = this$1.ModCommonConfig.this.commonConfig.define("forceMaxCapacityCheck", false).comment("", "Drawers track the capacity upgrades from the block they were taken from.", "When enabled, drawers can only be placed back into a block with the same or lower max capacity.", "Drawers can still only be inserted into a block with enough capacity for the items held.");
                this.canStoreInContainers = this$1.ModCommonConfig.this.commonConfig.define("canStoreInContainers", false).comment("", "Allows detached drawers to be stored in containers like bundles and shulker boxes.", "Due to current limitation, this rule will also apply to storing empty drawers in those containers.");
            }

            @Override
            protected void buildEntries() {
                this.enable.build();
                this.heavyDrawers.build();
                this.forceMaxCapacityCheck.build();
                this.canStoreInContainers.build();
            }

            @Override
            public Detached build() {
                super.build();
                return this;
            }
        }

        public class Filled
        extends ConfigSection {
            public ChameleonConfig.ConfigEntry<Boolean> heavyDrawers;
            public ChameleonConfig.ConfigEntry<Boolean> canStoreInDrawers;
            public ChameleonConfig.ConfigEntry<Boolean> canStoreInContainers;

            public Filled(Drawers this$1, String name, String ... comment) {
                super(name, comment);
                this.heavyDrawers = this$1.ModCommonConfig.this.commonConfig.define("heavyDrawers", false).comment("If enabled, carrying filled drawers in your inventory gives slowness debuff.", "Debuff can be mitigated with portability upgrade, if it's enabled.");
                this.canStoreInDrawers = this$1.ModCommonConfig.this.commonConfig.define("canStoreInDrawers", false).comment("", "Allows filled drawers to be stored in other drawer blocks.");
                this.canStoreInContainers = this$1.ModCommonConfig.this.commonConfig.define("canStoreInContainers", false).comment("", "Allows filled drawers to be stored in containers like bundles and shulker boxes.", "Due to current limitation, this rule will also apply to storing empty drawers in those containers.");
            }

            @Override
            protected void buildEntries() {
                this.heavyDrawers.build();
                this.canStoreInDrawers.build();
                this.canStoreInContainers.build();
            }

            @Override
            public Filled build() {
                super.build();
                return this;
            }
        }

        public class Framed
        extends ConfigSection {
            public ChameleonConfig.ConfigEntry<Boolean> enable;
            public ChameleonConfig.ConfigEntry<Boolean> enforceSolidMaterials;
            public ChameleonConfig.ConfigEntry<Boolean> enforceOpaqueMaterials;
            public ChameleonConfig.ConfigEntry<List<? extends String>> materialBlacklist;

            public Framed(Drawers this$1, String name, String ... comment) {
                super(name, comment);
                this.enable = this$1.ModCommonConfig.this.commonConfig.define("enable", true).comment("Allows crafting framed drawers.  Disabling does not remove existing framed drawers.");
                this.enforceSolidMaterials = this$1.ModCommonConfig.this.commonConfig.define("enforceSolidMaterials", true).comment("", "Attempts to only allow solid, full-cube blocks to be used as materials.", "This check may still allow non-solid blocks if the blocks' properties indicate they should be solid but are not.", "Some non-solid blocks are also counted as non-opaque, and may be restricted by that setting as well.");
                this.enforceOpaqueMaterials = this$1.ModCommonConfig.this.commonConfig.define("enforceOpaqueMaterials", false).comment("", "Attempts to only allow fully opaque blocks to be used as materials.", "This check may still allow non-opaque blocks if the blocks' properties indicate they should be opaque but are not.");
                this.materialBlacklist = this$1.ModCommonConfig.this.commonConfig.defineList("materialDenyList", new ArrayList(), null).comment("", "Each entry should be a namespace or fully namespaced block, e.g. minecraft:cobblestone", "Any items on the deny list are prevented from being used as any drawer material.");
            }

            @Override
            protected void buildEntries() {
                this.enable.build();
                this.enforceSolidMaterials.build();
                this.enforceOpaqueMaterials.build();
                this.materialBlacklist.build();
            }

            @Override
            public Framed build() {
                super.build();
                return this;
            }
        }

        public class Storage
        extends ConfigSection {
            public ChameleonConfig.ConfigEntry<List<? extends String>> storeBlacklist;

            public Storage(Drawers this$1, String name, String ... comment) {
                super(name, comment);
                this.storeBlacklist = this$1.ModCommonConfig.this.commonConfig.defineList("storeDenyList", Arrays.asList("storagedrawers:creative_vending_upgrade"), null).comment("", "Each entry should be a namespace or fully namespaced item, e.g. minecraft:cobblestone", "Any items on the deny list are prevented from being stored in drawers");
            }

            @Override
            protected void buildEntries() {
                this.storeBlacklist.build();
            }

            @Override
            public Storage build() {
                super.build();
                return this;
            }
        }
    }

    public class Controller {
        public ChameleonConfig.ConfigEntry<Integer> controllerRange;

        public Controller(ModCommonConfig this$0) {
            this$0.commonConfig.comment("Configuration around the controller and drawer networks.");
            this$0.commonConfig.pushGroup("Controller");
            this.controllerRange = this$0.commonConfig.define("controllerRange", 50).comment("Controller range defines how far away a drawer can be connected on X, Y, or Z planes.", "The largest recommended range is around 75, or the expected chunk load distance.", "If setting this value higher, drawers will be unavailable if their chunks become unloaded.").build();
            this$0.commonConfig.popGroup();
        }
    }

    public class Upgrades {
        public final StorageTierUpgrade obsidianStorage;
        public final StorageTierUpgrade copperStorage;
        public final StorageTierUpgrade ironStorage;
        public final StorageTierUpgrade goldStorage;
        public final StorageTierUpgrade emeraldStorage;
        public final StorageTierUpgrade diamondStorage;
        public final StorageTierUpgrade netheriteStorage;
        public final ConversionUpgrade conversionUpgrade;
        public final Upgrade creativeStorageUpgrade;
        public final Upgrade creativeVendingUpgrade;
        public final Upgrade balanceUpgrade;
        public final Upgrade fillLevelUpgrade;
        public final IlluminationUpgrade illuminationUpgrade;
        public final Upgrade hopperUpgrade;
        public final MagnetUpgrade magnetUpgrade;
        public final Upgrade oneStackUpgrade;
        public final Upgrade portabilityUpgrade;
        public final RedstoneUpgrade redstoneUpgrade;
        public final RemoteUpgrade remoteUpgrade;
        public final Upgrade voidUgrade;

        public Upgrades() {
            ModCommonConfig.this.commonConfig.comment("Configuration around upgrade items that can be inserted into drawer blocks.");
            ModCommonConfig.this.commonConfig.pushGroup("Upgrades");
            ModCommonConfig.this.commonConfig.comment("Storage upgrades multiply storage capacity by the given amount.", "When multiple storage upgrades are used together, their multipliers are added before being applied.");
            ModCommonConfig.this.commonConfig.pushGroup("StorageTiers");
            this.obsidianStorage = new StorageTierUpgrade(this, "Obsidian", 2, new String[0]).build();
            this.copperStorage = new StorageTierUpgrade(this, "Copper", 4, new String[0]).build();
            this.ironStorage = new StorageTierUpgrade(this, "Iron", 8, new String[0]).build();
            this.goldStorage = new StorageTierUpgrade(this, "Gold", 16, new String[0]).build();
            this.emeraldStorage = new StorageTierUpgrade(this, "Emerald", 64, new String[0]).build();
            this.diamondStorage = new StorageTierUpgrade(this, "Diamond", 256, new String[0]).build();
            this.netheriteStorage = new StorageTierUpgrade(this, "Netherite", 2048, new String[0]).build();
            ModCommonConfig.this.commonConfig.popGroup();
            this.balanceUpgrade = new Upgrade(this, "Balance", "Allows same-item slots to balance out their amounts when items are added or removed from a slot.", "Works across networks when acting through a controller.").build();
            this.conversionUpgrade = new ConversionUpgrade(this, "Conversion", "Allows the automatic conversion of same-type items based on configuration.").build();
            this.creativeStorageUpgrade = new Upgrade(this, "CreativeStorage", "Allows storing ~2.1 billion (MAX_INT) items in each drawer slot.").build();
            this.creativeVendingUpgrade = new Upgrade(this, "CreativeVending", "Allows vending infinite amounts of the items in each drawer slot.").build();
            this.fillLevelUpgrade = new Upgrade(this, "FillLevel", "Adds fill bars to the face of drawers.").build();
            this.illuminationUpgrade = new IlluminationUpgrade(this, "Illumination", "Renders drawer labels brighter than surrounding environment would allow.").build();
            this.hopperUpgrade = new Upgrade(this, "Hopper", "Collects matching items through its top like a vanilla hopper.").build();
            this.magnetUpgrade = new MagnetUpgrade(this, "Magnet", "Collects nearby matching items by teleporting them instantly to the drawer").build();
            this.oneStackUpgrade = new Upgrade(this, "OneStack", "Restricts capacity of drawer to one stack.").build();
            this.portabilityUpgrade = new Upgrade(this, "Portability", "Allows drawers with contents to be freely carried when heavy drawers is enabled.").build();
            this.redstoneUpgrade = new RedstoneUpgrade(this, "Redstone", "Lets drawers emit redstone signals based on their fill level.").build();
            this.remoteUpgrade = new RemoteUpgrade(this, "Remote", "Lets drawers connect to a controller wirelessly.").build();
            this.voidUgrade = new Upgrade(this, "Void", "Causes drawers to accept but void compatible items when they are filled to capacity.").build();
            ModCommonConfig.this.commonConfig.popGroup();
        }

        public StorageTierUpgrade getStorageUpgrade(int level) {
            return switch (level) {
                case 1 -> this.obsidianStorage;
                case 2 -> this.copperStorage;
                case 3 -> this.ironStorage;
                case 4 -> this.goldStorage;
                case 5 -> this.emeraldStorage;
                case 6 -> this.diamondStorage;
                case 7 -> this.netheriteStorage;
                default -> this.obsidianStorage;
            };
        }

        public int getLevelMult(int level) {
            if (!ModCommonConfig.this.isLoaded()) {
                return 1;
            }
            return switch (level) {
                case 1 -> (Integer)this.obsidianStorage.storageMult.get();
                case 2 -> (Integer)this.copperStorage.storageMult.get();
                case 3 -> (Integer)this.ironStorage.storageMult.get();
                case 4 -> (Integer)this.goldStorage.storageMult.get();
                case 5 -> (Integer)this.emeraldStorage.storageMult.get();
                case 6 -> (Integer)this.diamondStorage.storageMult.get();
                case 7 -> (Integer)this.netheriteStorage.storageMult.get();
                default -> 1;
            };
        }

        public class StorageTierUpgrade
        extends Upgrade {
            public final ChameleonConfig.ConfigEntry<Integer> storageMult;

            public StorageTierUpgrade(Upgrades this$1, String upgradeName, int defaultMult, String ... comment) {
                super(this$1, upgradeName, comment);
                this.storageMult = this$1.ModCommonConfig.this.commonConfig.define("storageMultiplier", defaultMult);
            }

            @Override
            protected void buildEntries() {
                super.buildEntries();
                this.storageMult.build();
            }

            @Override
            public StorageTierUpgrade build() {
                super.build();
                return this;
            }
        }

        public class Upgrade
        extends ConfigSection {
            public final ChameleonConfig.ConfigEntry<Boolean> enableUpgrade;

            public Upgrade(Upgrades this$1, String name, String ... comment) {
                super(name, comment);
                this.enableUpgrade = this$1.ModCommonConfig.this.commonConfig.define("enableUpgrade", true);
            }

            @Override
            protected void buildEntries() {
                this.enableUpgrade.build();
            }

            @Override
            public Upgrade build() {
                super.build();
                return this;
            }
        }

        public class ConversionUpgrade
        extends Upgrade {
            public final ChameleonConfig.ConfigEntry<List<? extends String>> oreTypes;
            public final ChameleonConfig.ConfigEntry<List<? extends String>> oreMaterials;
            public final ChameleonConfig.ConfigEntry<List<? extends String>> tagWhitelist;
            public final ChameleonConfig.ConfigEntry<List<? extends String>> tagBlacklist;
            public final ChameleonConfig.ConfigEntry<List<? extends String>> itemEquivGroups;

            public ConversionUpgrade(Upgrades this$1, String upgradeName, String ... comment) {
                super(this$1, upgradeName, comment);
                this.oreTypes = this$1.ModCommonConfig.this.commonConfig.defineList("oreTypeAllowList", Arrays.asList("c:storage_blocks", "c:ingots", "c:nuggets"), null).comment("", "Each type will be combined with each material to create a set of allow list entries.", "This is mainly a convenience for common ore-based materials.");
                this.oreMaterials = this$1.ModCommonConfig.this.commonConfig.defineList("oreMaterialAllowList", Arrays.asList("aluminum", "constantan", "steel", "uranium", "invar", "tin", "lead", "silver", "platinum", "nickel", "osmium", "bronze", "electrum"), null).comment("", "Each type will be combined with each material to create a set of allow list entries.", "This is mainly a convenience for common ore-based materials.");
                this.tagWhitelist = this$1.ModCommonConfig.this.commonConfig.defineList("tagAllowList", new ArrayList(), null).comment("", "Each allow list entry should be a fully namespaced tag, e.g. c:ingots/copper");
                this.tagBlacklist = this$1.ModCommonConfig.this.commonConfig.defineList("tagDenyList", new ArrayList(), null).comment("", "Each deny list entry should be a fully namespaced tag, e.g. c:ingots/copper.", "All items not on the allow list are denied implicitly.  This can be used to exclude", "specific entries created from the ore allow list set.");
                this.itemEquivGroups = this$1.ModCommonConfig.this.commonConfig.defineList("itemEquivalenceGroups", new ArrayList(), null).comment("", "Each entry is a semicolon-separated list of fully-namespaced items. All items within the", "same entry are considered equivalent and convertible/interchangeable.", "Example: [\"thermal:nickel_ore;immersiveengineering:ore_nickel\"]");
            }

            @Override
            protected void buildEntries() {
                super.buildEntries();
                this.oreTypes.build();
                this.oreMaterials.build();
                this.tagWhitelist.build();
                this.tagBlacklist.build();
                this.itemEquivGroups.build();
            }

            @Override
            public ConversionUpgrade build() {
                super.build();
                return this;
            }
        }

        public class IlluminationUpgrade
        extends Upgrade {
            public final ChameleonConfig.ConfigEntry<Integer> illuminationLevel;
            public final ChameleonConfig.ConfigEntry<Integer> minIlluminationLevel;

            public IlluminationUpgrade(Upgrades this$1, String upgradeName, String ... comment) {
                super(this$1, upgradeName, comment);
                this.illuminationLevel = this$1.ModCommonConfig.this.commonConfig.defineInRange("illuminationLevel", 13, 0, 15).comment("", "Renders labels at minimum light level between 0 - 15");
                this.minIlluminationLevel = this$1.ModCommonConfig.this.commonConfig.defineInRange("minIlluminationLevel", 1, 0, 15).comment("", "Renders labels without upgrade at minimum light level between 0 - 15");
            }

            @Override
            protected void buildEntries() {
                super.buildEntries();
                this.illuminationLevel.build();
                this.minIlluminationLevel.build();
            }

            @Override
            public IlluminationUpgrade build() {
                super.build();
                return this;
            }
        }

        public class MagnetUpgrade
        extends ConfigSection {
            public final ChameleonConfig.ConfigEntry<Boolean> additiveRange;
            public final ChameleonConfig.ConfigEntry<List<? extends Integer>> maxRange;
            public final MagnetTierUpgrade tier1;
            public final MagnetTierUpgrade tier2;
            public final MagnetTierUpgrade tier3;

            public MagnetUpgrade(Upgrades this$1, String upgradeName, String ... comment) {
                super(upgradeName, comment);
                this.additiveRange = this$1.ModCommonConfig.this.commonConfig.define("additiveRange", true).comment("", "When multiple magnet upgrades are used, their ranges are added together.");
                this.maxRange = this$1.ModCommonConfig.this.commonConfig.defineList("maxRange", Arrays.asList(24, 8, 0), null).comment("", "Range is blocks out from drawer as: [horizontal, up, down]", "If ranges from multiple upgrades are added, they are not allowed to exceed these values.");
                this.tier1 = new MagnetTierUpgrade(this$1, "Level1", Arrays.asList(1, 1, 0), 20, new String[0]);
                this.tier2 = new MagnetTierUpgrade(this$1, "Level2", Arrays.asList(4, 2, 0), 10, new String[0]);
                this.tier3 = new MagnetTierUpgrade(this$1, "Level3", Arrays.asList(8, 3, 0), 5, new String[0]);
            }

            @Override
            protected void buildEntries() {
                super.buildEntries();
                this.additiveRange.build();
                this.maxRange.build();
                this.tier1.build();
                this.tier2.build();
                this.tier3.build();
            }

            @Override
            public MagnetUpgrade build() {
                super.build();
                return this;
            }
        }

        public class RedstoneUpgrade
        extends Upgrade {
            public final ChameleonConfig.ConfigEntry<Boolean> enableMin;
            public final ChameleonConfig.ConfigEntry<Boolean> enableMax;
            public final ChameleonConfig.ConfigEntry<Boolean> analogOutput;

            public RedstoneUpgrade(Upgrades this$1, String upgradeName, String ... comment) {
                super(this$1, upgradeName, comment);
                this.enableMin = this$1.ModCommonConfig.this.commonConfig.define("enableMinUpgrade", true).comment("", "Min redstone upgrades output the minimum signal of all drawers in block.");
                this.enableMax = this$1.ModCommonConfig.this.commonConfig.define("enableMaxUpgrade", true).comment("", "Max redstone upgrades output the maximum signal of all drawers in block.");
                this.analogOutput = this$1.ModCommonConfig.this.commonConfig.define("analogOutput", true).comment("", "Whether redstone upgrades should emit an analog redstone signal,", "requiring the use of a comparator to read it.");
            }

            @Override
            protected void buildEntries() {
                super.buildEntries();
                this.enableMin.build();
                this.enableMax.build();
                this.analogOutput.build();
            }

            @Override
            public RedstoneUpgrade build() {
                super.build();
                return this;
            }
        }

        public class RemoteUpgrade
        extends Upgrade {
            public final ChameleonConfig.ConfigEntry<Boolean> enableGroup;
            public final ChameleonConfig.ConfigEntry<Integer> maxRange;
            public final ChameleonConfig.ConfigEntry<Integer> maxGroupRange;

            public RemoteUpgrade(Upgrades this$1, String upgradeName, String ... comment) {
                super(this$1, upgradeName, comment);
                this.enableGroup = this$1.ModCommonConfig.this.commonConfig.define("enableGroupUpgrade", true).comment("", "Group variant connects all drawers connected to the upgraded block.");
                this.maxRange = this$1.ModCommonConfig.this.commonConfig.define("maxRange", 0).comment("", "Sets the max range of the single-variant remote upgrade.", "The range is capped by the controller range.  Set to 0 to match controller range.");
                this.maxGroupRange = this$1.ModCommonConfig.this.commonConfig.define("maxGroupRange", 0).comment("", "Sets the max range of the group-variant remote upgrade.", "The range is capped by the controller range.  Set to 0 to match controller range.");
            }

            @Override
            protected void buildEntries() {
                super.buildEntries();
                this.enableGroup.build();
                this.maxRange.build();
                this.maxGroupRange.build();
            }

            @Override
            public RemoteUpgrade build() {
                super.build();
                return this;
            }
        }

        public class MagnetTierUpgrade
        extends Upgrade {
            public final ChameleonConfig.ConfigEntry<List<? extends Integer>> range;
            public final ChameleonConfig.ConfigEntry<Integer> activeSpeed;
            public final ChameleonConfig.ConfigEntry<Integer> idleSpeed;

            public MagnetTierUpgrade(Upgrades this$1, String upgradeName, List<Integer> defaultRange, int defaultSpeed, String ... comment) {
                super(this$1, upgradeName, comment);
                this.range = this$1.ModCommonConfig.this.commonConfig.defineList("range", defaultRange, null).comment("", "Range is blocks out from drawer as: [horizontal, up, down]");
                this.activeSpeed = this$1.ModCommonConfig.this.commonConfig.define("activeSpeed", defaultSpeed).comment("", "Ticks between active collection when this is the highest upgrade tier.");
                this.idleSpeed = this$1.ModCommonConfig.this.commonConfig.define("idleSpeed", 20).comment("", "Ticks between collection checks when this is the highest upgrade tier.", "Collection is idle when items have not been collected within the last idleSpeed interval.");
            }

            @Override
            protected void buildEntries() {
                super.buildEntries();
                this.range.build();
                this.activeSpeed.build();
                this.idleSpeed.build();
            }

            @Override
            public MagnetTierUpgrade build() {
                super.build();
                return this;
            }
        }
    }

    public class Tools {
        public Key drawerKey;
        public QuantifyKey quantifyKey;
        public Key concealmentKey;
        public Key personalKey;
        public Key priorityKey;
        public Key suspendKey;

        public Tools() {
            ModCommonConfig.this.commonConfig.comment("Configuration around tools, namely the various 'keys' that can be used on drawers.");
            ModCommonConfig.this.commonConfig.pushGroup("Tools");
            this.drawerKey = new Key(this, "DrawerKey", "Drawer keys are used to lock drawers to the items they already hold.").build();
            this.quantifyKey = new QuantifyKey(this, "QuantifyKey", "Quantify keys are used to show or hide the count of items on the face of drawers.").build();
            this.concealmentKey = new Key(this, "ConcealmentKey", "Concealment keys are used to show or hide the item labels on the face of drawers.", "The primary use of this key is for performance by disabling the more expensive dynamic rendering.").build();
            this.personalKey = new Key(this, "PersonalKey", "Personal keys allow drawers to be locked to their owners, so only they can place or take items.").build();
            this.priorityKey = new Key(this, "PriorityKey", "Priority keys change the priority of drawers when finding a compatible slot to insert items into.").build();
            this.suspendKey = new Key(this, "PauseKey", "Suspend keys stop external interaction, e.g. from hopper or magnet upgrades.").build();
            ModCommonConfig.this.commonConfig.popGroup();
        }

        public class Key
        extends ConfigSection {
            public final ChameleonConfig.ConfigEntry<Boolean> enable;

            public Key(Tools this$1, String name, String ... comment) {
                super(name, comment);
                this.enable = this$1.ModCommonConfig.this.commonConfig.define("enable", true);
            }

            @Override
            protected void buildEntries() {
                this.enable.build();
            }

            @Override
            public Key build() {
                super.build();
                return this;
            }
        }

        public class QuantifyKey
        extends Key {
            public final ChameleonConfig.ConfigEntry<Boolean> showDefault;

            public QuantifyKey(Tools this$1, String name, String ... comment) {
                super(this$1, name, comment);
                this.showDefault = this$1.ModCommonConfig.this.commonConfig.define("showDefault", false).comment("", "Show labels by default on newly placed drawers.");
            }

            @Override
            protected void buildEntries() {
                super.buildEntries();
                this.showDefault.build();
            }

            @Override
            public QuantifyKey build() {
                super.build();
                return this;
            }
        }
    }

    public class Integration {
        public Waila waila;
        public FTBChunks ftbChunks;
        public FTBTeams ftbTeams;

        public Integration() {
            ModCommonConfig.this.commonConfig.comment("Configuration around integration with third party mods.");
            ModCommonConfig.this.commonConfig.pushGroup("Integration");
            this.ftbChunks = new FTBChunks(this, "FTBChunks", "Configuration around the FTB Chunks mod.", "Improves support for claimed chunks.").build();
            this.ftbTeams = new FTBTeams(this, "FTBTeams", "Configuration around the FTB Teams mod.", "Adds support for a teams personal key.").build();
            this.waila = new Waila(this, "WAILA", "Configuration around the WAILA/HWYLA/Jade family of block inspection mods.").build();
            ModCommonConfig.this.commonConfig.popGroup();
        }

        public class FTBChunks
        extends ConfigSection {
            public final ChameleonConfig.ConfigEntry<Boolean> enable;

            public FTBChunks(Integration this$1, String name, String ... comment) {
                super(name, comment);
                this.enable = this$1.ModCommonConfig.this.commonConfig.define("enable", true).comment("Enables FTB Chunks integration if mod is present.");
            }

            @Override
            protected void buildEntries() {
                super.buildEntries();
                this.enable.build();
            }

            @Override
            public FTBChunks build() {
                super.build();
                return this;
            }
        }

        public class FTBTeams
        extends ConfigSection {
            public final ChameleonConfig.ConfigEntry<Boolean> enable;
            public final ChameleonConfig.ConfigEntry<Boolean> enableCycleRecipe;

            public FTBTeams(Integration this$1, String name, String ... comment) {
                super(name, comment);
                this.enable = this$1.ModCommonConfig.this.commonConfig.define("enable", true).comment("Enables FTB Teams integration if mod is present.");
                this.enableCycleRecipe = this$1.ModCommonConfig.this.commonConfig.define("enableCycleRecipe", true).comment("", "Enables recipe to obtain key from another supported personal key in crafting grid.");
            }

            @Override
            protected void buildEntries() {
                super.buildEntries();
                this.enable.build();
                this.enableCycleRecipe.build();
            }

            @Override
            public FTBTeams build() {
                super.build();
                return this;
            }
        }

        public class Waila
        extends ConfigSection {
            public final ChameleonConfig.ConfigEntry<Boolean> enable;
            public final ChameleonConfig.ConfigEntry<Boolean> stackRemainder;
            public final ChameleonConfig.ConfigEntry<Boolean> respectQuantifyKey;

            public Waila(Integration this$1, String name, String ... comment) {
                super(name, comment);
                this.enable = this$1.ModCommonConfig.this.commonConfig.define("enable", true).comment("Enables Jade integration if mod is present.");
                this.stackRemainder = this$1.ModCommonConfig.this.commonConfig.define("stackRemainder", true).comment("When true, shows quantity as NxS + R (by stack size) rather than count");
                this.respectQuantifyKey = this$1.ModCommonConfig.this.commonConfig.define("respectQuantifyKey", false).comment("", "When true, does not show current quantities unless quantify key was used");
            }

            @Override
            protected void buildEntries() {
                super.buildEntries();
                this.enable.build();
                this.stackRemainder.build();
                this.respectQuantifyKey.build();
            }

            @Override
            public Waila build() {
                super.build();
                return this;
            }
        }
    }

    public static enum Mode {
        NONE,
        LIST,
        ALL;


        public static Mode fromValueIgnoreCase(String value) {
            if (value.compareToIgnoreCase("NONE") == 0) {
                return NONE;
            }
            if (value.compareToIgnoreCase("LIST") == 0) {
                return LIST;
            }
            if (value.compareToIgnoreCase("ALL") == 0) {
                return ALL;
            }
            return LIST;
        }
    }

    class ConfigSection {
        protected final String name;
        protected final String[] comment;

        public ConfigSection(String name, String ... comment) {
            this.name = name;
            this.comment = comment;
        }

        public ConfigSection build() {
            if (this.comment != null && this.comment.length > 0) {
                ModCommonConfig.this.commonConfig.comment(this.comment);
            }
            ModCommonConfig.this.commonConfig.pushGroup(this.name);
            this.buildEntries();
            ModCommonConfig.this.commonConfig.popGroup();
            return this;
        }

        protected void buildEntries() {
        }
    }
}

