/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.gui;

import com.jaquadro.minecraft.storagedrawers.components.item.KeyringContents;
import java.util.List;
import net.minecraft.class_10799;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5481;
import net.minecraft.class_5684;
import net.minecraft.class_8001;
import net.minecraft.class_9334;

public class ClientKeyringTooltip
implements class_5684 {
    private static final class_2960 SLOT_HIGHLIGHT_BACK_SPRITE = class_2960.method_60656((String)"container/bundle/slot_highlight_back");
    private static final class_2960 SLOT_HIGHLIGHT_FRONT_SPRITE = class_2960.method_60656((String)"container/bundle/slot_highlight_front");
    private static final class_2960 SLOT_BACKGROUND_SPRITE = class_2960.method_60656((String)"container/bundle/slot_background");
    private static final int SLOT_MARGIN = 4;
    private static final int SLOT_SIZE = 24;
    private static final int GRID_WIDTH = 96;
    private final KeyringContents contents;

    public ClientKeyringTooltip(KeyringContents contents) {
        this.contents = contents;
    }

    public int method_32661(class_327 font) {
        return this.backgroundHeight();
    }

    public int method_32664(class_327 font) {
        return this.backgroundWidth();
    }

    private int backgroundWidth() {
        return 96;
    }

    private int backgroundHeight() {
        return this.itemGridHeight() + 4;
    }

    private int getContentXOffset(int x) {
        return (x - 96) / 2;
    }

    private int itemGridHeight() {
        return this.gridSizeY() * 24;
    }

    private int gridSizeY() {
        return class_3532.method_38788((int)this.slotCount(), (int)this.contents.getShowRowSize());
    }

    private int slotCount() {
        return Math.min(this.contents.getMaxShowSize(), this.contents.size());
    }

    public void method_32666(class_327 font, int pX, int pY, int pW, int pH, class_332 graphics) {
        if (this.contents.isEmpty()) {
            this.renderEmptyBundleTooltip(font, pX, pY, pW, pH, graphics);
        } else {
            this.renderBundleWithItemsTooltip(font, pX, pY, pW, pH, graphics);
        }
    }

    private void renderEmptyBundleTooltip(class_327 font, int pX, int pY, int pW, int pH, class_332 graphics) {
    }

    private void renderBundleWithItemsTooltip(class_327 font, int pX, int pY, int pW, int pH, class_332 graphics) {
        boolean overflow = this.contents.size() > 16;
        List<class_1799> items = this.getShownItems(this.contents.getNumberOfItemsToShow());
        int x = pX + this.getContentXOffset(pW) + 96;
        int y = pY + this.gridSizeY() * 24;
        int index = 1;
        for (int iy = 1; iy <= this.gridSizeY(); ++iy) {
            for (int ix = 1; ix <= this.contents.getShowRowSize(); ++ix) {
                int xOff = x - ix * 24;
                int yOff = y - iy * 24;
                if (ClientKeyringTooltip.shouldRenderSurplusText(overflow, ix, iy)) {
                    ClientKeyringTooltip.renderCount(xOff, yOff, this.getAmountOfHiddenItems(items), font, graphics);
                    continue;
                }
                if (!ClientKeyringTooltip.shouldRenderItemSlot(items, index)) continue;
                this.renderSlot(index, xOff, yOff, items, index, font, graphics);
                ++index;
            }
        }
        this.drawSelectedItemTooltip(font, graphics, pX, pY, pW);
    }

    private List<class_1799> getShownItems(int showCount) {
        int count = Math.min(this.contents.size(), showCount);
        return this.contents.itemCopyStream().toList().subList(0, count);
    }

    private static boolean shouldRenderSurplusText(boolean overflow, int ix, int iy) {
        return overflow && ix * iy == 1;
    }

    private int getAmountOfHiddenItems(List<class_1799> items) {
        return this.contents.itemCopyStream().skip(items.size()).mapToInt(class_1799::method_7947).sum();
    }

    private static boolean shouldRenderItemSlot(List<class_1799> items, int index) {
        return items.size() >= index;
    }

    private static void renderCount(int x, int y, int hiddenCount, class_327 font, class_332 graphics) {
        graphics.method_25300(font, "+" + hiddenCount, x + 12, y + 10, -1);
    }

    private void renderSlot(int index, int pX, int pY, List<class_1799> items, int renderIndex, class_327 font, class_332 graphics) {
        int itemIndex = items.size() - index;
        boolean selected = itemIndex == this.contents.getSelectedItem();
        class_1799 item = items.get(itemIndex);
        if (selected) {
            graphics.method_52706(class_10799.field_56883, SLOT_HIGHLIGHT_BACK_SPRITE, pX, pY, 24, 24);
        } else {
            graphics.method_52706(class_10799.field_56883, SLOT_BACKGROUND_SPRITE, pX, pY, 24, 24);
        }
        graphics.method_51428(item, pX + 4, pY + 4, renderIndex);
        graphics.method_51431(font, item, pX + 4, pY + 4);
        if (selected) {
            graphics.method_52706(class_10799.field_56883, SLOT_HIGHLIGHT_FRONT_SPRITE, pX, pY, 24, 24);
        }
    }

    private void drawSelectedItemTooltip(class_327 font, class_332 graphics, int pX, int pY, int pW) {
        if (this.contents.hasSelectedItem()) {
            class_1799 item = this.contents.getItemUnsafe(this.contents.getSelectedItem());
            class_2561 hoverComponent = item.method_63015();
            int textWidth = font.method_30880(hoverComponent.method_30937());
            int textOffset = pX + pW / 2 - 12;
            class_5684 tooltip = class_5684.method_32662((class_5481)hoverComponent.method_30937());
            graphics.method_51435(font, List.of(tooltip), textOffset - textWidth / 2, pY - 15, class_8001.field_41687, (class_2960)item.method_58694(class_9334.field_54198));
        }
    }
}

