/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.api;

import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.supermartijn642.core.registry.Registries;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_1792;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_7403;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public abstract class ChiselingRecipeProvider
implements class_2405 {
    private final String modid;
    private final FabricDataOutput generator;
    private final Map<class_2960, ChiselingRecipeBuilder> recipes = new HashMap<class_2960, ChiselingRecipeBuilder>();

    public ChiselingRecipeProvider(String modid, FabricDataOutput generator) {
        this.modid = modid;
        this.generator = generator;
    }

    public String method_10321() {
        return "Chiseling Recipes: " + this.modid;
    }

    public CompletableFuture<?> method_10319(class_7403 cache) {
        this.buildRecipes();
        ArrayList<CompletableFuture> tasks = new ArrayList<CompletableFuture>(this.recipes.size());
        Path path = this.generator.method_45971();
        for (Map.Entry<class_2960, ChiselingRecipeBuilder> entry : this.recipes.entrySet()) {
            class_2960 recipeName = entry.getKey();
            ChiselingRecipeBuilder builder = entry.getValue();
            if (builder.parent != null) {
                class_2960 parent = builder.parent;
                while (parent != null && parent.method_12836().equals(this.modid) && this.recipes.containsKey(parent)) {
                    parent = this.recipes.get((Object)parent).parent;
                }
            }
            JsonObject json = ChiselingRecipeProvider.serializeRecipe(recipeName, builder);
            Path recipePath = path.resolve("data/" + recipeName.method_12836() + "/chiseling_recipes/" + recipeName.method_12832() + ".json");
            tasks.add(class_2405.method_10320((class_7403)cache, (JsonElement)json, (Path)recipePath));
        }
        return CompletableFuture.allOf((CompletableFuture[])tasks.toArray(CompletableFuture[]::new));
    }

    private static JsonObject serializeRecipe(class_2960 recipeName, ChiselingRecipeBuilder recipe) {
        JsonObject json = new JsonObject();
        json.addProperty("type", "rechiseled:chiseling");
        if (recipe.parent != null) {
            json.addProperty("parent", recipe.parent.toString());
        }
        json.addProperty("overwrite", Boolean.valueOf(recipe.overwrite));
        HashSet items = Sets.newHashSet();
        JsonArray entries = new JsonArray();
        for (Triple<class_1792, class_1792, Boolean> entry : recipe.entries) {
            JsonObject object = new JsonObject();
            if (entry.getLeft() != null) {
                if (!items.add((class_1792)entry.getLeft())) {
                    throw new IllegalStateException("Duplicate item '" + String.valueOf(Registries.ITEMS.getIdentifier((Object)((class_1792)entry.getLeft()))) + "' in chiseling recipe '" + String.valueOf(recipeName) + "'");
                }
                object.addProperty("item", Registries.ITEMS.getIdentifier((Object)((class_1792)entry.getLeft())).toString());
            }
            if (entry.getMiddle() != null) {
                if (!items.add((class_1792)entry.getMiddle())) {
                    throw new IllegalStateException("Duplicate item '" + String.valueOf(Registries.ITEMS.getIdentifier((Object)((class_1792)entry.getMiddle()))) + "' in chiseling recipe '" + String.valueOf(recipeName) + "'");
                }
                object.addProperty("connecting_item", Registries.ITEMS.getIdentifier((Object)((class_1792)entry.getMiddle())).toString());
            }
            if (((Boolean)entry.getRight()).booleanValue()) {
                object.addProperty("optional", Boolean.valueOf(true));
            }
            entries.add((JsonElement)object);
        }
        json.add("entries", (JsonElement)entries);
        return json;
    }

    protected abstract void buildRecipes();

    protected ChiselingRecipeBuilder beginRecipe(String recipeName) {
        return this.recipes.computeIfAbsent(class_2960.method_60655((String)this.modid, (String)recipeName), s -> new ChiselingRecipeBuilder(this));
    }

    protected ChiselingRecipeBuilder beginRecipe(class_2960 recipe) {
        return this.recipes.computeIfAbsent(recipe, s -> new ChiselingRecipeBuilder(this));
    }

    protected class ChiselingRecipeBuilder {
        private final List<Triple<class_1792, class_1792, Boolean>> entries = new LinkedList<Triple<class_1792, class_1792, Boolean>>();
        private class_2960 parent;
        private boolean overwrite = false;

        private ChiselingRecipeBuilder(ChiselingRecipeProvider this$0) {
        }

        @Deprecated(forRemoval=true)
        @ApiStatus.ScheduledForRemoval(inVersion="1.2.0")
        public ChiselingRecipeBuilder parent(class_2960 parent) {
            this.parent = parent;
            return this;
        }

        public void overwrite(boolean overwrite) {
            this.overwrite = overwrite;
        }

        public ChiselingRecipeBuilder add(@Nullable class_1792 regularItem, @Nullable class_1792 connectingItem, boolean optional) {
            if (regularItem == null && connectingItem == null) {
                throw new IllegalArgumentException("At least one of regular item or connecting item must not be null!");
            }
            this.entries.add((Triple<class_1792, class_1792, Boolean>)new ImmutableTriple((Object)regularItem, (Object)connectingItem, (Object)optional));
            return this;
        }

        public ChiselingRecipeBuilder add(class_1792 regularItem, class_1792 connectingItem) {
            return this.add(regularItem, connectingItem, false);
        }

        public ChiselingRecipeBuilder addRegularItem(class_1792 item, boolean optional) {
            if (item == null) {
                throw new IllegalArgumentException("Item must not be null!");
            }
            return this.add(item, null, optional);
        }

        public ChiselingRecipeBuilder addRegularItem(class_1792 item) {
            return this.addRegularItem(item, false);
        }

        public ChiselingRecipeBuilder addConnectingItem(class_1792 item, boolean optional) {
            if (item == null) {
                throw new IllegalArgumentException("Item must not be null!");
            }
            return this.add(null, item, optional);
        }

        public ChiselingRecipeBuilder addConnectingItem(class_1792 item) {
            return this.addConnectingItem(item, false);
        }
    }
}

