/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.registry;

import com.mojang.serialization.MapCodec;
import com.supermartijn642.core.CoreLib;
import com.supermartijn642.core.registry.Registries;
import com.supermartijn642.core.registry.RegistryUtil;
import com.supermartijn642.core.render.CustomBlockEntityRenderer;
import com.supermartijn642.core.render.CustomItemRenderer;
import com.supermartijn642.core.util.Holder;
import com.supermartijn642.core.util.Pair;
import com.supermartijn642.core.util.TriFunction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.client.rendering.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.SpecialBlockRendererRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.SpecialGuiElementRegistry;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_10439;
import net.minecraft.class_10443;
import net.minecraft.class_10515;
import net.minecraft.class_10517;
import net.minecraft.class_1087;
import net.minecraft.class_11239;
import net.minecraft.class_11515;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3917;
import net.minecraft.class_3929;
import net.minecraft.class_437;
import net.minecraft.class_4597;
import net.minecraft.class_5599;
import net.minecraft.class_5614;
import net.minecraft.class_5616;
import net.minecraft.class_5617;
import net.minecraft.class_827;
import net.minecraft.class_897;
import net.minecraft.class_9334;
import org.jetbrains.annotations.ApiStatus;

public class ClientRegistrationHandler {
    private static final Map<String, ClientRegistrationHandler> REGISTRATION_HELPER_MAP = new TreeMap<String, ClientRegistrationHandler>();
    private static boolean haveRenderersBeenRegistered = false;
    private static boolean haveModelsBeenRegistered = false;
    private final String modid;
    private final List<Pair<class_2960, Consumer<class_1087>>> blockModelConsumers = new ArrayList<Pair<class_2960, Consumer<class_1087>>>();
    private final List<Pair<Supplier<class_2248>, Function<class_1087, class_1087>>> blockModelOverwrites = new ArrayList<Pair<Supplier<class_2248>, Function<class_1087, class_1087>>>();
    private final List<Pair<Supplier<class_1792>, Function<class_10439, class_10439>>> itemModelOverwrites = new ArrayList<Pair<Supplier<class_1792>, Function<class_10439, class_10439>>>();
    private final List<Pair<Supplier<class_1299<?>>, Function<class_5617.class_5618, class_897<?, ?>>>> entityRenderers = new ArrayList();
    private final List<Pair<Supplier<class_2591<?>>, Function<class_5614.class_5615, class_827<?>>>> blockEntityRenderers = new ArrayList();
    private final Map<class_2960, Set<class_2960>> textureAtlasSprites = new HashMap<class_2960, Set<class_2960>>();
    private final List<Pair<Supplier<class_2248>, Supplier<class_10515.class_10516>>> blockSpecialRenderers = new ArrayList<Pair<Supplier<class_2248>, Supplier<class_10515.class_10516>>>();
    private final List<Pair<Supplier<class_3917<?>>, TriFunction<class_1703, class_1661, class_2561, class_437>>> containerScreens = new ArrayList();
    private final List<Pair<Supplier<class_2248>, Supplier<class_11515>>> blockRenderTypes = new ArrayList<Pair<Supplier<class_2248>, Supplier<class_11515>>>();
    private boolean passedTextureStitch;

    @ApiStatus.Internal
    public static void registerRenderersInternal() {
        haveRenderersBeenRegistered = true;
        REGISTRATION_HELPER_MAP.values().forEach(ClientRegistrationHandler::registerRenderers);
    }

    @ApiStatus.Internal
    public static void registerBlockModelConsumerDependenciesInternal(Predicate<class_2960> markModelDependency) {
        haveModelsBeenRegistered = true;
        REGISTRATION_HELPER_MAP.values().forEach(handler -> handler.registerBlockModelConsumerDependencies(markModelDependency));
    }

    @ApiStatus.Internal
    public static void applyBlockModelConsumersInternal(Function<class_2960, class_1087> modelGetter) {
        REGISTRATION_HELPER_MAP.values().forEach(handler -> handler.handleBlockModelConsumers(modelGetter));
    }

    @ApiStatus.Internal
    public static void applyBlockModelOverwritesInternal(Map<class_2680, class_1087> models) {
        REGISTRATION_HELPER_MAP.values().forEach(handler -> handler.applyBlockModelOverwrites(models));
    }

    @ApiStatus.Internal
    public static void applyItemModelOverwritesInternal(Map<class_2960, class_10439> models) {
        REGISTRATION_HELPER_MAP.values().forEach(handler -> handler.applyItemModelOverwrites(models));
    }

    public static synchronized ClientRegistrationHandler get(String modid) {
        if (!RegistryUtil.isValidNamespace(modid)) {
            throw new IllegalArgumentException("Modid '" + modid + "' must only contain characters [a-z0-9_.-]!");
        }
        if (modid.equals("minecraft")) {
            CoreLib.LOGGER.warn("Mod is requesting registration helper for modid '" + modid + "'!");
        } else {
            ModContainer container = FabricLoader.getInstance().getModContainer(modid).orElse(null);
            if (container == null) {
                CoreLib.LOGGER.warn("Mod is requesting registration helper for unknown modid '" + modid + "'!");
            }
        }
        return REGISTRATION_HELPER_MAP.computeIfAbsent(modid, ClientRegistrationHandler::new);
    }

    @ApiStatus.Internal
    public static void collectSprites(class_2960 atlas, Consumer<class_2960> spriteConsumer) {
        for (ClientRegistrationHandler value : REGISTRATION_HELPER_MAP.values()) {
            value.addSprites(atlas, spriteConsumer);
        }
    }

    private ClientRegistrationHandler(String modid) {
        this.modid = modid;
    }

    public void registerBlockModelConsumer(class_2960 location, Consumer<class_1087> consumer) {
        if (haveModelsBeenRegistered) {
            throw new IllegalStateException("Cannot register new model consumer after model registry has been completed!");
        }
        this.blockModelConsumers.add(Pair.of(location, consumer));
    }

    public void registerBlockModelConsumer(String namespace, String identifier, Consumer<class_1087> consumer) {
        if (!RegistryUtil.isValidNamespace(namespace)) {
            throw new IllegalArgumentException("Namespace '" + namespace + "' must only contain characters [a-z0-9_.-]!");
        }
        if (!RegistryUtil.isValidPath(identifier)) {
            throw new IllegalArgumentException("Identifier '" + identifier + "' must only contain characters [a-z0-9_./-]!");
        }
        this.registerBlockModelConsumer(class_2960.method_60655((String)namespace, (String)identifier), consumer);
    }

    public void registerBlockModelConsumer(String identifier, Consumer<class_1087> consumer) {
        this.registerBlockModelConsumer(this.modid, identifier, consumer);
    }

    public void registerBlockModelOverwrite(Supplier<class_2248> block, Function<class_1087, class_1087> modelOverwrite) {
        if (haveModelsBeenRegistered) {
            throw new IllegalStateException("Cannot register new model overwrites after ModelBakeEvent has been fired!");
        }
        this.blockModelOverwrites.add(Pair.of(block, modelOverwrite));
    }

    public void registerBlockModelOverwrite(Supplier<class_2248> block, Supplier<class_1087> modelOverwrite) {
        this.registerBlockModelOverwrite(block, (class_1087 model) -> (class_1087)modelOverwrite.get());
    }

    public void registerBlockModelOverwrite(Supplier<class_2248> block, class_1087 modelOverwrite) {
        this.registerBlockModelOverwrite(block, (class_1087 model) -> modelOverwrite);
    }

    public void registerItemModelOverwrite(Supplier<class_1792> item, Function<class_10439, class_10439> modelOverwrite) {
        if (haveModelsBeenRegistered) {
            throw new IllegalStateException("Cannot register new model overwrites after ModelBakeEvent has been fired!");
        }
        this.itemModelOverwrites.add(Pair.of(item, modelOverwrite));
    }

    public void registerItemModelOverwrite(Supplier<class_1792> item, Supplier<class_10439> modelOverwrite) {
        this.registerItemModelOverwrite(item, (class_10439 model) -> (class_10439)modelOverwrite.get());
    }

    public void registerItemModelOverwrite(Supplier<class_1792> item, class_10439 modelOverwrite) {
        this.registerItemModelOverwrite(item, (class_10439 model) -> modelOverwrite);
    }

    public <T extends class_1297> void registerEntityRenderer(Supplier<class_1299<T>> entityType, Function<class_5617.class_5618, class_897<? super T, ?>> entityRenderer) {
        if (haveRenderersBeenRegistered) {
            throw new IllegalStateException("Cannot register new renderers after renderer registration has been completed!");
        }
        this.entityRenderers.add(Pair.of(entityType, entityRenderer));
    }

    public <T extends class_1297> void registerEntityRenderer(Supplier<class_1299<T>> entityType, Supplier<class_897<? super T, ?>> entityRenderer) {
        this.registerEntityRenderer(entityType, (class_5617.class_5618 context) -> (class_897)entityRenderer.get());
    }

    public <T extends class_1297> void registerEntityRenderer(Supplier<class_1299<T>> entityType, class_897<? super T, ?> entityRenderer) {
        this.registerEntityRenderer(entityType, (class_5617.class_5618 context) -> entityRenderer);
    }

    public <T extends class_2586> void registerBlockEntityRenderer(Supplier<class_2591<T>> entityType, Function<class_5614.class_5615, class_827<? super T>> blockEntityRenderer) {
        if (haveRenderersBeenRegistered) {
            throw new IllegalStateException("Cannot register new renderers after renderer registration has been completed!");
        }
        this.blockEntityRenderers.add(Pair.of(entityType, blockEntityRenderer));
    }

    public <T extends class_2586> void registerBlockEntityRenderer(Supplier<class_2591<T>> entityType, Supplier<class_827<? super T>> blockEntityRenderer) {
        this.registerBlockEntityRenderer(entityType, (class_5614.class_5615 context) -> (class_827)blockEntityRenderer.get());
    }

    public <T extends class_2586> void registerBlockEntityRenderer(Supplier<class_2591<T>> entityType, class_827<? super T> blockEntityRenderer) {
        this.registerBlockEntityRenderer(entityType, (class_5614.class_5615 context) -> blockEntityRenderer);
    }

    public <T extends class_2586> void registerCustomBlockEntityRenderer(Supplier<class_2591<T>> entityType, Supplier<CustomBlockEntityRenderer<? super T>> blockEntityRenderer) {
        this.registerBlockEntityRenderer(entityType, (class_5614.class_5615 context) -> CustomBlockEntityRenderer.of((CustomBlockEntityRenderer)blockEntityRenderer.get()));
    }

    public <T extends class_2586> void registerCustomBlockEntityRenderer(Supplier<class_2591<T>> entityType, CustomBlockEntityRenderer<? super T> blockEntityRenderer) {
        this.registerBlockEntityRenderer(entityType, (class_5614.class_5615 context) -> CustomBlockEntityRenderer.of(blockEntityRenderer));
    }

    public void registerAtlasSprite(class_2960 textureAtlas, class_2960 spriteLocation) {
        if (this.passedTextureStitch) {
            throw new IllegalStateException("Cannot register new models after texture stitching has been completed!");
        }
        if (textureAtlas == null) {
            throw new IllegalArgumentException("Texture atlas must not be null!");
        }
        if (textureAtlas.method_12832().startsWith("textures/atlas/") && textureAtlas.method_12832().endsWith(".png")) {
            textureAtlas = class_2960.method_60655((String)textureAtlas.method_12836(), (String)textureAtlas.method_12832().substring("textures/atlas/".length(), textureAtlas.method_12832().length() - ".png".length()));
        }
        this.textureAtlasSprites.putIfAbsent(textureAtlas, new HashSet());
        if (this.textureAtlasSprites.get(textureAtlas).contains(spriteLocation)) {
            throw new RuntimeException("Duplicate sprite registration '" + String.valueOf(spriteLocation) + "' for atlas '" + String.valueOf(textureAtlas) + "'!");
        }
        this.textureAtlasSprites.get(textureAtlas).add(spriteLocation);
    }

    public void registerAtlasSprite(class_2960 textureAtlas, String spriteLocation) {
        if (!RegistryUtil.isValidPath(spriteLocation)) {
            throw new IllegalArgumentException("Sprite location '" + spriteLocation + "' must only contain characters [a-z0-9_./-]!");
        }
        this.registerAtlasSprite(textureAtlas, class_2960.method_60655((String)this.modid, (String)spriteLocation));
    }

    public void registerSpecialModelRenderer(String identifier, MapCodec<? extends class_10515.class_10516> codec) {
        class_10517.field_55453.method_65325((Object)class_2960.method_60655((String)this.modid, (String)identifier), codec);
    }

    public void registerBlockSpecialModelRenderer(Supplier<class_2248> block, Supplier<class_10515.class_10516> renderer) {
        this.blockSpecialRenderers.add(Pair.of(block, renderer));
    }

    public void registerBlockSpecialModelRenderer(class_2248 block, class_10515.class_10516 renderer) {
        SpecialBlockRendererRegistry.register((class_2248)block, (class_10515.class_10516)renderer);
    }

    public void registerCustomItemRenderer(String identifier, final Supplier<CustomItemRenderer> itemRenderer) {
        final Holder<MapCodec> holder = new Holder<MapCodec>();
        MapCodec codec = MapCodec.unit((Object)new class_10515.class_10516(){
            class_10515<?> renderer = null;

            public class_10515<?> method_65698(class_5599 entityModelSet) {
                if (this.renderer == null) {
                    this.renderer = CustomItemRenderer.toSpecialModelRenderer((CustomItemRenderer)itemRenderer.get());
                }
                return this.renderer;
            }

            public MapCodec<? extends class_10515.class_10516> method_65696() {
                return (MapCodec)holder.get();
            }
        });
        holder.set(codec);
        this.registerSpecialModelRenderer(identifier, (MapCodec<? extends class_10515.class_10516>)codec);
    }

    public void registerCustomItemRenderer(String identifier, CustomItemRenderer itemRenderer) {
        this.registerCustomItemRenderer(identifier, () -> itemRenderer);
    }

    public <T extends class_1703, U extends class_437> void registerContainerScreen(Supplier<class_3917<T>> menuType, TriFunction<T, class_1661, class_2561, U> screenSupplier) {
        if (haveRenderersBeenRegistered) {
            throw new IllegalStateException("Cannot register new menu screens after the ClientInitialization event has been fired!");
        }
        this.containerScreens.add(Pair.of(menuType, screenSupplier));
    }

    public <T extends class_1703, U extends class_437> void registerContainerScreen(Supplier<class_3917<T>> menuType, Function<T, U> screenSupplier) {
        this.registerContainerScreen(menuType, (T container, class_1661 inventory, class_2561 title) -> (class_437)screenSupplier.apply(container));
    }

    public <T extends class_1703, U extends class_437> void registerContainerScreen(class_3917<T> menuType, TriFunction<T, class_1661, class_2561, U> screenSupplier) {
        this.registerContainerScreen(() -> menuType, screenSupplier);
    }

    public <T extends class_1703, U extends class_437> void registerContainerScreen(class_3917<T> menuType, Function<T, U> screenSupplier) {
        this.registerContainerScreen(() -> menuType, (T container, class_1661 inventory, class_2561 title) -> (class_437)screenSupplier.apply(container));
    }

    public void registerBlockModelRenderType(Supplier<class_2248> block, Supplier<class_11515> renderTypeSupplier) {
        if (haveRenderersBeenRegistered) {
            throw new IllegalStateException("Cannot register new menu screens after the ClientInitialization event has been fired!");
        }
        this.blockRenderTypes.add(Pair.of(block, renderTypeSupplier));
    }

    public void registerBlockModelRenderType(Supplier<class_2248> block, class_11515 renderType) {
        this.registerBlockModelRenderType(block, () -> renderType);
    }

    public void registerBlockModelRenderType(class_2248 block, Supplier<class_11515> renderTypeSupplier) {
        this.registerBlockModelRenderType(() -> block, renderTypeSupplier);
    }

    public void registerBlockModelRenderType(class_2248 block, class_11515 renderType) {
        this.registerBlockModelRenderType(() -> block, renderType);
    }

    public void registerBlockModelSolidRenderType(Supplier<class_2248> block) {
        this.registerBlockModelRenderType(block, class_11515.field_60923);
    }

    public void registerBlockModelSolidRenderType(class_2248 block) {
        this.registerBlockModelRenderType(block, class_11515.field_60923);
    }

    public void registerBlockModelCutoutMippedRenderType(Supplier<class_2248> block) {
        this.registerBlockModelRenderType(block, class_11515.field_60924);
    }

    public void registerBlockModelCutoutMippedRenderType(class_2248 block) {
        this.registerBlockModelRenderType(block, class_11515.field_60924);
    }

    public void registerBlockModelCutoutRenderType(Supplier<class_2248> block) {
        this.registerBlockModelRenderType(block, class_11515.field_60925);
    }

    public void registerBlockModelCutoutRenderType(class_2248 block) {
        this.registerBlockModelRenderType(block, class_11515.field_60925);
    }

    public void registerBlockModelTranslucentRenderType(Supplier<class_2248> block) {
        this.registerBlockModelRenderType(block, class_11515.field_60926);
    }

    public void registerBlockModelTranslucentRenderType(class_2248 block) {
        this.registerBlockModelRenderType(block, class_11515.field_60926);
    }

    public void registerItemModelType(String identifier, MapCodec<? extends class_10439.class_10441> codec) {
        class_10443.field_55336.method_65325((Object)class_2960.method_60655((String)this.modid, (String)identifier), codec);
    }

    public void registerPictureInPictureRenderer(Function<class_4597.class_4598, class_11239<?>> renderer) {
        SpecialGuiElementRegistry.register(c -> (class_11239)renderer.apply(c.vertexConsumers()));
    }

    public void registerPictureInPictureRenderer(Supplier<class_11239<?>> renderer) {
        this.registerPictureInPictureRenderer((class_4597.class_4598 buffers) -> (class_11239)renderer.get());
    }

    private void registerRenderers() {
        HashSet entityTypes = new HashSet();
        for (Pair<Supplier<class_1299<?>>, Function<class_5617.class_5618, class_897<?, ?>>> entry : this.entityRenderers) {
            class_1299<?> class_12992 = entry.left().get();
            if (class_12992 == null) {
                throw new RuntimeException("Entity renderer registered with null entity type!");
            }
            if (entityTypes.contains(class_12992)) {
                throw new RuntimeException("Duplicate entity renderer for entity type '" + String.valueOf(Registries.ENTITY_TYPES.getIdentifier(class_12992)) + "'!");
            }
            entityTypes.add(class_12992);
            EntityRendererRegistry.register(class_12992, ((Function)entry.right())::apply);
        }
        HashSet<class_2591> blockEntityTypes = new HashSet<class_2591>();
        for (Pair pair : this.blockEntityRenderers) {
            class_2591 class_25912 = (class_2591)((Supplier)pair.left()).get();
            if (class_25912 == null) {
                throw new RuntimeException("Block entity renderer registered with null block entity type!");
            }
            if (blockEntityTypes.contains(class_25912)) {
                throw new RuntimeException("Duplicate block entity renderer for block entity type '" + String.valueOf(Registries.BLOCK_ENTITY_TYPES.getIdentifier(class_25912)) + "'!");
            }
            blockEntityTypes.add(class_25912);
            class_5616.method_32144((class_2591)class_25912, ((Function)pair.right())::apply);
        }
        HashSet<class_2248> blocks = new HashSet<class_2248>();
        for (Pair<Supplier<class_2248>, Supplier<class_10515.class_10516>> pair : this.blockSpecialRenderers) {
            class_2248 class_22482 = pair.left().get();
            if (class_22482 == null) {
                throw new RuntimeException("Special model renderer registered for null block!");
            }
            if (blocks.contains(class_22482)) {
                throw new RuntimeException("Duplicate special model renderer for block '" + String.valueOf(Registries.BLOCKS.getIdentifier(class_22482)) + "'!");
            }
            class_10515.class_10516 renderer = pair.right().get();
            if (renderer == null) {
                throw new RuntimeException("Got null special model renderer for block '" + String.valueOf(Registries.BLOCKS.getIdentifier(class_22482)) + "'!");
            }
            blocks.add(class_22482);
            SpecialBlockRendererRegistry.register((class_2248)class_22482, (class_10515.class_10516)renderer);
        }
        HashSet hashSet = new HashSet();
        for (Pair<Supplier<class_3917<?>>, TriFunction<class_1703, class_1661, class_2561, class_437>> pair : this.containerScreens) {
            class_3917<?> menuType = pair.left().get();
            if (menuType == null) {
                throw new RuntimeException("Container screen registered with null menu type!");
            }
            if (hashSet.contains(menuType)) {
                throw new RuntimeException("Duplicate container screen for menu type '" + String.valueOf(Registries.MENU_TYPES.getIdentifier(menuType)) + "'!");
            }
            hashSet.add(menuType);
            class_3929.method_17542(menuType, pair.right()::apply);
        }
        blocks = new HashSet();
        for (Pair<Supplier<class_2248>, Supplier<class_11515>> pair : this.blockRenderTypes) {
            class_2248 block = pair.left().get();
            if (block == null) {
                throw new RuntimeException("Block render layer registered for null block!");
            }
            if (blocks.contains(block)) {
                throw new RuntimeException("Duplicate render layer for block '" + String.valueOf(Registries.BLOCKS.getIdentifier(block)) + "'!");
            }
            class_11515 layer = pair.right().get();
            if (layer == null) {
                throw new RuntimeException("Got null render layer for block '" + String.valueOf(Registries.BLOCKS.getIdentifier(block)) + "'!");
            }
            blocks.add(block);
            BlockRenderLayerMap.putBlock((class_2248)block, (class_11515)layer);
        }
    }

    private void registerBlockModelConsumerDependencies(Predicate<class_2960> markModelDependency) {
        HashSet<class_2960> missingModels = null;
        for (Pair<class_2960, Consumer<class_1087>> consumer : this.blockModelConsumers) {
            class_2960 location = consumer.left();
            if (markModelDependency.test(location)) continue;
            if (missingModels == null) {
                missingModels = new HashSet<class_2960>();
            }
            missingModels.add(location);
        }
        if (missingModels != null) {
            CoreLib.LOGGER.error("Missing models for block model consumers from mod '{}': {}", (Object)this.modid, (Object)missingModels.stream().map(l -> "'" + String.valueOf(l) + "'").collect(Collectors.joining(", ")));
        }
    }

    private void handleBlockModelConsumers(Function<class_2960, class_1087> modelGetter) {
        for (Pair<class_2960, Consumer<class_1087>> entry : this.blockModelConsumers) {
            try {
                entry.right().accept(modelGetter.apply(entry.left()));
            }
            catch (Exception e) {
                CoreLib.LOGGER.error("Encountered an exception whilst applying a model consumer for mod '{}'!", (Object)this.modid, (Object)e);
            }
        }
    }

    private void applyBlockModelOverwrites(Map<class_2680, class_1087> models) {
        for (Pair<Supplier<class_2248>, Function<class_1087, class_1087>> overwrite : this.blockModelOverwrites) {
            class_2248 block = overwrite.left().get();
            if (block == null) {
                CoreLib.LOGGER.error("Got 'null' block for block model overwrite from mod '{}'!", (Object)this.modid);
                continue;
            }
            for (class_2680 state : block.method_9595().method_11662()) {
                class_1087 model = models.get(state);
                if (model == null) continue;
                try {
                    model = overwrite.right().apply(model);
                }
                catch (Exception e) {
                    CoreLib.LOGGER.error("Encountered an error while applying block model overwrite from mod '{}' for block state '{}'!", new Object[]{this.modid, state, e});
                    continue;
                }
                if (model == null) {
                    CoreLib.LOGGER.error("Block model overwrite from mod '{}' for block state '{}' returned null!", (Object)this.modid, (Object)state);
                    continue;
                }
                models.put(state, model);
            }
        }
    }

    private void applyItemModelOverwrites(Map<class_2960, class_10439> models) {
        for (Pair<Supplier<class_1792>, Function<class_10439, class_10439>> overwrite : this.itemModelOverwrites) {
            class_1792 item = overwrite.left().get();
            if (item == null) {
                CoreLib.LOGGER.error("Got 'null' item for item model overwrite from mod '{}'!", (Object)this.modid);
                continue;
            }
            class_2960 modelLocation = (class_2960)item.method_57347().method_58694(class_9334.field_54199);
            class_10439 model = models.get(modelLocation);
            if (model == null) continue;
            try {
                model = overwrite.right().apply(model);
            }
            catch (Exception e) {
                CoreLib.LOGGER.error("Encountered an error while applying item model overwrite from mod '{}' for item '{}'!", new Object[]{this.modid, item, e});
                continue;
            }
            if (model == null) {
                CoreLib.LOGGER.error("Item model overwrite from mod '{}' for item '{}' returned null!", (Object)this.modid, (Object)item);
                continue;
            }
            models.put(modelLocation, model);
        }
    }

    private void addSprites(class_2960 atlas, Consumer<class_2960> spriteConsumer) {
        this.passedTextureStitch = true;
        Set<class_2960> sprites = this.textureAtlasSprites.get(atlas);
        if (sprites == null) {
            return;
        }
        sprites.forEach(spriteConsumer);
    }
}

