/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.gui.widget;

import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.gui.GuiGraphicsHelper;
import com.supermartijn642.core.gui.widget.ContainerWidget;
import com.supermartijn642.core.gui.widget.Widget;
import com.supermartijn642.core.gui.widget.WidgetRenderContext;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_156;
import net.minecraft.class_2561;

public abstract class BaseWidget
implements Widget {
    protected final List<Widget> widgets = new ArrayList<Widget>();
    protected Widget focusedWidget = null;
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    private boolean focused;
    protected long nextNarration = Long.MAX_VALUE;

    public BaseWidget(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    @Override
    public int width() {
        return this.width;
    }

    @Override
    public int height() {
        return this.height;
    }

    @Override
    public int left() {
        return this.x;
    }

    @Override
    public int top() {
        return this.y;
    }

    @Override
    public void initialize() {
        this.addWidgets();
        this.widgets.forEach(Widget::initialize);
    }

    @Override
    public void setFocused(boolean focused) {
        if (this.focused != focused) {
            this.nextNarration = focused ? class_156.method_658() + 750L : Long.MAX_VALUE;
        }
        this.focused = focused;
    }

    public boolean isFocused() {
        return this.focused;
    }

    protected void addWidgets() {
    }

    protected <T extends Widget> T addWidget(T widget) {
        if (widget == null) {
            throw new IllegalArgumentException("Widget must not be null!");
        }
        if (widget == this) {
            throw new IllegalArgumentException("Cannot add a widget to itself!");
        }
        if (widget instanceof ContainerWidget) {
            throw new IllegalArgumentException("Cannot add a container widget to a regular widget!");
        }
        this.widgets.add(widget);
        return widget;
    }

    protected boolean removeWidget(Widget widget) {
        return this.widgets.remove(widget);
    }

    @Override
    public void update() {
        this.widgets.forEach(Widget::update);
    }

    @Override
    public void renderBackground(WidgetRenderContext context, GuiGraphicsHelper graphics, int mouseX, int mouseY) {
        if (!this.focused) {
            this.focusedWidget = null;
        } else if (this.focusedWidget != null && (mouseX <= this.focusedWidget.left() || mouseX >= this.focusedWidget.left() + this.focusedWidget.width() || mouseY <= this.focusedWidget.top() || mouseY >= this.focusedWidget.top() + this.focusedWidget.height())) {
            this.focusedWidget = null;
            this.nextNarration = class_156.method_658() + 750L;
        }
        for (Widget widget : this.widgets) {
            if (this.focusedWidget == null && mouseX >= widget.left() && mouseX < widget.left() + widget.width() && mouseY >= widget.top() && mouseY < widget.top() + widget.height()) {
                this.focusedWidget = widget;
                widget.setFocused(true);
                this.nextNarration = Long.MAX_VALUE;
                continue;
            }
            widget.setFocused(widget == this.focusedWidget);
        }
        if (this.focused && this.focusedWidget == null && class_156.method_658() > this.nextNarration) {
            String s;
            class_2561 message = this.getNarrationMessage();
            String string = s = message == null ? "" : message.getString();
            if (!s.isEmpty()) {
                ClientUtils.getMinecraft().method_44713().method_19788(s);
                this.nextNarration = Long.MAX_VALUE;
            }
        }
        this.widgets.stream().filter(w -> w != this.focusedWidget).forEach(w -> w.renderBackground(context, graphics, mouseX, mouseY));
        if (this.focusedWidget != null) {
            this.focusedWidget.renderBackground(context, graphics, mouseX, mouseY);
        }
    }

    @Override
    public void render(WidgetRenderContext context, GuiGraphicsHelper graphics, int mouseX, int mouseY) {
        this.widgets.stream().filter(w -> w != this.focusedWidget).forEach(w -> w.render(context, graphics, mouseX, mouseY));
        if (this.focusedWidget != null) {
            this.focusedWidget.render(context, graphics, mouseX, mouseY);
        }
    }

    @Override
    public void renderForeground(WidgetRenderContext context, GuiGraphicsHelper graphics, int mouseX, int mouseY) {
        this.widgets.stream().filter(w -> w != this.focusedWidget).forEach(w -> w.renderForeground(context, graphics, mouseX, mouseY));
        if (this.focusedWidget != null) {
            this.focusedWidget.renderForeground(context, graphics, mouseX, mouseY);
        }
    }

    @Override
    public void renderOverlay(WidgetRenderContext context, GuiGraphicsHelper graphics, int mouseX, int mouseY) {
        this.widgets.stream().filter(w -> w != this.focusedWidget).forEach(w -> w.renderOverlay(context, graphics, mouseX, mouseY));
        if (this.focusedWidget != null) {
            this.focusedWidget.renderOverlay(context, graphics, mouseX, mouseY);
        }
    }

    @Override
    public void renderTooltips(WidgetRenderContext context, GuiGraphicsHelper graphics, int mouseX, int mouseY) {
        if (this.focused) {
            if (this.focusedWidget != null) {
                this.focusedWidget.renderTooltips(context, graphics, mouseX, mouseY);
            } else {
                ArrayList tooltips = new ArrayList(0);
                this.getTooltips(tooltips::add);
                graphics.submitTooltipForTopStratum(c -> c.text(tooltips), mouseX, mouseY);
            }
        }
    }

    protected void getTooltips(Consumer<class_2561> tooltips) {
    }

    @Override
    public void discard() {
    }

    @Override
    public boolean mousePressed(int mouseX, int mouseY, int button, boolean hasBeenHandled) {
        if (this.focusedWidget != null) {
            hasBeenHandled = this.focusedWidget.mousePressed(mouseX, mouseY, button, hasBeenHandled) || hasBeenHandled;
        }
        for (Widget widget : this.widgets) {
            if (widget == this.focusedWidget) continue;
            hasBeenHandled = widget.mousePressed(mouseX, mouseY, button, hasBeenHandled) || hasBeenHandled;
        }
        return hasBeenHandled;
    }

    @Override
    public boolean mouseReleased(int mouseX, int mouseY, int button, boolean hasBeenHandled) {
        if (this.focusedWidget != null) {
            hasBeenHandled = this.focusedWidget.mouseReleased(mouseX, mouseY, button, hasBeenHandled) || hasBeenHandled;
        }
        for (Widget widget : this.widgets) {
            if (widget == this.focusedWidget) continue;
            hasBeenHandled = widget.mouseReleased(mouseX, mouseY, button, hasBeenHandled) || hasBeenHandled;
        }
        return hasBeenHandled;
    }

    @Override
    public boolean mouseScrolled(int mouseX, int mouseY, double scrollAmount, boolean hasBeenHandled) {
        if (this.focusedWidget != null) {
            hasBeenHandled = this.focusedWidget.mouseScrolled(mouseX, mouseY, scrollAmount, hasBeenHandled) || hasBeenHandled;
        }
        for (Widget widget : this.widgets) {
            if (widget == this.focusedWidget) continue;
            hasBeenHandled = widget.mouseScrolled(mouseX, mouseY, scrollAmount, hasBeenHandled) || hasBeenHandled;
        }
        return hasBeenHandled;
    }

    @Override
    public boolean keyPressed(int keyCode, boolean hasBeenHandled) {
        if (this.focusedWidget != null) {
            hasBeenHandled = this.focusedWidget.keyPressed(keyCode, hasBeenHandled) || hasBeenHandled;
        }
        for (Widget widget : this.widgets) {
            if (widget == this.focusedWidget) continue;
            hasBeenHandled = widget.keyPressed(keyCode, hasBeenHandled) || hasBeenHandled;
        }
        return hasBeenHandled;
    }

    @Override
    public boolean keyReleased(int keyCode, boolean hasBeenHandled) {
        if (this.focusedWidget != null) {
            hasBeenHandled = this.focusedWidget.keyReleased(keyCode, hasBeenHandled) || hasBeenHandled;
        }
        for (Widget widget : this.widgets) {
            if (widget == this.focusedWidget) continue;
            hasBeenHandled = widget.keyReleased(keyCode, hasBeenHandled) || hasBeenHandled;
        }
        return hasBeenHandled;
    }

    @Override
    public boolean charTyped(char character, boolean hasBeenHandled) {
        if (this.focusedWidget != null) {
            hasBeenHandled = this.focusedWidget.charTyped(character, hasBeenHandled) || hasBeenHandled;
        }
        for (Widget widget : this.widgets) {
            if (widget == this.focusedWidget) continue;
            hasBeenHandled = widget.charTyped(character, hasBeenHandled) || hasBeenHandled;
        }
        return hasBeenHandled;
    }
}

