/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.client.gui.v2;

import net.minecraft.class_8030;
import org.joml.Vector2i;

public enum AnchorPoint {
    TOP_LEFT(-1, -1),
    TOP_CENTER(0, -1),
    TOP_RIGHT(1, -1),
    CENTER_LEFT(-1, 0),
    CENTER(0, 0),
    CENTER_RIGHT(1, 0),
    BOTTOM_LEFT(-1, 1),
    BOTTOM_CENTER(0, 1),
    BOTTOM_RIGHT(1, 1);

    private final int offsetX;
    private final int offsetY;

    private AnchorPoint(int offsetX, int offsetY) {
        this.offsetX = offsetX;
        this.offsetY = offsetY;
    }

    public boolean isLeft() {
        return this.offsetX == -1;
    }

    public boolean isCenter() {
        return this.offsetX == 0;
    }

    public boolean isRight() {
        return this.offsetX == 1;
    }

    public Positioner createPositioner(int guiWidth, int guiHeight, int elementWidth, int elementHeight) {
        return new PositionerImpl(this.offsetX, this.offsetY, guiWidth, guiHeight, elementWidth, elementHeight);
    }

    private record PositionerImpl(int offsetX, int offsetY, int guiWidth, int guiHeight, int elementWidth, int elementHeight) implements Positioner
    {
        @Override
        public int getPosX(int posX) {
            return Math.round((float)this.guiWidth / 2.0f + (float)this.offsetX * ((float)this.guiWidth / 2.0f - (float)posX) - (float)((this.offsetX + 1) * this.elementWidth) / 2.0f);
        }

        @Override
        public int getPosY(int posY) {
            return Math.round((float)this.guiHeight / 2.0f + (float)this.offsetY * ((float)this.guiHeight / 2.0f - (float)posY) - (float)((this.offsetY + 1) * this.elementHeight) / 2.0f);
        }

        @Override
        public class_8030 getRectangle(int posX, int posY) {
            return new class_8030(this.getPosX(posX), this.getPosY(posY), this.elementWidth, this.elementHeight);
        }
    }

    public static interface Positioner {
        public int getPosX(int var1);

        public int getPosY(int var1);

        default public Vector2i getPosition(int posX, int posY) {
            return new Vector2i(this.getPosX(posX), this.getPosY(posY));
        }

        public class_8030 getRectangle(int var1, int var2);
    }
}

