/*
 * Decompiled with CFR 0.152.
 */
package github.meloweh.wolfcompanion.goals;

import github.meloweh.wolfcompanion.accessor.WolfEntityProvider;
import github.meloweh.wolfcompanion.util.ConfigManager;
import github.meloweh.wolfcompanion.util.LineScan;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_11;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1493;
import net.minecraft.class_1569;
import net.minecraft.class_1657;
import net.minecraft.class_238;
import net.minecraft.class_3218;

public class WolfMeleeAttackGoal
extends class_1352 {
    protected final class_1493 mob;
    private final WolfEntityProvider wolf;
    private final double speed;
    private final boolean pauseWhenMobIdle;
    private class_11 path;
    private double targetX;
    private double targetY;
    private double targetZ;
    private int updateCountdownTicks;
    private int cooldown;
    private final int attackIntervalTicks = 20;
    private long lastUpdateTime;
    private static final long MAX_ATTACK_TIME = 20L;

    public WolfMeleeAttackGoal(class_1493 mob, double speed, boolean pauseWhenMobIdle) {
        this.mob = mob;
        this.wolf = (WolfEntityProvider)this.mob;
        this.speed = speed;
        this.pauseWhenMobIdle = pauseWhenMobIdle;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    private void pickAttackerWithSpread() {
        if (!this.mob.method_6181()) {
            return;
        }
        if (this.mob.method_5968() != null) {
            return;
        }
        class_1657 player = (class_1657)this.mob.method_35057();
        if (player == null) {
            return;
        }
        class_238 playerArea = player.method_5829().method_1014(10.0);
        class_3218 serverWorld = (class_3218)player.method_37908();
        if (serverWorld == null) {
            return;
        }
        List pack = serverWorld.method_8390(class_1493.class, playerArea, e -> e.method_6181() && !e.method_5667().equals(this.mob.method_5667()));
        if (!this.mob.method_56677() || pack.stream().anyMatch(e -> !e.method_56677())) {
            return;
        }
        List attackers = serverWorld.method_8390(class_1308.class, playerArea, attacker -> attacker instanceof class_1569 && attacker.method_5968() != null && attacker.method_5968().method_5667() == player.method_5667() && !ConfigManager.isBlacklisted((class_1297)attacker));
        attackers.sort(Comparator.comparingDouble(e -> e.method_5739((class_1297)player)));
        if (attackers.isEmpty()) {
            return;
        }
        this.mob.method_5980((class_1309)attackers.getFirst());
    }

    private void pickAttackerWithoutSpread() {
        if (!this.mob.method_6181()) {
            return;
        }
        if (this.mob.method_5968() != null) {
            return;
        }
        class_1657 player = (class_1657)this.mob.method_35057();
        if (player == null) {
            return;
        }
        class_238 playerArea = player.method_5829().method_1014(10.0);
        class_3218 serverWorld = (class_3218)player.method_37908();
        if (serverWorld == null) {
            return;
        }
        List pack = serverWorld.method_8390(class_1493.class, playerArea, e -> e.method_6181() && !e.method_5667().equals(this.mob.method_5667()));
        List attackers = serverWorld.method_8390(class_1308.class, playerArea, attacker -> attacker instanceof class_1569 && attacker.method_5968() != null && attacker.method_5968().method_5667() == player.method_5667() && !ConfigManager.isBlacklisted((class_1297)attacker));
        attackers.sort(Comparator.comparingDouble(e -> e.method_5739((class_1297)player)));
        Optional<class_1308> coop = attackers.stream().filter(attacker -> pack.stream().anyMatch(w -> w.method_5968() != null && w.method_5968().method_5667().equals(attacker.method_5667()))).findFirst();
        if (coop.isPresent()) {
            this.mob.method_5980((class_1309)coop.get());
        } else if (!attackers.isEmpty()) {
            this.mob.method_5980((class_1309)attackers.getFirst());
        }
    }

    public boolean method_6264() {
        long l = this.mob.method_37908().method_8510();
        if (l - this.lastUpdateTime < 20L) {
            return false;
        }
        this.lastUpdateTime = l;
        this.pickAttackerWithSpread();
        this.pickAttackerWithoutSpread();
        class_1309 livingEntity = this.mob.method_5968();
        if (livingEntity == null) {
            return false;
        }
        if (!livingEntity.method_5805() || livingEntity.method_5771()) {
            return false;
        }
        if (LineScan.hasFloorLava((class_1309)this.mob)) {
            return false;
        }
        this.path = this.mob.method_5942().method_6349((class_1297)livingEntity, 0);
        if (this.path != null) {
            return true;
        }
        return this.mob.method_42150(livingEntity);
    }

    public boolean method_6266() {
        class_1309 livingEntity = this.mob.method_5968();
        if (livingEntity == null) {
            return false;
        }
        if (!livingEntity.method_5805() || livingEntity.method_5771()) {
            return false;
        }
        if (!this.pauseWhenMobIdle) {
            return !this.mob.method_5942().method_6357();
        }
        if (!this.mob.method_18407(livingEntity.method_24515())) {
            return false;
        }
        return !(livingEntity instanceof class_1657) || !livingEntity.method_7325() && !((class_1657)livingEntity).method_68878();
    }

    public void method_6269() {
        this.mob.method_5942().method_6334(this.path, this.speed);
        this.mob.method_19540(true);
        this.updateCountdownTicks = 0;
        this.cooldown = 0;
    }

    public void method_6270() {
        class_1309 livingEntity = this.mob.method_5968();
        if (!class_1301.field_6156.test(livingEntity)) {
            this.mob.method_5980((class_1309)null);
        }
        this.mob.method_19540(false);
        this.mob.method_5942().method_6340();
    }

    public boolean method_38846() {
        return true;
    }

    public void method_6268() {
        class_1309 livingEntity = this.mob.method_5968();
        if (livingEntity != null) {
            this.mob.method_5988().method_6226((class_1297)livingEntity, 30.0f, 30.0f);
            this.updateCountdownTicks = Math.max(this.updateCountdownTicks - 1, 0);
            if ((this.pauseWhenMobIdle || this.mob.method_5985().method_6369((class_1297)livingEntity)) && this.updateCountdownTicks <= 0 && (this.targetX == 0.0 && this.targetY == 0.0 && this.targetZ == 0.0 || livingEntity.method_5649(this.targetX, this.targetY, this.targetZ) >= 1.0 || this.mob.method_59922().method_43057() < 0.05f)) {
                this.targetX = livingEntity.method_23317();
                this.targetY = livingEntity.method_23318();
                this.targetZ = livingEntity.method_23321();
                this.updateCountdownTicks = 4 + this.mob.method_59922().method_43048(7);
                double d = this.mob.method_5858((class_1297)livingEntity);
                if (d > 1024.0) {
                    this.updateCountdownTicks += 10;
                } else if (d > 256.0) {
                    this.updateCountdownTicks += 5;
                }
                if (!this.mob.method_5942().method_6335((class_1297)livingEntity, this.speed)) {
                    this.updateCountdownTicks += 15;
                }
                this.updateCountdownTicks = this.method_38847(this.updateCountdownTicks);
            }
            this.cooldown = Math.max(this.cooldown - 1, 0);
            this.attack(livingEntity);
        }
    }

    protected void attack(class_1309 target) {
        if (this.canAttack(target)) {
            this.resetCooldown();
            this.mob.method_6104(class_1268.field_5808);
            this.wolf.tryAttack__(WolfMeleeAttackGoal.method_64451((class_1297)this.mob), (class_1297)target);
        }
    }

    protected void resetCooldown() {
        this.cooldown = this.method_38847(20);
    }

    protected boolean isCooledDown() {
        return this.cooldown <= 0;
    }

    protected boolean canAttack(class_1309 target) {
        return this.isCooledDown() && this.mob.method_42150(target) && this.mob.method_5985().method_6369((class_1297)target);
    }

    protected int getCooldown() {
        return this.cooldown;
    }

    protected int getMaxCooldown() {
        return this.method_38847(20);
    }
}

