/*
 * Decompiled with CFR 0.152.
 */
package github.meloweh.wolfcompanion.goals;

import github.meloweh.wolfcompanion.accessor.WolfEntityProvider;
import github.meloweh.wolfcompanion.util.ConfigManager;
import github.meloweh.wolfcompanion.util.WolfInventoryProvider;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1263;
import net.minecraft.class_1265;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1352;
import net.minecraft.class_1493;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1928;
import net.minecraft.class_3218;

public class PickUpFoodGoal
extends class_1352
implements class_1265 {
    final class_1493 wolf;
    final WolfEntityProvider provider;
    int scanCooldown;
    final WolfInventoryProvider inventory;
    final Predicate<class_1542> PICKABLE_DROP_FILTER = item -> !item.method_6977() && item.method_5805() && WolfInventoryProvider.canEat(item.method_6983());

    public PickUpFoodGoal(class_1493 wolf) {
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        this.wolf = wolf;
        this.provider = (WolfEntityProvider)wolf;
        this.scanCooldown = 0;
        this.inventory = new WolfInventoryProvider(this.wolf);
    }

    public void method_5453(class_1263 sender) {
        if (this.provider.hasChestEquipped()) {
            this.inventory.refreshInventoryContents(sender);
        }
    }

    public static boolean playerFoodEnough(class_1493 wolf) {
        if (!ConfigManager.config.shouldCarePlayerFood) {
            return true;
        }
        if (wolf.method_35057() != null) {
            class_1661 inv = ((class_1657)wolf.method_35057()).method_31548();
            ArrayList<class_1799> ic = new ArrayList<class_1799>();
            for (int slotIndex = 0; slotIndex < inv.method_5439(); ++slotIndex) {
                ic.add(inv.method_5438(slotIndex));
            }
            return ic.stream().filter(WolfInventoryProvider::canPlayerEat).mapToInt(class_1799::method_7947).sum() >= ConfigManager.config.requiredPlayerFood;
        }
        return true;
    }

    private boolean nakedAndHungry() {
        return !this.provider.hasChestEquipped() && this.wolf.method_6032() <= this.wolf.method_6063() * 0.8f && this.wolf.method_6118(class_1304.field_6173).method_7960();
    }

    private boolean wantsToPickupItem() {
        if (!ConfigManager.config.canPickupFood) {
            return false;
        }
        if (this.provider.hasChestEquipped()) {
            this.inventory.inventoryInit(this);
            if (this.inventory.hasSpace() && (this.inventory.getFoodCount() <= (long)ConfigManager.config.maxPickupFood || ConfigManager.config.pickAllRottenFlesh && this.inventory.onlyFood(class_1802.field_8511))) {
                return true;
            }
        }
        return this.nakedAndHungry() && PickUpFoodGoal.playerFoodEnough(this.wolf);
    }

    private List<class_1542> findPickups() {
        return this.wolf.method_37908().method_8390(class_1542.class, this.wolf.method_5829().method_1009(8.0, 8.0, 8.0), this.PICKABLE_DROP_FILTER);
    }

    public boolean method_6264() {
        if (!this.wolf.method_37908().field_9236 && this.wolf.method_5805() && !this.wolf.method_29504() && ((class_3218)this.wolf.method_37908()).method_64395().method_8355(class_1928.field_19388)) {
            if (this.wolf.method_6181() && !this.wolf.method_37908().field_9236 && !this.wolf.method_24345() && this.wolf.method_5968() == null && this.wolf.method_6065() == null) {
                if (!this.wantsToPickupItem()) {
                    return false;
                }
                if (this.wolf.method_59922().method_43048(PickUpFoodGoal.method_38848((int)10)) != 0) {
                    return false;
                }
                List<class_1542> list = this.findPickups();
                return !list.isEmpty();
            }
            return false;
        }
        return false;
    }

    public void method_6268() {
        this.navigate();
    }

    public boolean method_6266() {
        return this.wantsToPickupItem();
    }

    private void navigate() {
        List<class_1542> list = this.findPickups();
        if (!list.isEmpty()) {
            class_1542 first = list.getFirst();
            this.provider.setTargetPickup__(first);
            this.wolf.method_5942().method_6335((class_1297)first, (double)1.2f);
        }
    }

    public void method_6269() {
        this.navigate();
    }

    public void method_6270() {
        super.method_6270();
        if (this.provider.hasChestEquipped()) {
            this.inventory.inventoryInit(this);
        }
        this.provider.setTargetPickup__(null);
    }
}

