/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.util;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.regex.Pattern;
import net.minecraft.class_1074;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_3542;
import net.minecraft.class_5699;
import snownee.jade.Jade;
import snownee.jade.api.JadeIds;
import snownee.jade.util.JsonConfig;
import snownee.jade.util.KeyedResourceManagerReloadListener;
import snownee.jade.util.WordCutter;

public class JadeLanguages
implements KeyedResourceManagerReloadListener,
WordCutter.TokenClassifier {
    public static final class_2960 ID = JadeIds.JADE("languages");
    public static final JadeLanguages INSTANCE = new JadeLanguages();
    private final EnumMap<WordCutter.TokenType, Pattern> tokens = new EnumMap(WordCutter.TokenType.class);
    private final Cache<String, WordCutter.TokenType> tokenCache = CacheBuilder.newBuilder().maximumSize(100L).build();
    private Map<String, Pattern> nameClasses = Map.of();
    private final Cache<String, String> nameClassCache = CacheBuilder.newBuilder().maximumSize(100L).build();
    private Locale locale = Locale.ENGLISH;
    private boolean rtl;

    public void method_14491(class_3300 resourceManager) {
        this.tokens.clear();
        this.tokenCache.invalidateAll();
        this.nameClasses = Map.of();
        this.nameClassCache.invalidateAll();
        try {
            JsonObject jsonObject = (JsonObject)JsonConfig.GSON.fromJson(class_1074.method_4662((String)"jade.metadata", (Object[])new Object[0]), JsonObject.class);
            Metadata metadata = (Metadata)Metadata.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject).getOrThrow();
            String langCode = class_310.method_1551().method_1526().method_4669();
            if (!metadata.lang.contains(langCode)) {
                return;
            }
            String[] langSplit = langCode.split("_", 2);
            this.locale = langSplit.length == 1 ? new Locale(langSplit[0]) : new Locale(langSplit[0], langSplit[1]);
            this.rtl = metadata.rtl;
            Preconditions.checkState((!metadata.tokens.containsKey((Object)WordCutter.TokenType.WORD) ? 1 : 0) != 0, (Object)"Word token type is not allowed");
            this.tokens.putAll(metadata.tokens);
            this.nameClasses = metadata.nameClasses;
        }
        catch (Throwable e) {
            Jade.LOGGER.error("Failed to load Jade language metadata", e);
        }
    }

    public boolean isRTL() {
        return this.rtl;
    }

    public String getNameClass(String name) {
        if (this.nameClasses.isEmpty()) {
            return "other";
        }
        try {
            return (String)this.nameClassCache.get((Object)name, () -> {
                for (Map.Entry<String, Pattern> entry : this.nameClasses.entrySet()) {
                    if (!entry.getValue().matcher(name).matches()) continue;
                    return entry.getKey();
                }
                return "other";
            });
        }
        catch (ExecutionException e) {
            return "other";
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public class_2960 getUid() {
        return ID;
    }

    @Override
    public WordCutter.TokenType classify(String s) {
        if (s.isBlank()) {
            return WordCutter.TokenType.SEPARATOR;
        }
        if (this.tokens.isEmpty()) {
            return switch (s) {
                case "(", "[", "<" -> WordCutter.TokenType.LEFT_BRACKET;
                case ")", "]", ">" -> WordCutter.TokenType.RIGHT_BRACKET;
                case ":" -> WordCutter.TokenType.COLON;
                case "|", "-", ",", "/", "&" -> WordCutter.TokenType.SYMBOL;
                default -> WordCutter.TokenType.WORD;
            };
        }
        try {
            return (WordCutter.TokenType)((Object)this.tokenCache.get((Object)s, () -> {
                for (Map.Entry<WordCutter.TokenType, Pattern> entry : this.tokens.entrySet()) {
                    if (!entry.getValue().matcher(s).matches()) continue;
                    return entry.getKey();
                }
                return WordCutter.TokenType.WORD;
            }));
        }
        catch (ExecutionException e) {
            return WordCutter.TokenType.WORD;
        }
    }

    private record Metadata(List<String> lang, boolean rtl, Map<WordCutter.TokenType, Pattern> tokens, Map<String, Pattern> nameClasses) {
        static final Codec<Metadata> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.STRING.listOf().fieldOf("lang").forGetter(Metadata::lang), (App)Codec.BOOL.optionalFieldOf("rtl", (Object)false).forGetter(Metadata::rtl), (App)Codec.unboundedMap((Codec)class_3542.method_28140(WordCutter.TokenType::values), (Codec)class_5699.field_37408).optionalFieldOf("tokens", Map.of()).forGetter(Metadata::tokens), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)class_5699.field_37408).optionalFieldOf("nameClasses", Map.of()).forGetter(Metadata::nameClasses)).apply((Applicative)i, Metadata::new));
    }
}

