/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.track;

import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.HashSet;
import java.util.List;
import snownee.jade.api.view.ProgressView;
import snownee.jade.track.TrackInfo;
import snownee.jade.util.SmoothChasingValue;

public class ProgressTrackInfo
extends TrackInfo {
    private final Int2ObjectMap<Child> children = new Int2ObjectOpenHashMap();
    private final boolean canDecrease;
    private int width;
    private int ticksSinceWidthChanged;
    private int expectedWidth;

    public ProgressTrackInfo(List<ProgressView.Part> parts, boolean canDecrease, int width) {
        this.canDecrease = canDecrease;
        this.width = width;
        this.setProgress(parts);
    }

    public int getWidth() {
        return this.width;
    }

    @Override
    public void update(float pTicks) {
        for (Child child : this.children.values()) {
            child.update(pTicks);
        }
    }

    public void setExpectedWidth(int expectedWidth) {
        this.expectedWidth = expectedWidth;
        if (expectedWidth > this.width) {
            this.width = expectedWidth;
            this.ticksSinceWidthChanged = 0;
        }
    }

    public void setProgress(List<ProgressView.Part> parts) {
        HashSet set = Sets.newHashSet();
        for (ProgressView.Part part : parts) {
            Child child = (Child)this.children.get(part.id());
            if (child == null) {
                child = new Child(part, this.canDecrease);
                this.children.put(part.id(), (Object)child);
            } else {
                child.part = part;
                child.setProgress(child.part.progress());
            }
            set.add(child);
        }
        for (Child child : this.children.values()) {
            if (set.contains(child)) continue;
            child.setProgress(0.0f);
        }
    }

    public float getSmoothProgress(ProgressView.Part part) {
        Child child = (Child)this.children.get(part.id());
        if (child == null) {
            return part.progress();
        }
        return child.smoothProgress.value;
    }

    @Override
    public void tick() {
        if (this.expectedWidth < this.width && ++this.ticksSinceWidthChanged > 10) {
            this.width = this.expectedWidth;
            this.ticksSinceWidthChanged = 0;
        }
    }

    public static class Child {
        private ProgressView.Part part;
        private final boolean canDecrease;
        private final SmoothChasingValue smoothProgress = new SmoothChasingValue();
        private float ticksSinceValueChanged;

        public Child(ProgressView.Part part, boolean canDecrease) {
            this.canDecrease = canDecrease;
            this.part = part;
            this.smoothProgress.start(part.progress());
        }

        public void setProgress(float progress) {
            if (this.smoothProgress.getTarget() == progress) {
                return;
            }
            this.ticksSinceValueChanged = 0.0f;
            if (this.canDecrease || progress > this.smoothProgress.getTarget()) {
                this.smoothProgress.target(progress);
            } else {
                this.smoothProgress.start(progress);
            }
        }

        public void update(float pTicks) {
            float progress = this.part.progress();
            if (progress != this.smoothProgress.getTarget() && this.ticksSinceValueChanged > 0.0f) {
                if (this.ticksSinceValueChanged > 10.0f) {
                    this.smoothProgress.withSpeed(0.4f);
                } else if (this.canDecrease || progress > this.smoothProgress.getTarget()) {
                    float spd = Math.abs(progress - this.smoothProgress.getTarget()) / this.ticksSinceValueChanged;
                    spd = Math.max(0.1f, 4.0f * spd);
                    this.smoothProgress.withSpeed(spd);
                }
                this.ticksSinceValueChanged = pTicks;
            } else {
                this.ticksSinceValueChanged += pTicks;
            }
            if (!this.canDecrease && progress < this.smoothProgress.getTarget()) {
                if (this.smoothProgress.isMoving()) {
                    this.smoothProgress.withSpeed(Math.max(0.5f, this.smoothProgress.getSpeed()));
                    if (this.smoothProgress.getTarget() > 0.9f) {
                        this.smoothProgress.target(1.0f);
                    }
                } else {
                    this.smoothProgress.start(progress);
                }
            } else {
                this.smoothProgress.target(progress);
            }
            this.smoothProgress.tick(pTicks);
        }
    }
}

