/*
 * Decompiled with CFR 0.152.
 */
package pigcart.particlerain.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.awt.Color;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Type;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_2378;
import net.minecraft.class_2400;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5244;
import net.minecraft.class_5321;
import net.minecraft.class_5878;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import pigcart.particlerain.ParticleRain;
import pigcart.particlerain.VersionUtil;
import pigcart.particlerain.WeatherParticleManager;
import pigcart.particlerain.config.ConfigData;
import pigcart.particlerain.mixin.access.ParticleEngineAccessor;

public class ConfigManager {
    static final Gson GSON = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(Color.class, (Object)new ColorTypeAdapter()).create();
    static final String CONFIG_PATH = "config/particlerain.json";
    public static ConfigData config;
    public static ConfigData defaultConfig;

    public static void load() {
        File file = new File(CONFIG_PATH);
        try (FileReader reader = new FileReader(file);){
            config = (ConfigData)GSON.fromJson((Reader)reader, ConfigData.class);
        }
        catch (Exception e) {
            ParticleRain.LOGGER.error("Error loading config: {}", (Object)e.getMessage());
            config = new ConfigData();
            ConfigManager.save();
        }
        if (ConfigManager.config.configVersion < ConfigManager.defaultConfig.configVersion) {
            ParticleRain.LOGGER.info("Overwriting old config file");
            config = new ConfigData();
            ConfigManager.save();
        }
        ConfigManager.updateTransientVariables();
    }

    public static void save() {
        try (FileWriter writer = new FileWriter(CONFIG_PATH);){
            GSON.toJson((Object)config, (Appendable)writer);
        }
        catch (Exception e) {
            ParticleRain.LOGGER.error(e.getMessage());
        }
        ConfigManager.updateTransientVariables();
    }

    public static void updateTransientVariables() {
        for (ConfigData.ParticleData opts : ConfigManager.config.particles) {
            opts.biomeList.populateInternalLists();
            opts.blockList.populateInternalLists();
            opts.setPresetParticle();
        }
    }

    public static List<String> getRegistryEntries(class_2378<?> registry) {
        ArrayList<String> list = new ArrayList<String>();
        registry.method_10235().forEach(id -> list.add(id.toString()));
        VersionUtil.getTagIds(registry).forEach(tag -> list.add("#" + String.valueOf(tag.comp_327())));
        return list;
    }

    static {
        defaultConfig = new ConfigData();
    }

    public static class ColorTypeAdapter
    implements JsonSerializer<Color>,
    JsonDeserializer<Color> {
        public JsonElement serialize(Color color, Type type, JsonSerializationContext context) {
            return new JsonPrimitive(String.join((CharSequence)"", "#", String.format("%02X", color.getRed()), String.format("%02X", color.getGreen()), String.format("%02X", color.getBlue())));
        }

        public Color deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return Color.decode(json.getAsString());
        }
    }

    public static class UsingCustomTint
    implements Function<Object, Boolean> {
        @Override
        public Boolean apply(Object context) {
            ConfigData.ParticleData ctx = (ConfigData.ParticleData)context;
            return ctx.tintType == ConfigData.TintType.CUSTOM;
        }
    }

    public static class ParticleIsNotDefault
    implements Function<Object, Boolean> {
        @Override
        public Boolean apply(Object context) {
            ConfigData.ParticleData ctx = (ConfigData.ParticleData)context;
            return ConfigManager.defaultConfig.particles.stream().noneMatch(defaultData -> ctx.id.equals(defaultData.id));
        }
    }

    public static class ParticleNotCustom
    implements Function<Object, Boolean> {
        @Override
        public Boolean apply(Object context) {
            ConfigData.ParticleData ctx = (ConfigData.ParticleData)context;
            return ctx.usePresetParticle;
        }
    }

    public static class ParticleIsCustom
    implements Function<Object, Boolean> {
        @Override
        public Boolean apply(Object context) {
            ConfigData.ParticleData ctx = (ConfigData.ParticleData)context;
            return !ctx.usePresetParticle;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface OnlyEditableIf {
        public Class<? extends Function<Object, Boolean>> value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface OnlyVisibleIf {
        public Class<? extends Function<Object, Boolean>> value();
    }

    public static class SupplyBiomes
    implements Supplier<List<String>> {
        @Override
        public List<String> get() {
            if (class_310.method_1551().field_1687 == null) {
                return List.of("[!] \u00a7e\u00a7l" + class_2561.method_43471((String)"particlerain.suggest").getString());
            }
            return ConfigManager.getRegistryEntries(VersionUtil.getRegistry(class_7924.field_41236));
        }
    }

    public static class SupplyBlocks
    implements Supplier<List<String>> {
        @Override
        public List<String> get() {
            if (class_310.method_1551().field_1687 == null) {
                return List.of("[!] \u00a7e\u00a7l" + class_2561.method_43471((String)"particlerain.suggest").getString());
            }
            return ConfigManager.getRegistryEntries(class_7923.field_41175);
        }
    }

    public static class SupplyParticleTypes
    implements Supplier<List<String>> {
        @Override
        public List<String> get() {
            ArrayList<String> list = new ArrayList<String>();
            for (Map.Entry entry : class_7923.field_41180.method_29722()) {
                if (!(entry.getValue() instanceof class_2400)) continue;
                list.add(((class_5321)entry.getKey()).method_29177().toString());
            }
            return list;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Dropdown {
        public Class<? extends Supplier<List<String>>> value();
    }

    public static class ClearParticles
    implements Runnable {
        @Override
        public void run() {
            ((ParticleEngineAccessor)class_310.method_1551().field_1713).callClearParticles();
            WeatherParticleManager.particleGroup = new class_5878(ConfigManager.config.perf.maxParticleAmount);
        }
    }

    public static class ReloadResources
    implements Runnable {
        @Override
        public void run() {
            class_310.method_1551().method_1521();
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface OnChange {
        public Class<? extends Runnable> value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface RegenScreen {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface NoGUI {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Group {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface BooleanFormat {
        public String t();

        public String f();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Label {
        public String key();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface OverrideName {
        public String value();
    }

    public static class ZeroIsAutomatic
    implements Function<Object, class_2561> {
        @Override
        public class_2561 apply(Object value) {
            return ((Number)value).doubleValue() == 0.0 ? class_2561.method_43471((String)"particlerain.auto") : class_2561.method_43470((String)value.toString());
        }
    }

    public static class PercentOrOff
    implements Function<Object, class_2561> {
        @Override
        public class_2561 apply(Object value) {
            return ((Number)value).doubleValue() == 0.0 ? class_5244.field_24333.method_27661().method_27692(class_124.field_1061) : class_2561.method_43470((String)NumberFormat.getPercentInstance().format(value));
        }
    }

    public static class Percent
    implements Function<Object, class_2561> {
        @Override
        public class_2561 apply(Object value) {
            return class_2561.method_43470((String)NumberFormat.getPercentInstance().format(value));
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Format {
        public Class<? extends Function<Object, class_2561>> value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Slider {
        public float min() default 0.0f;

        public float max() default 1.0f;

        public float step() default 0.01f;
    }
}

