/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util.time;

import fi.dy.masa.malilib.mixin.server.IMixinServerTickManager;
import fi.dy.masa.malilib.util.MathUtils;
import net.minecraft.class_310;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.ApiStatus;

public class TickUtils {
    private static final Data INSTANCE = new Data();

    public static Data getInstance() {
        return INSTANCE;
    }

    public static float getTickRate() {
        class_310 mc = class_310.method_1551();
        if (mc.method_1496() && mc.method_1576() != null) {
            return mc.method_1576().method_54833().method_54748();
        }
        if (mc.field_1687 != null) {
            return mc.field_1687.method_54719().method_54748();
        }
        return -1.0f;
    }

    public static float getMillisPerTick() {
        class_310 mc = class_310.method_1551();
        if (mc.method_1496() && mc.method_1576() != null) {
            return mc.method_1576().method_54833().method_54749();
        }
        if (mc.field_1687 != null) {
            return mc.field_1687.method_54719().method_54749();
        }
        return -1.0f;
    }

    public static long getSprintTicks() {
        class_310 mc = class_310.method_1551();
        if (mc.method_1496() && mc.method_1576() != null) {
            return ((IMixinServerTickManager)mc.method_1576().method_54833()).malilib_getSprintTicks();
        }
        if (TickUtils.getInstance().hasServuxData()) {
            return TickUtils.getInstance().getSprintTicks();
        }
        return -1L;
    }

    public static boolean isStepping() {
        class_310 mc = class_310.method_1551();
        if (mc.method_1496() && mc.method_1576() != null) {
            return mc.method_1576().method_54833().method_54752();
        }
        if (TickUtils.getInstance().hasServuxData()) {
            return TickUtils.getInstance().isStepping();
        }
        if (mc.field_1687 != null) {
            return mc.field_1687.method_54719().method_54752();
        }
        return false;
    }

    public static boolean isFrozen() {
        class_310 mc = class_310.method_1551();
        if (mc.method_1496() && mc.method_1576() != null) {
            return mc.method_1576().method_54833().method_54754();
        }
        if (TickUtils.getInstance().hasServuxData()) {
            return TickUtils.getInstance().isFrozen();
        }
        if (mc.field_1687 != null) {
            return mc.field_1687.method_54719().method_54754();
        }
        return false;
    }

    public static boolean isSprinting() {
        class_310 mc = class_310.method_1551();
        if (mc.method_1496() && mc.method_1576() != null) {
            return mc.method_1576().method_54833().method_54670();
        }
        if (TickUtils.getInstance().hasServuxData()) {
            return TickUtils.getInstance().isSprinting();
        }
        if (mc.field_1687 != null) {
            Data timeData = TickUtils.getInstance();
            return timeData.hasTimeSynced() && timeData.getActualTPS() / 3.0 > timeData.getTickRate();
        }
        return false;
    }

    public static boolean isEstimated() {
        return TickUtils.getInstance().hasTimeSynced();
    }

    public static boolean isValid() {
        return TickUtils.getInstance().isValid();
    }

    public static boolean hasDirectData() {
        return TickUtils.getInstance().hasDirectData();
    }

    public static boolean hasServuxData() {
        return TickUtils.getInstance().hasServuxData();
    }

    public static double getMeasuredMSPT() {
        Data timeData = TickUtils.getInstance();
        if (timeData.isValid()) {
            return timeData.getMeasuredMSPT();
        }
        return 0.0;
    }

    public static double getMeasuredTPS() {
        Data timeData = TickUtils.getInstance();
        if (timeData.isValid()) {
            return timeData.getMeasuredTPS();
        }
        return 0.0;
    }

    public static double getDirectMSPT() {
        Data timeData = TickUtils.getInstance();
        if (timeData.hasDirectData()) {
            return timeData.getDirectMSPT();
        }
        return 0.0;
    }

    public static double getDirectTPS() {
        Data timeData = TickUtils.getInstance();
        if (timeData.hasDirectData()) {
            return timeData.getDirectTPS();
        }
        return 0.0;
    }

    public static double getActualTPS() {
        Data timeData = TickUtils.getInstance();
        if (timeData.isValid()) {
            return timeData.getActualTPS();
        }
        return 0.0;
    }

    @ApiStatus.Experimental
    public static double getAvgMSPT() {
        Data timeData = TickUtils.getInstance();
        if (timeData.isValid()) {
            return timeData.getAverageMSPT();
        }
        return 0.0;
    }

    @ApiStatus.Experimental
    public static double getAvgTPS() {
        Data timeData = TickUtils.getInstance();
        if (timeData.isValid()) {
            return timeData.getAverageTPS();
        }
        return 0.0;
    }

    public static class Data {
        private double tickRate = TickUtils.getTickRate();
        private double measuredTPS = -1.0;
        private double measuredMSPT = -1.0;
        private double directTPS = -1.0;
        private double directMSPT = -1.0;
        private double actualTPS = -1.0;
        private long lastDirectTick = -1L;
        private long lastNanoTick = -1L;
        private long lastNanoTime = -1L;
        private final int MAX_HISTORY = 30;
        private final double[] prevMeasuredMSPT = new double[30];
        private final double[] prevMeasuredTPS = new double[30];
        private int lastMeasurementTick = 0;
        private double avgMeasuredMSPT = -1.0;
        private double avgMeasuredTPS = -1.0;
        private boolean isValid = false;
        private boolean hasTimeSynced = false;
        private boolean useDirectServerData = false;
        private boolean hasServuxData = false;
        private long sprintTicks = -1L;
        private boolean isFrozen;
        private boolean isSprinting;
        private boolean isStepping;

        private Data() {
        }

        public void updateTickRate(float tickRate) {
            this.tickRate = tickRate;
        }

        public boolean isUsingDirectServerData() {
            return this.useDirectServerData;
        }

        public void toggleUseDirectServerData(boolean toggle) {
            this.useDirectServerData = toggle;
        }

        @ApiStatus.Internal
        public void updateNanoTick(long timeUpdate) {
            if (!class_310.method_1551().method_1496()) {
                long elapsed;
                long currentTime = System.nanoTime();
                if (this.hasTimeSynced && (elapsed = timeUpdate - this.lastNanoTick) > 0L) {
                    if (this.useDirectServerData && this.lastDirectTick > -1L && currentTime - this.lastDirectTick > 3000000000L) {
                        this.toggleUseDirectServerData(false);
                        this.directTPS = -1.0;
                        this.directMSPT = -1.0;
                        this.lastDirectTick = -1L;
                        this.sprintTicks = -1L;
                        this.isSprinting = false;
                        this.isFrozen = false;
                        this.isStepping = false;
                        this.hasServuxData = false;
                    }
                    this.measuredMSPT = (double)(currentTime - this.lastNanoTime) / (double)elapsed / 1000000.0;
                    this.measuredTPS = this.measuredMSPT <= 50.0 ? this.tickRate : 1000.0 / this.measuredMSPT;
                    this.actualTPS = 1000.0 / this.measuredMSPT;
                    this.isValid = true;
                }
                this.lastNanoTick = timeUpdate;
                this.lastNanoTime = currentTime;
                this.hasTimeSynced = true;
            }
        }

        @ApiStatus.Internal
        public void updateNanoTickFromIntegratedServer(MinecraftServer server) {
            this.lastNanoTime = System.nanoTime();
            if (server != null) {
                this.measuredMSPT = MathUtils.average(server.method_54835()) / 1000000.0;
                this.measuredTPS = this.measuredMSPT <= 50.0 ? this.tickRate : 1000.0 / this.measuredMSPT;
                this.actualTPS = 1000.0 / this.measuredMSPT;
                this.isValid = true;
            }
        }

        public void updateNanoTickFromServerDirect(double tps, double mspt) {
            if (this.useDirectServerData && !this.hasServuxData) {
                this.directMSPT = mspt;
                this.directTPS = tps;
                this.lastDirectTick = System.nanoTime();
                this.isValid = true;
            }
        }

        public void updateNanoTickFromServux(double tps, double mspt, long sprintTicks, boolean frozen, boolean sprinting, boolean stepping) {
            if (this.useDirectServerData) {
                this.directMSPT = MathUtils.round(mspt, 2);
                this.directTPS = MathUtils.round(tps, 2);
                this.lastDirectTick = System.nanoTime();
                this.sprintTicks = sprintTicks;
                this.isFrozen = frozen;
                this.isSprinting = sprinting;
                this.isStepping = stepping;
                this.hasServuxData = true;
                this.isValid = true;
            }
        }

        @ApiStatus.Internal
        private void calculateAverages() {
            if (this.lastMeasurementTick >= 30) {
                this.lastMeasurementTick = 0;
            }
            this.prevMeasuredMSPT[this.lastMeasurementTick] = this.measuredMSPT;
            this.prevMeasuredTPS[this.lastMeasurementTick] = this.measuredTPS;
            this.avgMeasuredMSPT = MathUtils.average(this.prevMeasuredMSPT);
            this.avgMeasuredTPS = MathUtils.average(this.prevMeasuredTPS);
            ++this.lastMeasurementTick;
        }

        public boolean isValid() {
            return this.isValid;
        }

        public boolean hasTimeSynced() {
            return this.hasTimeSynced;
        }

        public boolean hasDirectData() {
            return this.useDirectServerData;
        }

        public boolean hasServuxData() {
            return this.hasServuxData;
        }

        public double getTickRate() {
            return this.tickRate;
        }

        public long getSprintTicks() {
            return this.sprintTicks;
        }

        public boolean isFrozen() {
            return this.isFrozen;
        }

        public boolean isSprinting() {
            return this.isSprinting;
        }

        public boolean isStepping() {
            return this.isStepping;
        }

        public double getMeasuredTPS() {
            return this.measuredTPS;
        }

        public double getMeasuredMSPT() {
            return this.measuredMSPT;
        }

        public double getDirectTPS() {
            return this.directTPS;
        }

        public double getDirectMSPT() {
            return this.directMSPT;
        }

        public double getActualTPS() {
            return this.actualTPS;
        }

        @ApiStatus.Internal
        public double getAverageMSPT() {
            return this.avgMeasuredMSPT;
        }

        @ApiStatus.Internal
        public double getAverageTPS() {
            return this.avgMeasuredTPS;
        }
    }
}

