/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.data.tag;

import com.google.common.collect.Iterables;
import com.mojang.datafixers.util.Pair;
import com.mojang.datafixers.util.Unit;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.ListBuilder;
import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.data.tag.DatType;
import fi.dy.masa.malilib.data.tag.IDat;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public class ListDat<E>
implements IDat<List<IDat<?>>> {
    private final List<IDat<?>> valueList = new ArrayList();
    private DatType valueType = DatType.EMPTY;
    private Serializer<E> serializer = null;

    public ListDat() {
    }

    public ListDat(IDat<E> value) {
        this.add(value);
    }

    private List<IDat<E>> cast() {
        return this.valueList;
    }

    @Nullable
    public IDat<E> get(int index) {
        if (index >= this.valueList.size()) {
            MaLiLib.LOGGER.error("ListDat: Excepting getting list index [{}]; Out Of Bounds", (Object)index);
            return null;
        }
        try {
            return (IDat)this.valueList.get(index).getValue();
        }
        catch (Exception err) {
            MaLiLib.LOGGER.error("ListDat: Excepting getting list index [{}]; {}", (Object)index, (Object)err.getLocalizedMessage());
            return null;
        }
    }

    @Nullable
    public IDat<E> set(int index, IDat<E> newValue) {
        if (index >= this.valueList.size()) {
            MaLiLib.LOGGER.error("ListDat: Excepting setting list index [{}]; Out Of Bounds", (Object)index);
            return null;
        }
        if (newValue.getType() != this.valueType) {
            MaLiLib.LOGGER.error("ListDat: Exception setting element [{}]; Invalid type [{}] when expecting type [{}]", (Object)index, (Object)newValue.getType().method_15434(), (Object)this.valueType.method_15434());
            return null;
        }
        try {
            return (IDat)this.valueList.set(index, newValue).getValue();
        }
        catch (Exception err) {
            MaLiLib.LOGGER.error("ListDat: Excepting setting list index [{}]; {}", (Object)index, (Object)err.getLocalizedMessage());
            return null;
        }
    }

    public boolean add(IDat<E> newValue) {
        if (!this.isEmpty() && newValue.getType() != this.valueType) {
            MaLiLib.LOGGER.error("ListDat: Exception adding new element; Invalid type [{}] when expecting type [{}]", (Object)newValue.getType().method_15434(), (Object)this.valueType.method_15434());
            return false;
        }
        if (this.isEmpty()) {
            this.valueType = newValue.getType();
        }
        try {
            this.valueList.add(newValue);
            this.refreshSerializer();
            return true;
        }
        catch (Exception err) {
            MaLiLib.LOGGER.error("ListDat: Excepting adding to list; {}", (Object)err.getLocalizedMessage());
            return false;
        }
    }

    @Nullable
    public IDat<E> getFirst() {
        if (this.valueList.isEmpty()) {
            MaLiLib.LOGGER.error("ListDat: Excepting getting first index; Out Of Bounds (Empty)");
            return null;
        }
        try {
            return (IDat)this.valueList.getFirst().getValue();
        }
        catch (Exception err) {
            MaLiLib.LOGGER.error("ListDat: Excepting getting first index; {}", (Object)err.getLocalizedMessage());
            return null;
        }
    }

    @Nullable
    public IDat<E> getLast() {
        if (this.valueList.isEmpty()) {
            MaLiLib.LOGGER.error("ListDat: Excepting getting last index; Out Of Bounds (Empty)");
            return null;
        }
        try {
            return (IDat)this.valueList.getLast().getValue();
        }
        catch (Exception err) {
            MaLiLib.LOGGER.error("ListDat: Excepting getting last index; {}", (Object)err.getLocalizedMessage());
            return null;
        }
    }

    public boolean isEmpty() {
        return this.valueList.isEmpty();
    }

    public int size() {
        return this.valueList != null ? this.valueList.size() : 0;
    }

    public void clear() {
        this.valueList.clear();
    }

    public List<E> toValueList() {
        ArrayList list = new ArrayList();
        this.valueList.forEach(entry -> list.add(entry.getValue()));
        return list;
    }

    @Nullable
    public ListDat<E> copyFrom(List<IDat<?>> otherList) {
        this.valueList.clear();
        if (!otherList.isEmpty()) {
            this.valueList.addAll(otherList);
            this.valueType = otherList.getFirst().getType();
            this.refreshSerializer();
        } else {
            this.valueType = DatType.EMPTY;
        }
        return this;
    }

    public Stream<IDat<E>> stream() {
        return this.cast().stream();
    }

    public Stream<E> streamValues() {
        return this.toValueList().stream();
    }

    public Iterable<IDat<E>> iterator() {
        return Iterables.concat((Iterable[])new Iterable[]{this.cast()});
    }

    @Override
    public List<IDat<?>> getValue() {
        return this.valueList;
    }

    @Override
    public void setValue(List<IDat<?>> newValue) {
        this.copyFrom(newValue);
    }

    @Override
    public DatType getType() {
        return DatType.LIST;
    }

    public DatType getValueType() {
        return this.valueType;
    }

    @Nullable
    public Codec<E> getValueCodec() {
        return this.valueType.codec();
    }

    @Override
    public class_2520 toVanilla() {
        class_2499 list = new class_2499();
        this.valueList.forEach(entry -> list.add((Object)entry.toVanilla()));
        return list;
    }

    private void refreshSerializer() {
        if (this.valueList.isEmpty()) {
            this.serializer = null;
            this.valueType = DatType.EMPTY;
            return;
        }
        IDat<E> entry = this.getFirst();
        if (entry == null) {
            MaLiLib.LOGGER.error("ListDat: Exception refreshing Serializer; first entry is empty!");
            this.valueList.clear();
            this.serializer = null;
            this.valueType = DatType.EMPTY;
            return;
        }
        this.valueType = entry.getType();
        Codec<E> valueCodec = this.getValueCodec();
        if (valueCodec == null) {
            MaLiLib.LOGGER.error("ListDat: Exception refreshing Serializer; first entry CODEC is empty!");
            this.valueList.clear();
            this.serializer = null;
            this.valueType = DatType.EMPTY;
            return;
        }
        this.serializer = new Serializer<E>(valueCodec);
    }

    public record Serializer<E>(Codec<E> codec) implements Codec<List<E>>
    {
        public <T> DataResult<T> encode(List<E> input, DynamicOps<T> ops, T prefix) {
            if (this.codec() == null || input.isEmpty()) {
                return DataResult.error(() -> "Empty List / Codec!");
            }
            ListBuilder builder = ops.listBuilder();
            for (E entry : input) {
                builder.add(this.codec().encodeStart(ops, entry));
            }
            return builder.build(prefix);
        }

        public <T> DataResult<Pair<List<E>, T>> decode(DynamicOps<T> ops, T input) {
            return ops.getList(input).flatMap(inst -> {
                DecoderContext decoder = new DecoderContext(ops);
                inst.accept(decoder::accept);
                return decoder.build();
            });
        }

        private class DecoderContext<V> {
            private final DynamicOps<V> ops;
            private final List<E> values = new ArrayList();
            private final Stream.Builder<V> error = Stream.builder();
            private DataResult<Unit> results = DataResult.success((Object)Unit.INSTANCE, (Lifecycle)Lifecycle.stable());

            private DecoderContext(DynamicOps<V> ops) {
                this.ops = ops;
            }

            public void accept(V value) {
                DataResult valueEach = Serializer.this.codec().decode(this.ops, value);
                valueEach.error().ifPresent(err -> this.error.add(value));
                valueEach.resultOrPartial().ifPresent(pair -> this.values.add(pair.getFirst()));
                this.results = this.results.apply2stable((res, ele) -> res, valueEach);
            }

            public DataResult<Pair<List<E>, V>> build() {
                Object errors = this.ops.createList(this.error.build());
                Pair pair = Pair.of(List.copyOf(this.values), (Object)errors);
                return this.results.map(unit -> pair).setPartial((Object)pair);
            }
        }
    }
}

