/*
 * Decompiled with CFR 0.152.
 */
package net.pneumono.pneumonocore.test;

import net.pneumono.pneumonocore.PneumonoCore;
import net.pneumono.pneumonocore.config_api.ConfigApi;
import net.pneumono.pneumonocore.config_api.configurations.AbstractConfiguration;
import net.pneumono.pneumonocore.config_api.configurations.BooleanConfiguration;
import net.pneumono.pneumonocore.config_api.configurations.BoundedFloatConfiguration;
import net.pneumono.pneumonocore.config_api.configurations.BoundedIntegerConfiguration;
import net.pneumono.pneumonocore.config_api.configurations.ConfigSettings;
import net.pneumono.pneumonocore.config_api.configurations.EnumConfiguration;
import net.pneumono.pneumonocore.config_api.configurations.FloatConfiguration;
import net.pneumono.pneumonocore.config_api.configurations.IntegerConfiguration;
import net.pneumono.pneumonocore.config_api.configurations.PerPlayerConfiguration;
import net.pneumono.pneumonocore.config_api.configurations.StringConfiguration;
import net.pneumono.pneumonocore.config_api.configurations.TimeConfiguration;
import net.pneumono.pneumonocore.config_api.configurations.ValidatedStringConfiguration;
import net.pneumono.pneumonocore.config_api.enums.LoadType;
import net.pneumono.pneumonocore.config_api.enums.TimeUnit;

public final class PneumonoCoreTestConfigs {
    public static final String MOD_ID = "pneumonocore";
    public static final String CATEGORY_1 = "test_category_1";
    public static final String CATEGORY_2 = "test_category_2";
    public static final BooleanConfiguration BOOLEAN = PneumonoCoreTestConfigs.register("test_boolean", new BooleanConfiguration(true, new ConfigSettings().category("test_category_1")));
    public static final BoundedFloatConfiguration CHILD_1 = PneumonoCoreTestConfigs.register("test_child_1", new BoundedFloatConfiguration(0.33f, new ConfigSettings().parent(BOOLEAN, value -> value)));
    public static final BoundedFloatConfiguration CHILD_2 = PneumonoCoreTestConfigs.register("test_child_2", new BoundedFloatConfiguration(0.66f, new ConfigSettings().parent(BOOLEAN, value -> value)));
    public static final BoundedFloatConfiguration CHILD_3 = PneumonoCoreTestConfigs.register("test_child_3", new BoundedFloatConfiguration(1.0f, new ConfigSettings().parent(BOOLEAN, value -> value)));
    public static final EnumConfiguration<TestEnum> ENUM = PneumonoCoreTestConfigs.register("test_enum", new EnumConfiguration<TestEnum>(TestEnum.VALUE_1, new ConfigSettings().category("test_category_1")));
    public static final BoundedFloatConfiguration FLOAT = PneumonoCoreTestConfigs.register("test_float", new BoundedFloatConfiguration(0.5f, new ConfigSettings().category("test_category_1")));
    public static final BoundedIntegerConfiguration INTEGER = PneumonoCoreTestConfigs.register("test_integer", new BoundedIntegerConfiguration(5, 0, 10, new ConfigSettings().category("test_category_2")));
    public static final StringConfiguration STRING = PneumonoCoreTestConfigs.register("test_string", new StringConfiguration("Testing!", new ConfigSettings().category("test_category_2")));
    public static final TimeConfiguration TIME = PneumonoCoreTestConfigs.register("test_time", new TimeConfiguration((long)TimeUnit.MINUTES.getDivision() * 22L, new ConfigSettings()));
    public static final BooleanConfiguration CLIENT = PneumonoCoreTestConfigs.register("test_client", new BooleanConfiguration(true, new ConfigSettings().clientSide()));
    public static final BooleanConfiguration INSTANT = PneumonoCoreTestConfigs.register("test_instant", new BooleanConfiguration(true, new ConfigSettings().loadType(LoadType.INSTANT)));
    public static final BooleanConfiguration RESTART = PneumonoCoreTestConfigs.register("test_restart", new BooleanConfiguration(true, new ConfigSettings().loadType(LoadType.RESTART)));
    public static final BooleanConfiguration CLIENT_INSTANT = PneumonoCoreTestConfigs.register("test_client_instant", new BooleanConfiguration(true, new ConfigSettings().clientSide().loadType(LoadType.INSTANT)));
    public static final BooleanConfiguration CLIENT_RESTART = PneumonoCoreTestConfigs.register("test_client_restart", new BooleanConfiguration(true, new ConfigSettings().clientSide().loadType(LoadType.RESTART)));
    public static final PerPlayerConfiguration<Boolean> PER_PLAYER = PneumonoCoreTestConfigs.register("test_per_player", new PerPlayerConfiguration<Boolean>(new BooleanConfiguration(true, new ConfigSettings())));
    public static final BoundedIntegerConfiguration ALIAS = PneumonoCoreTestConfigs.register("test_alias", new BoundedIntegerConfiguration(5, 0, 10, new ConfigSettings().aliases("test_alias_old")));
    public static final BoundedIntegerConfiguration BLOAT_1 = PneumonoCoreTestConfigs.register("bloat_1", new BoundedIntegerConfiguration(5, 0, 10, new ConfigSettings()));
    public static final BoundedIntegerConfiguration BLOAT_2 = PneumonoCoreTestConfigs.register("bloat_2", new BoundedIntegerConfiguration(5, 0, 10, new ConfigSettings()));
    public static final BoundedIntegerConfiguration BLOAT_3 = PneumonoCoreTestConfigs.register("bloat_3", new BoundedIntegerConfiguration(5, 0, 10, new ConfigSettings()));
    public static final IntegerConfiguration UNBOUNDED_INT = PneumonoCoreTestConfigs.register("test_unbounded_int", new IntegerConfiguration(5, new ConfigSettings()));
    public static final FloatConfiguration UNBOUNDED_FLOAT = PneumonoCoreTestConfigs.register("test_unbounded_float", new FloatConfiguration(Float.valueOf(5.0f), new ConfigSettings()));
    public static final ValidatedStringConfiguration VALIDATED = PneumonoCoreTestConfigs.register("test_validated", new ValidatedStringConfiguration("validated!", string -> string.equals(string.toLowerCase()), new ConfigSettings()));

    public static <T extends AbstractConfiguration<?>> T register(String name, T config) {
        return ConfigApi.register(PneumonoCore.identifier(name), config);
    }

    public static void registerTestConfigs() {
        ConfigApi.finishRegistry(MOD_ID);
    }

    public static enum TestEnum {
        VALUE_1,
        VALUE_2,
        VALUE_3;

    }
}

