/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.mixin.features.render.particle;

import net.caffeinemc.mods.sodium.api.util.ColorABGR;
import net.caffeinemc.mods.sodium.api.vertex.buffer.VertexBufferWriter;
import net.caffeinemc.mods.sodium.api.vertex.format.common.ParticleVertex;
import net.caffeinemc.mods.sodium.client.render.vertex.VertexConsumerUtils;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_3940;
import net.minecraft.class_4184;
import net.minecraft.class_4588;
import net.minecraft.class_638;
import net.minecraft.class_703;
import org.joml.Math;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.lwjgl.system.MemoryStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3940.class})
public abstract class SingleQuadParticleMixin
extends class_703 {
    @Unique
    private static final Vector3f TEMP_LEFT = new Vector3f();
    @Unique
    private static final Vector3f TEMP_UP = new Vector3f();

    @Shadow
    public abstract float method_18132(float var1);

    @Shadow
    protected abstract float method_18133();

    @Shadow
    protected abstract float method_18134();

    @Shadow
    protected abstract float method_18135();

    @Shadow
    protected abstract float method_18136();

    protected SingleQuadParticleMixin(class_638 level, double x, double y, double z) {
        super(level, x, y, z);
    }

    @Inject(method={"method_3074(Lnet/minecraft/class_4588;Lnet/minecraft/class_4184;F)V"}, at={@At(value="HEAD")}, cancellable=true)
    protected void render(class_4588 vertexConsumer, class_4184 camera, float tickDelta, CallbackInfo ci) {
        VertexBufferWriter writer = VertexConsumerUtils.convertOrLog(vertexConsumer);
        if (writer == null) {
            return;
        }
        ci.cancel();
        float size = this.method_18132(tickDelta);
        Vector3f left = TEMP_LEFT;
        left.set((Vector3fc)camera.method_35689()).mul(size);
        Vector3f up = TEMP_UP;
        up.set((Vector3fc)camera.method_19336()).mul(size);
        if (!class_3532.method_15347((float)this.field_3839, (float)0.0f)) {
            float roll = class_3532.method_16439((float)tickDelta, (float)this.field_3857, (float)this.field_3839);
            float sinRoll = Math.sin((float)roll);
            float cosRoll = Math.cosFromSin((float)sinRoll, (float)roll);
            float rv1x = Math.fma((float)cosRoll, (float)left.x, (float)(sinRoll * up.x));
            float rv1y = Math.fma((float)cosRoll, (float)left.y, (float)(sinRoll * up.y));
            float rv1z = Math.fma((float)cosRoll, (float)left.z, (float)(sinRoll * up.z));
            float rv2x = Math.fma((float)(-sinRoll), (float)left.x, (float)(cosRoll * up.x));
            float rv2y = Math.fma((float)(-sinRoll), (float)left.y, (float)(cosRoll * up.y));
            float rv2z = Math.fma((float)(-sinRoll), (float)left.z, (float)(cosRoll * up.z));
            left.set(rv1x, rv1y, rv1z);
            up.set(rv2x, rv2y, rv2z);
        }
        this.sodium$emitVertices(writer, camera.method_19326(), left, up, tickDelta);
    }

    @Inject(method={"method_60373(Lnet/minecraft/class_4588;Lnet/minecraft/class_4184;Lorg/joml/Quaternionf;F)V"}, at={@At(value="HEAD")}, cancellable=true)
    protected void renderRotatedQuad(class_4588 vertexConsumer, class_4184 camera, Quaternionf quaternion, float tickDelta, CallbackInfo ci) {
        VertexBufferWriter writer = VertexConsumerUtils.convertOrLog(vertexConsumer);
        if (writer == null) {
            return;
        }
        ci.cancel();
        float size = this.method_18132(tickDelta);
        Vector3f left = TEMP_LEFT;
        left.set(-size, 0.0f, 0.0f).rotate((Quaternionfc)quaternion);
        Vector3f up = TEMP_UP;
        up.set(0.0f, size, 0.0f).rotate((Quaternionfc)quaternion);
        this.sodium$emitVertices(writer, camera.method_19326(), left, up, tickDelta);
    }

    @Unique
    private void sodium$emitVertices(VertexBufferWriter writer, class_243 camera, Vector3f left, Vector3f up, float tickDelta) {
        float minU = this.method_18133();
        float maxU = this.method_18134();
        float minV = this.method_18135();
        float maxV = this.method_18136();
        int light = this.method_3068(tickDelta);
        int color = ColorABGR.pack(this.field_3861, this.field_3842, this.field_3859, this.field_3841);
        float x = (float)(class_3532.method_16436((double)tickDelta, (double)this.field_3858, (double)this.field_3874) - camera.method_10216());
        float y = (float)(class_3532.method_16436((double)tickDelta, (double)this.field_3838, (double)this.field_3854) - camera.method_10214());
        float z = (float)(class_3532.method_16436((double)tickDelta, (double)this.field_3856, (double)this.field_3871) - camera.method_10215());
        try (MemoryStack stack = MemoryStack.stackPush();){
            long buffer;
            long ptr = buffer = stack.nmalloc(112);
            ParticleVertex.put(ptr, -left.x - up.x + x, -left.y - up.y + y, -left.z - up.z + z, maxU, maxV, color, light);
            ParticleVertex.put(ptr += 28L, -left.x + up.x + x, -left.y + up.y + y, -left.z + up.z + z, maxU, minV, color, light);
            ParticleVertex.put(ptr += 28L, left.x + up.x + x, left.y + up.y + y, left.z + up.z + z, minU, minV, color, light);
            ParticleVertex.put(ptr += 28L, left.x - up.x + x, left.y - up.y + y, left.z - up.z + z, minU, maxV, color, light);
            ptr += 28L;
            writer.push(stack, buffer, 4, ParticleVertex.FORMAT);
        }
    }
}

