/*
 * Decompiled with CFR 0.152.
 */
package fliplus.spyglassastronomysync.server;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;

public class ServerSpaceDataManager {
    public static int revision = 0;

    public static void createDataFile(MinecraftServer server, long seedHash) {
        Path dataPath = ServerSpaceDataManager.getDataPath(server, seedHash);
        if (dataPath.toFile().exists()) {
            return;
        }
        try {
            Files.createDirectories(dataPath.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create data directory", e);
        }
        try {
            int SAVE_FORMAT = 1;
            int starCount = 1024;
            float yearLength = 8.0f;
            Files.writeString(dataPath, (CharSequence)("Spyglass Astronomy - Format: " + SAVE_FORMAT + "\n---\n" + seedHash + "\n---" + "\n---" + "\n---" + "\n---\n" + starCount + " " + yearLength + "\n---"), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create data file", e);
        }
    }

    public static String getData(MinecraftServer server, long seedHash) {
        ServerSpaceDataManager.createDataFile(server, seedHash);
        Path dataPath = ServerSpaceDataManager.getDataPath(server, seedHash);
        try {
            return Files.readString(dataPath);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to read data file", e);
        }
    }

    public static void saveData(String data, MinecraftServer server, long seedHash) {
        ServerSpaceDataManager.createDataFile(server, seedHash);
        Path dataPath = ServerSpaceDataManager.getDataPath(server, seedHash);
        try {
            Files.writeString(dataPath, (CharSequence)data, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to write data file", e);
        }
        ++revision;
    }

    public static Path getDataPath(MinecraftServer server, long seedHash) {
        return server.method_27050(class_5218.field_24188).resolve("data").resolve("spyglass_astronomy").resolve(seedHash + ".txt");
    }

    public static boolean isDesynced(int revision) {
        return revision - 1 != ServerSpaceDataManager.revision;
    }
}

