/*
 * Decompiled with CFR 0.152.
 */
package com.texelsaurus.minecraft.chameleon.render;

import com.mojang.blaze3d.vertex.VertexFormatElement;
import com.texelsaurus.minecraft.chameleon.render.ChameleonBlockModelPart;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1058;
import net.minecraft.class_10889;
import net.minecraft.class_2350;
import net.minecraft.class_290;
import net.minecraft.class_777;
import org.jetbrains.annotations.Nullable;

public abstract class ReplacementBlockPart
implements ChameleonBlockModelPart {
    protected class_10889 parent;
    private class_1058 sprite;
    private List<class_777> quads = new ArrayList<class_777>();

    public ReplacementBlockPart(class_10889 part, class_1058 sprite) {
        this.parent = part;
        this.sprite = sprite;
        part.method_68509(null).forEach(quad -> this.quads.add(this.remapQuad((class_777)quad, sprite)));
        for (class_2350 dir : class_2350.values()) {
            part.method_68509(dir).forEach(quad -> this.quads.add(this.remapQuad((class_777)quad, sprite)));
        }
    }

    public ReplacementBlockPart(class_10889 parent, class_10889 replacement) {
        this(parent, replacement.comp_3752());
    }

    public List<class_777> method_68509(@Nullable class_2350 direction) {
        return this.quads;
    }

    public boolean comp_3751() {
        return this.parent.comp_3751();
    }

    public class_1058 comp_3752() {
        if (this.sprite == null) {
            return this.parent.comp_3752();
        }
        return this.sprite;
    }

    class_777 remapQuad(class_777 quad, class_1058 sprite) {
        int[] vertices = (int[])quad.comp_3721().clone();
        for (int i = 0; i < 4; ++i) {
            int blk = class_290.field_1590.getVertexSize() / 4 * i;
            int offset = class_290.field_1590.getOffset(VertexFormatElement.UV) / 4;
            vertices[blk + offset] = Float.floatToRawIntBits(sprite.method_4580(this.getUnInterpolatedU(quad.comp_3724(), Float.intBitsToFloat(vertices[blk + offset]))));
            vertices[blk + offset + 1] = Float.floatToRawIntBits(sprite.method_4570(this.getUnInterpolatedV(quad.comp_3724(), Float.intBitsToFloat(vertices[blk + offset + 1]))));
        }
        return new class_777(vertices, quad.comp_3722(), quad.comp_3723(), sprite, quad.comp_3725(), quad.comp_3726());
    }

    private float getUnInterpolatedU(class_1058 sprite, float u) {
        float diff = sprite.method_4577() - sprite.method_4594();
        return (u - sprite.method_4594()) / diff;
    }

    private float getUnInterpolatedV(class_1058 sprite, float v) {
        float diff = sprite.method_4575() - sprite.method_4593();
        return (v - sprite.method_4593()) / diff;
    }
}

