/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.core.recipe;

import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.DetachedDrawerData;
import com.jaquadro.minecraft.storagedrawers.components.item.DetachedDrawerContents;
import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import com.jaquadro.minecraft.storagedrawers.core.ModDataComponents;
import com.jaquadro.minecraft.storagedrawers.core.ModItems;
import com.jaquadro.minecraft.storagedrawers.core.ModRecipes;
import com.jaquadro.minecraft.storagedrawers.item.ItemDetachedDrawer;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgradeStorage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_11352;
import net.minecraft.class_11362;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1852;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_7225;
import net.minecraft.class_7710;
import net.minecraft.class_8942;
import net.minecraft.class_9279;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9694;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpgradeDetachedDrawerRecipe
extends class_1852 {
    public UpgradeDetachedDrawerRecipe(class_7710 cat) {
        super(cat);
    }

    public boolean matches(@NotNull class_9694 inv, @NotNull class_1937 world) {
        return this.findContext(inv) != null;
    }

    @NotNull
    public class_1799 assemble(@NotNull class_9694 inv, class_7225.class_7874 access) {
        Context ctx = this.findContext(inv);
        if (ctx == null) {
            return class_1799.field_8037;
        }
        class_1799 ret = ctx.drawer.method_7972();
        class_9279 cdata = (class_9279)ret.method_58695(class_9334.field_49628, (Object)class_9279.field_49302);
        class_11368 input = class_11352.method_71417((class_8942)class_8942.field_60348, (class_7225.class_7874)access, (class_2487)cdata.method_57461());
        DetachedDrawerData data = new DetachedDrawerData(input);
        int cap = data.getStorageMultiplier();
        if (ctx.upgrades.isEmpty()) {
            ret = ((class_1792)ModItems.DETACHED_DRAWER.get()).method_7854();
            data = new DetachedDrawerData();
            data.setStorageMultiplier(cap);
        } else {
            int addedCap = ctx.storageMult * (Integer)ModCommonConfig.INSTANCE.DRAWERS.baseStackStorage.get() * (Integer)ModCommonConfig.INSTANCE.DRAWERS.fullDrawers1x1.unitsPerSlot.get();
            data.setStorageMultiplier(data.getStorageMultiplier() + addedCap);
        }
        class_11362 output = class_11362.method_71459((class_8942)class_8942.field_60348, (class_7225.class_7874)access);
        data.serializeNBT((class_11372)output);
        ret.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)output.method_71475()));
        class_1799 savedItem = data.getStoredItemPrototype().method_46651(data.getStoredItemCount());
        DetachedDrawerContents contents = new DetachedDrawerContents(savedItem, cap, data.isHeavy());
        ret.method_57379((class_9331)ModDataComponents.DETACHED_DRAWER_CONTENTS.get(), (Object)contents);
        return ret;
    }

    @Nullable
    private Context findContext(class_9694 inv) {
        Context ret = new Context();
        for (int x = 0; x < inv.method_59983(); ++x) {
            class_1799 stack = inv.method_59984(x);
            if (stack.method_7960()) continue;
            if (stack.method_7909() instanceof ItemDetachedDrawer) {
                if (!ret.drawer.method_7960()) {
                    return null;
                }
                ret.drawer = stack;
                continue;
            }
            if (stack.method_7909() instanceof ItemUpgradeStorage) {
                ret.upgrades.add(stack);
                continue;
            }
            return null;
        }
        if (ret.drawer.method_7960()) {
            return null;
        }
        for (class_1799 upgrade : ret.upgrades) {
            class_1792 class_17922 = upgrade.method_7909();
            if (!(class_17922 instanceof ItemUpgradeStorage)) continue;
            ItemUpgradeStorage storageUpgrade = (ItemUpgradeStorage)class_17922;
            ret.storageMult += ModCommonConfig.INSTANCE.UPGRADES.getLevelMult(storageUpgrade.level.getLevel());
        }
        return ret;
    }

    @NotNull
    public class_1865<? extends class_1852> method_8119() {
        return (class_1865)ModRecipes.DETACHED_UPGRADE_RECIPE_SERIALIZER.get();
    }

    private static class Context {
        class_1799 drawer = class_1799.field_8037;
        List<class_1799> upgrades = new ArrayList<class_1799>();
        int storageMult = 0;

        private Context() {
        }
    }
}

