/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.components.item;

import com.google.common.collect.Lists;
import com.jaquadro.minecraft.storagedrawers.item.ItemKey;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_5632;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public class KeyringContents
implements class_5632 {
    public static final KeyringContents EMPTY = new KeyringContents(List.of());
    public static final Codec<KeyringContents> CODEC = class_1799.field_24671.listOf().xmap(KeyringContents::new, kc -> kc.items);
    public static final class_9139<class_9129, KeyringContents> STREAM_CODEC = class_1799.field_48349.method_56433(class_9135.method_56363()).method_56432(KeyringContents::new, kc -> kc.items);
    private static final int NO_STACK_INDEX = -1;
    public static final int NO_SELECTED_ITEM_INDEX = -1;
    final List<class_1799> items;
    final int selectedItem;

    public KeyringContents(List<class_1799> items, int selectedItem) {
        this.items = items;
        this.selectedItem = selectedItem;
    }

    public KeyringContents(List<class_1799> items) {
        this(items, -1);
    }

    public class_1799 getItemUnsafe(int index) {
        return this.items.get(index);
    }

    public Stream<class_1799> itemCopyStream() {
        return this.items.stream().map(class_1799::method_7972);
    }

    public Iterable<class_1799> items() {
        return this.items;
    }

    public Iterable<class_1799> itemsCopy() {
        return Lists.transform(this.items, class_1799::method_7972);
    }

    public int size() {
        return this.items.size();
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public int getSelectedItem() {
        return this.selectedItem;
    }

    public boolean hasSelectedItem() {
        return this.selectedItem != -1;
    }

    public int getMaxShowSize() {
        return 16;
    }

    public int getShowRowSize() {
        return 4;
    }

    public int getNumberOfItemsToShow() {
        int count = this.size();
        int maxShowCount = this.getMaxShowSize();
        int rowSize = this.getShowRowSize();
        int adjCount = count > maxShowCount ? maxShowCount - 1 : maxShowCount;
        int remainder = count % rowSize;
        int filled = remainder == 0 ? 0 : rowSize - remainder;
        return Math.min(count, adjCount - filled);
    }

    public boolean equals(Object obj) {
        boolean bl;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof KeyringContents)) {
            bl = false;
        } else {
            KeyringContents contents = (KeyringContents)obj;
            bl = class_1799.method_57362(this.items, contents.items);
        }
        return bl;
    }

    public int hashCode() {
        return class_1799.method_57361(this.items);
    }

    public String toString() {
        return "KeyringContents" + String.valueOf(this.items);
    }

    public static class Mutable {
        private final List<class_1799> items;
        private int selectedItem;

        public Mutable(KeyringContents contents) {
            this.items = new ArrayList<class_1799>(contents.items);
            this.selectedItem = contents.selectedItem;
        }

        public int size() {
            return this.items.size();
        }

        public Mutable clearItems() {
            this.items.clear();
            this.selectedItem = -1;
            return this;
        }

        private int findStackIndex(class_1799 stack) {
            for (int i = 0; i < this.items.size(); ++i) {
                if (!class_1799.method_31577((class_1799)this.items.get(i), (class_1799)stack)) continue;
                return i;
            }
            return -1;
        }

        private int getMaxAmountToAdd(class_1799 stack) {
            return 1;
        }

        public int tryInsert(class_1799 stack) {
            if (stack.method_7960() || !(stack.method_7909() instanceof ItemKey)) {
                return 0;
            }
            int toAdd = Math.min(stack.method_7947(), this.getMaxAmountToAdd(stack));
            if (toAdd == 0) {
                return 0;
            }
            int index = this.findStackIndex(stack);
            if (index >= 0) {
                return 0;
            }
            this.items.add(0, stack.method_7971(toAdd));
            return toAdd;
        }

        public int tryTransfer(class_1735 slot, class_1657 player) {
            class_1799 stack = slot.method_7677();
            int toAdd = this.getMaxAmountToAdd(stack);
            return this.tryInsert(slot.method_32753(stack.method_7947(), toAdd, player));
        }

        public void toggleSelectedItem(int index) {
            this.selectedItem = this.selectedItem != index && !this.indexIsOutsideAllowedBounds(index) ? index : -1;
        }

        private boolean indexIsOutsideAllowedBounds(int index) {
            return index < 0 || index >= this.items.size();
        }

        @Nullable
        public class_1799 removeOne() {
            if (this.items.isEmpty()) {
                return null;
            }
            return this.items.remove(0).method_7972();
        }

        public KeyringContents toImmutable() {
            return new KeyringContents(List.copyOf(this.items));
        }
    }
}

