/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.api.capabilities;

import java.util.function.Predicate;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import org.jetbrains.annotations.NotNull;

public interface IItemRepository {
    @NotNull
    public class_2371<ItemRecord> getAllItems();

    @NotNull
    public class_1799 insertItem(@NotNull class_1799 var1, boolean var2, Predicate<class_1799> var3);

    @NotNull
    default public class_1799 insertItem(@NotNull class_1799 stack, boolean simulate) {
        return this.insertItem(stack, simulate, null);
    }

    @NotNull
    public class_1799 extractItem(@NotNull class_1799 var1, int var2, boolean var3, Predicate<class_1799> var4);

    @NotNull
    default public class_1799 extractItem(@NotNull class_1799 stack, int amount, boolean simulate) {
        return this.extractItem(stack, amount, simulate, null);
    }

    default public int getStoredItemCount(@NotNull class_1799 stack, Predicate<class_1799> predicate) {
        class_1799 amount = this.extractItem(stack, Integer.MAX_VALUE, true, predicate);
        return amount.method_7947();
    }

    default public int getStoredItemCount(@NotNull class_1799 stack) {
        return this.getStoredItemCount(stack, null);
    }

    default public int getRemainingItemCapacity(@NotNull class_1799 stack, Predicate<class_1799> predicate) {
        stack = stack.method_7972();
        stack.method_7939(Integer.MAX_VALUE);
        class_1799 remainder = this.insertItem(stack, true, predicate);
        return Integer.MAX_VALUE - remainder.method_7947();
    }

    default public int getRemainingItemCapacity(@NotNull class_1799 stack) {
        return this.getRemainingItemCapacity(stack, null);
    }

    default public int getItemCapacity(@NotNull class_1799 stack, Predicate<class_1799> predicate) {
        long capacity = (long)this.getStoredItemCount(stack, predicate) + (long)this.getRemainingItemCapacity(stack, predicate);
        if (capacity > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)capacity;
    }

    default public int getItemCapacity(@NotNull class_1799 stack) {
        return this.getItemCapacity(stack, null);
    }

    public static interface DefaultPredicate<T>
    extends Predicate<T> {
    }

    public static class ItemRecord {
        @NotNull
        public final class_1799 itemPrototype;
        public final int count;

        public ItemRecord(@NotNull class_1799 itemPrototype, int count) {
            this.itemPrototype = itemPrototype;
            this.count = count;
        }
    }
}

