/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.inventory;

import com.google.common.collect.Iterators;
import com.tom.storagemod.inventory.IInventoryAccess;
import com.tom.storagemod.inventory.IProxy;
import com.tom.storagemod.inventory.InventoryChangeTracker;
import com.tom.storagemod.inventory.InventoryImage;
import com.tom.storagemod.inventory.StoredItemStack;
import com.tom.storagemod.inventory.filter.IFilter;
import com.tom.storagemod.util.Priority;
import java.util.Iterator;
import java.util.Set;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.BlankVariantView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.FilteringStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import net.minecraft.class_1937;

public class PlatformFilteredInventoryAccess
extends FilteringStorage<ItemVariant>
implements IInventoryAccess,
Priority.IPriority {
    private BlankVariantView<ItemVariant> nullSlot = new BlankVariantView((TransferVariant)ItemVariant.blank(), 0L);
    private final IInventoryAccess acc;
    private final IFilter filter;
    private final InventoryChangeTracker tracker;

    public PlatformFilteredInventoryAccess(IInventoryAccess acc, final IFilter filter) {
        super(acc::getPlatformHandler);
        this.acc = acc;
        this.filter = filter;
        this.tracker = new InventoryChangeTracker((Storage)acc.getPlatformHandler()){

            @Override
            protected boolean checkFilter(StoredItemStack stack) {
                return filter.getItemPred().test(stack);
            }

            @Override
            protected int getCount(StorageView<ItemVariant> is) {
                return (int)(filter.isKeepLast() ? is.getAmount() - 1L : is.getAmount());
            }

            @Override
            protected int getCount(InventoryImage.FabricStack is) {
                return (int)(filter.isKeepLast() ? is.count() - 1L : is.count());
            }

            @Override
            protected StorageView<ItemVariant> getSlotHandler(StorageView<ItemVariant> def) {
                FilteringStorageView s;
                if (def instanceof FilteringStorageView && (s = (FilteringStorageView)def).getOuter() == PlatformFilteredInventoryAccess.this) {
                    return def;
                }
                return new FilteringStorageView(def);
            }

            @Override
            protected Storage<ItemVariant> getSlotHandler(Storage<ItemVariant> def) {
                return PlatformFilteredInventoryAccess.this;
            }

            @Override
            public InventoryImage prepForOffThread(class_1937 level) {
                filter.getItemPred().updateState();
                return super.prepForOffThread(level);
            }

            @Override
            public long getChangeTracker(class_1937 level) {
                filter.getItemPred().updateState();
                return super.getChangeTracker(level);
            }
        };
    }

    @Override
    public IInventoryAccess.IInventoryChangeTracker tracker() {
        return this.tracker;
    }

    @Override
    public class_1799 pushStack(class_1799 stack) {
        if (!this.test(stack)) {
            return stack;
        }
        return IInventoryAccess.super.pushStack(stack);
    }

    @Override
    public class_1799 pullMatchingStack(class_1799 st, long max) {
        if (!this.test(st)) {
            return class_1799.field_8037;
        }
        return IInventoryAccess.super.pullMatchingStack(st, max);
    }

    @Override
    public int getFreeSlotCount() {
        return this.acc.getFreeSlotCount();
    }

    @Override
    public int getSlotCount() {
        return this.acc.getSlotCount();
    }

    public Storage<ItemVariant> get() {
        return this;
    }

    public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        if (!this.canExtract(resource)) {
            return 0L;
        }
        if (this.filter.isKeepLast()) {
            long maxEx;
            StorageView sv;
            Iterator itr = super.iterator();
            long amount = 0L;
            while (itr.hasNext() && ((sv = (StorageView)itr.next()).isResourceBlank() || !((ItemVariant)sv.getResource()).equals((Object)resource) || (amount += sv.extract((Object)resource, maxEx = Math.min(maxAmount - amount, sv.getAmount() - 1L), transaction)) != maxAmount)) {
            }
            return amount;
        }
        return ((Storage)this.backingStorage.get()).extract((Object)resource, maxAmount, transaction);
    }

    protected boolean canInsert(ItemVariant resource) {
        return this.inFilter(resource, 1L);
    }

    protected boolean canExtract(ItemVariant resource) {
        return this.inFilter(resource, 1L);
    }

    public Iterator<StorageView<ItemVariant>> iterator() {
        return Iterators.transform((Iterator)super.iterator(), sv -> {
            if (!this.inFilter((ItemVariant)sv.getResource(), sv.getAmount())) {
                return this.nullSlot;
            }
            return this.filter.isKeepLast() ? new FilteringStorageView((StorageView<ItemVariant>)sv) : sv;
        });
    }

    private boolean inFilter(ItemVariant resource, long cnt) {
        return this.filter.getItemPred().test(new StoredItemStack(resource.toStack(), cnt, resource.hashCode()));
    }

    @Override
    public Priority getPriority() {
        Priority pr = Priority.IPriority.get(this.acc);
        return pr.add(this.filter.getPriority());
    }

    private boolean test(class_1799 stack) {
        return this.filter.getItemPred().test(new StoredItemStack(stack, stack.method_7947()));
    }

    @Override
    public IInventoryAccess getRootHandler(Set<IProxy> dejaVu) {
        return this.acc.getRootHandler(dejaVu);
    }

    public String toString() {
        return "Filtering: {" + String.valueOf(this.acc) + "}";
    }

    public IFilter getFilter() {
        return this.filter;
    }

    public IInventoryAccess getActualInventory() {
        return this.acc;
    }

    private class FilteringStorageView
    implements StorageView<ItemVariant> {
        private StorageView<ItemVariant> delegate;

        public FilteringStorageView(StorageView<ItemVariant> delegate) {
            this.delegate = delegate;
        }

        public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
            if (PlatformFilteredInventoryAccess.this.filter.isKeepLast() && (maxAmount = Math.min(this.delegate.getAmount() - 1L, maxAmount)) < 1L) {
                return 0L;
            }
            return this.delegate.extract((Object)resource, maxAmount, transaction);
        }

        public boolean isResourceBlank() {
            return this.delegate.isResourceBlank() || PlatformFilteredInventoryAccess.this.filter.isKeepLast() && this.delegate.getAmount() == 1L;
        }

        public ItemVariant getResource() {
            return (ItemVariant)this.delegate.getResource();
        }

        public long getAmount() {
            return PlatformFilteredInventoryAccess.this.filter.isKeepLast() ? this.delegate.getAmount() - 1L : this.delegate.getAmount();
        }

        public long getCapacity() {
            return PlatformFilteredInventoryAccess.this.filter.isKeepLast() && !this.delegate.isResourceBlank() ? this.delegate.getCapacity() - 1L : this.delegate.getCapacity();
        }

        public StorageView<ItemVariant> getUnderlyingView() {
            return this.delegate.getUnderlyingView();
        }

        public PlatformFilteredInventoryAccess getOuter() {
            return PlatformFilteredInventoryAccess.this;
        }
    }
}

