/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.trimmable.tools.resource;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import dev.worldgen.trimmable.tools.TrimmableTools;
import dev.worldgen.trimmable.tools.config.ConfigHandler;
import dev.worldgen.trimmable.tools.config.ToolTags;
import dev.worldgen.trimmable.tools.config.TrimData;
import dev.worldgen.trimmable.tools.resource.ClientTrim;
import dev.worldgen.trimmable.tools.resource.TrimmedItemModel;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.class_10430;
import net.minecraft.class_10439;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3298;
import net.minecraft.class_3518;
import net.minecraft.class_7654;
import org.apache.commons.io.IOUtils;

public class TrimmableToolsResourceHelper {
    private static final Gson GSON = new Gson();
    private static final class_7654 MODEL_LISTER = class_7654.method_45114((String)"models");

    public static void addAllTrimOverrides(Map<class_2960, class_3298> models) {
        for (Map.Entry<class_2960, class_3298> entry : new HashSet<Map.Entry<class_2960, class_3298>>(models.entrySet())) {
            class_2960 rawId = entry.getKey();
            class_2960 prefixedId = MODEL_LISTER.method_45115(rawId);
            class_2960 itemId = TrimmableTools.id(prefixedId.method_12836(), prefixedId.method_12832().substring(5));
            class_2960 toolType = ToolTags.getToolType(itemId);
            if (toolType.equals((Object)ToolTags.UNKNOWN)) continue;
            try {
                BufferedReader reader = entry.getValue().method_43039();
                try {
                    JsonObject json = class_3518.method_15255((Reader)reader);
                    String parent = class_3518.method_15265((JsonObject)json, (String)"parent");
                    JsonObject textures = class_3518.method_15296((JsonObject)json, (String)"textures");
                    String layer0 = class_3518.method_15265((JsonObject)textures, (String)"layer0");
                    for (String pattern : TrimData.patterns()) {
                        for (String rawMaterial : TrimData.materials()) {
                            String material = ConfigHandler.getMaterialName(itemId, rawMaterial);
                            class_2960 rawModelId = MODEL_LISTER.method_45112(TrimmableToolsResourceHelper.createTrimmedId(prefixedId, pattern, material));
                            models.put(rawModelId, TrimmableToolsResourceHelper.createTrimModel(entry.getValue().method_45304(), parent, layer0, toolType, pattern, material));
                        }
                    }
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (JsonSyntaxException reader) {
            }
            catch (Exception e) {
                TrimmableTools.LOGGER.error("Couldn't load trimmable tool data from model {}", (Object)rawId, (Object)e);
            }
        }
    }

    private static class_2960 createTrimmedId(class_2960 id, String pattern, String material) {
        return id.method_48331(String.format("_%s_%s", pattern, material));
    }

    private static class_3298 createTrimModel(class_3262 pack, String parent, String layer0, class_2960 toolType, String pattern, String material) {
        JsonObject textures = new JsonObject();
        textures.addProperty("layer0", layer0);
        textures.addProperty("layer1", String.format("%s:trims/items/%s/%s_%s", toolType.method_12836(), toolType.method_12832(), pattern, material));
        JsonObject json = new JsonObject();
        json.addProperty("parent", parent);
        json.add("textures", (JsonElement)textures);
        return new class_3298(pack, () -> IOUtils.toInputStream((String)GSON.toJson((JsonElement)json), (String)"UTF-8"));
    }

    public static TrimmedItemModel.Unbaked createItemModel(class_2960 itemId, class_10439.class_10441 wrapped) {
        Object2ObjectOpenHashMap cases = new Object2ObjectOpenHashMap();
        for (class_2960 material : TrimData.MATERIALS) {
            for (class_2960 pattern : TrimData.PATTERNS) {
                class_2960 id = TrimmableToolsResourceHelper.createTrimmedId(itemId.method_45138("item/"), pattern.method_12832(), ConfigHandler.getMaterialName(itemId, material.method_12832()));
                cases.put((Object)new ClientTrim(material, pattern), (Object)new class_10430.class_10431(id, List.of()));
            }
        }
        return new TrimmedItemModel.Unbaked((Object2ObjectMap<ClientTrim, class_10439.class_10441>)cases, itemId, wrapped);
    }
}

